/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.response.vhim400;

import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.request.ErrorSectionHelperInterface;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FlatErrorSectionHelper
implements ErrorSectionHelperInterface {
    @Override
    public Document buildErrorSection(Document clinicalDataDocument, ExceptionInfo exceptionInfo, String requestId) {
        Element errorSectionElement = clinicalDataDocument.getRootElement().element("errorSection");
        if (errorSectionElement == null) {
            errorSectionElement = DocumentHelper.createElement((String)"errorSection");
            clinicalDataDocument.getRootElement().add(errorSectionElement);
        }
        this.addErrorToErrorSection(errorSectionElement, exceptionInfo, requestId);
        return clinicalDataDocument;
    }

    @Override
    public int getErrorCount(ErrorSectionHelperInterface.ErrorType errorType, Document clinicalDataDocument) {
        Element errorSection = clinicalDataDocument.getRootElement().element("errorSection");
        if (errorSection != null) {
            int warnings = errorSection.elements("warnings").size();
            int errors = errorSection.elements("errors").size();
            int fatals = errorSection.elements("fatalErrors").size();
            switch (errorType) {
                case WARNING: {
                    return warnings;
                }
                case ERROR: {
                    return errors;
                }
                case FATAL: {
                    return fatals;
                }
            }
            return warnings + errors + fatals;
        }
        return 0;
    }

    private void addErrorToErrorSection(Element errorSectionElement, ExceptionInfo exceptionInfo, String requestId) {
        Element errorElement = this.getErrorElementForSeverity(exceptionInfo.getErrorCode().getLoggingSeverity());
        errorElement.addElement("errorId").addText(requestId);
        errorElement.addElement("exception").addText(exceptionInfo.getException().getClass().getName());
        errorElement.addElement("exceptionMessage").addText(exceptionInfo.getException().getMessage());
        errorElement.addElement("errorCode").addText(exceptionInfo.getErrorCode().name());
        errorElement.addElement("displayMessage").addText(exceptionInfo.getClientMessage());
        errorSectionElement.add(errorElement);
    }

    private Element getErrorElementForSeverity(LoggingSeverity loggingSeverity) {
        if (loggingSeverity == null) {
            loggingSeverity = LoggingSeverity.FATAL;
        }
        switch (loggingSeverity) {
            case WARNING: {
                return DocumentHelper.createElement((String)"warnings");
            }
            case ERROR: {
                return DocumentHelper.createElement((String)"errors");
            }
        }
        return DocumentHelper.createElement((String)"fatalErrors");
    }
}

