/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.response.organizer;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.response.organizer.ResponseOrganazerException;
import gov.va.med.cds.response.organizer.ResponseOrganizerInterface;
import gov.va.med.cds.response.organizer.strategy.OrderingStrategyInterface;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ResponseOrganizer
implements ResponseOrganizerInterface {
    private static final String DOMAIN_ENTRY_POINT = "domainEntryPoint";
    private static final String ENTRY_POINT_FILTER = "entryPointFilter";
    private static final String XQUERY_EXPRESSION = "xqueryExpression";
    private static final String ORDER_BY = "orderBy";
    OrderingStrategyInterface orderingStrategy;

    @Override
    public Document organize(String xmlFilterRequest, Document responseDocument) {
        Element entryPointFilter = this.getEntyPointFilterElement(xmlFilterRequest);
        if (this.isSortNeeded(entryPointFilter)) {
            String sortExpression = entryPointFilter.element(ORDER_BY).elementText(XQUERY_EXPRESSION);
            String domainEntryPoint = entryPointFilter.elementText(DOMAIN_ENTRY_POINT);
            responseDocument = this.orderingStrategy.order(sortExpression, domainEntryPoint, responseDocument);
        }
        return responseDocument;
    }

    private Element getEntyPointFilterElement(String xmlFilterRequest) {
        try {
            Document a = DocumentHelper.parseText((String)xmlFilterRequest);
            return a.getRootElement().element(ENTRY_POINT_FILTER);
        }
        catch (DocumentException e) {
            throw new ResponseOrganazerException(ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION, e, xmlFilterRequest);
        }
    }

    private boolean isSortNeeded(Element entryPointFilter) {
        return entryPointFilter.element(ORDER_BY) != null;
    }

    public OrderingStrategyInterface getOrderingStrategy() {
        return this.orderingStrategy;
    }

    public void setOrderingStrategy(OrderingStrategyInterface orderingStrategy) {
        this.orderingStrategy = orderingStrategy;
    }
}

