/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.response;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.clinicaldata.vhim400.ConfigurablePathwaysDataResponse;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.response.AggregatorNodeSpecification;
import gov.va.med.cds.response.ResponseAggregatorException;
import gov.va.med.cds.response.ResponseAggregatorInterface;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class ParameterizedResponseAggregator
implements ResponseAggregatorInterface {
    private ClinicalDataResponseInterface clinicalDataResponse;
    private Map<String, List<AggregatorNodeSpecification>> aggregatedChildMap = new Hashtable<String, List<AggregatorNodeSpecification>>();

    public ParameterizedResponseAggregator(ClinicalDataResponseInterface clinicalDataResponse, Map<String, List<AggregatorNodeSpecification>> aggregatedChildMap) {
        this.clinicalDataResponse = clinicalDataResponse;
        this.aggregatedChildMap = aggregatedChildMap;
    }

    @Override
    public Document aggregateResponses(List<Document> readResponseDocuments) throws ResponseAggregatorException {
        try {
            if (readResponseDocuments == null || readResponseDocuments.isEmpty()) {
                throw new ResponseAggregatorException(ErrorCodeEnum.XML_AGGREGATION_ZERO_INPUT_SOURCES);
            }
            Document aggregatedResponseDocument = this.buildBaseResponseDocument(readResponseDocuments);
            Hashtable<String, ArrayList<Element>> aggregated = new Hashtable<String, ArrayList<Element>>();
            ArrayList<Element> aggregatedElements = null;
            for (Document responseDocument : readResponseDocuments) {
                for (String childName : this.aggregatedChildMap.keySet()) {
                    Element childToAggregate = this.clinicalDataResponse.getChildElement(responseDocument, childName);
                    if (childToAggregate == null) continue;
                    for (AggregatorNodeSpecification nodeSpec : this.aggregatedChildMap.get(childName)) {
                        aggregatedElements = (ArrayList<Element>)aggregated.get(childName);
                        if (aggregatedElements == null) {
                            aggregatedElements = new ArrayList<Element>();
                            aggregated.put(childName, aggregatedElements);
                        }
                        List children = childToAggregate.elements(nodeSpec.getNodeName());
                        for (Element child : children) {
                            this.addToElements(aggregatedElements, child, nodeSpec.consolodate());
                        }
                    }
                }
            }
            for (String childName : aggregated.keySet()) {
                Element parent = this.clinicalDataResponse.getChildElement(aggregatedResponseDocument, childName, true);
                for (Element child : (List)aggregated.get(childName)) {
                    parent.add(child);
                }
            }
            return aggregatedResponseDocument;
        }
        catch (Throwable t) {
            throw new ResponseAggregatorException(ErrorCodeEnum.XML_AGGREGATION_FAILED, t);
        }
    }

    private Document buildBaseResponseDocument(List<Document> documents) {
        String templateId = null;
        String requestId = null;
        String nationalId = null;
        for (Document d : documents) {
            Element templateIdElement;
            if ((templateId == null || templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId())) && (templateId = (templateIdElement = this.clinicalDataResponse.getTemplateId(d)).getText()) != null && !templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId()) && requestId != null && nationalId != null) break;
            if (requestId == null) {
                Element requestIdElement = this.clinicalDataResponse.getRequestId(d);
                if (requestIdElement != null) {
                    requestId = requestIdElement.getText();
                }
                if (templateId != null && !templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId()) && requestId != null && nationalId != null) break;
            }
            if (nationalId != null) continue;
            Element requestedNationalIdElement = this.clinicalDataResponse.getRequestedNationalId(d);
            if (requestedNationalIdElement != null) {
                nationalId = requestedNationalIdElement.getText();
            }
            if (templateId == null || templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId()) || requestId == null || nationalId == null) continue;
            break;
        }
        Document response = null;
        response = this.clinicalDataResponse instanceof ConfigurablePathwaysDataResponse ? ((ConfigurablePathwaysDataResponse)this.clinicalDataResponse).buildEmptyPathwaysDocumentWithPatient(templateId, requestId) : this.clinicalDataResponse.buildEmptyClinicalDocumentWithPatient(templateId, requestId);
        if (nationalId != null) {
            this.clinicalDataResponse.addRequestedNationalId(response, nationalId);
        }
        return response;
    }

    private void addToElements(List<Element> aggregated, Element element, boolean consolodate) {
        if (consolodate) {
            Element consolodated = this.findElementByName(aggregated, element.getName());
            if (consolodated == null) {
                aggregated.add((Element)element.detach());
            } else {
                for (Element child : element.elements()) {
                    consolodated.add(child.detach());
                }
            }
        } else {
            aggregated.add((Element)element.detach());
        }
    }

    private Element findElementByName(List<Element> elements, String name) {
        for (Element e : elements) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }
}

