/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.response;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.response.LabAggregatorNodeSpecification;
import gov.va.med.cds.response.ResponseAggregatorException;
import gov.va.med.cds.response.ResponseAggregatorInterface;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class ParameterizedLabResponseAggregator
implements ResponseAggregatorInterface {
    private ClinicalDataResponseInterface clinicalDataResponse;
    private Map<String, List<LabAggregatorNodeSpecification>> aggregatedChildMap = new Hashtable<String, List<LabAggregatorNodeSpecification>>();

    public ParameterizedLabResponseAggregator(ClinicalDataResponseInterface clinicalDataResponse, Map<String, List<LabAggregatorNodeSpecification>> aggregatedChildMap) {
        this.clinicalDataResponse = clinicalDataResponse;
        this.aggregatedChildMap = aggregatedChildMap;
    }

    @Override
    public Document aggregateResponses(List<Document> readResponseDocuments) throws ResponseAggregatorException {
        try {
            if (readResponseDocuments == null || readResponseDocuments.isEmpty()) {
                throw new ResponseAggregatorException(ErrorCodeEnum.XML_AGGREGATION_ZERO_INPUT_SOURCES);
            }
            if (readResponseDocuments.size() == 1) {
                return readResponseDocuments.get(0);
            }
            Document aggregatedResponseDocument = this.buildBaseResponseDocument(readResponseDocuments);
            Hashtable<String, ArrayList<Element>> aggregated = new Hashtable<String, ArrayList<Element>>();
            ArrayList<Element> aggregatedElements = null;
            for (Document responseDocument : readResponseDocuments) {
                for (String childName : this.aggregatedChildMap.keySet()) {
                    Element childToAggregate = this.clinicalDataResponse.getChildElement(responseDocument, childName);
                    if (childToAggregate == null) continue;
                    for (LabAggregatorNodeSpecification nodeSpec : this.aggregatedChildMap.get(childName)) {
                        aggregatedElements = (ArrayList<Element>)aggregated.get(childName);
                        if (aggregatedElements == null) {
                            aggregatedElements = new ArrayList<Element>();
                            aggregated.put(childName, aggregatedElements);
                        }
                        if (nodeSpec.isModifyNode()) {
                            this.modifyNode(childToAggregate, nodeSpec);
                        }
                        List children = childToAggregate.elements(nodeSpec.getNodeName());
                        for (Element child : children) {
                            this.addToElements(aggregatedElements, child, nodeSpec.consolodate());
                        }
                    }
                }
            }
            for (String childName : aggregated.keySet()) {
                Element parent = this.clinicalDataResponse.getChildElement(aggregatedResponseDocument, childName, true);
                for (Element child : (List)aggregated.get(childName)) {
                    parent.add(child);
                }
            }
            return aggregatedResponseDocument;
        }
        catch (Throwable t) {
            throw new ResponseAggregatorException(ErrorCodeEnum.XML_AGGREGATION_FAILED, t);
        }
    }

    private void modifyNode(Element childToAggregate, LabAggregatorNodeSpecification nodeSpec) {
        String childToAggregateXML = childToAggregate.asXML();
        Map nodeChangeList = nodeSpec.getFromNodetoNode();
        ArrayList<Node> labTestPromisesList = new ArrayList<Node>();
        for (Object key : nodeChangeList.keySet()) {
            for (Object tempElement : childToAggregate.selectNodes(String.valueOf(key))) {
                labTestPromisesList.add(((Node)tempElement).detach());
            }
            for (Node labTestPromisesNode : labTestPromisesList) {
                String labTestPromisesNodeXML = labTestPromisesNode.asXML();
                String labTestsOuterNodeXML = labTestPromisesNode.selectSingleNode((String)nodeChangeList.get(String.valueOf(key))).asXML();
                Node labTestOuterNode = labTestPromisesNode.selectSingleNode((String)nodeChangeList.get(String.valueOf(key))).detach();
                labTestPromisesNodeXML = labTestPromisesNode.asXML();
                for (Object labTestInnerElement : ((Element)labTestOuterNode).elements()) {
                    String labTestInnerElementXML = ((Element)labTestInnerElement).asXML();
                    ((Element)labTestPromisesNode).add(((Element)labTestInnerElement).detach());
                }
            }
            for (Node labTestsNode : labTestPromisesList) {
                childToAggregate.add(labTestsNode);
            }
        }
    }

    private Document buildBaseResponseDocument(List<Document> documents) {
        String templateId = null;
        String requestId = null;
        String nationalId = null;
        for (Document d : documents) {
            Element templateIdElement;
            if ((templateId == null || templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId())) && (templateId = (templateIdElement = this.clinicalDataResponse.getTemplateId(d)).getText()) != null && !templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId()) && requestId != null && nationalId != null) break;
            if (requestId == null) {
                Element requestIdElement = this.clinicalDataResponse.getRequestId(d);
                if (requestIdElement != null) {
                    requestId = requestIdElement.getText();
                }
                if (templateId != null && !templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId()) && requestId != null && nationalId != null) break;
            }
            if (nationalId != null) continue;
            Element requestedNationalIdElement = this.clinicalDataResponse.getRequestedNationalId(d);
            if (requestedNationalIdElement != null) {
                nationalId = requestedNationalIdElement.getText();
            }
            if (templateId == null || templateId.equals(this.clinicalDataResponse.getErrorResponseTemplateId()) || requestId == null || nationalId == null) continue;
            break;
        }
        Document response = this.clinicalDataResponse.buildEmptyClinicalDocumentWithPatient(templateId, requestId);
        if (nationalId != null) {
            this.clinicalDataResponse.addRequestedNationalId(response, nationalId);
        }
        return response;
    }

    private void addToElements(List<Element> aggregated, Element element, boolean consolodate) {
        if (consolodate) {
            Element consolodated = this.findElementByName(aggregated, element.getName());
            if (consolodated == null) {
                aggregated.add((Element)element.detach());
            } else {
                for (Element child : element.elements()) {
                    consolodated.add(child.detach());
                }
            }
        } else {
            aggregated.add((Element)element.detach());
        }
    }

    private Element findElementByName(List<Element> elements, String name) {
        for (Element e : elements) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }
}

