/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.request.vista.write;

import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.filter.QueryParameter;
import gov.va.med.cds.request.ValidationException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class CdsWriteData
implements EntryFilterInterface {
    private Long timeout = new Long(600L);
    private boolean isPatientCentricFilter = true;
    private String facilityId = null;
    private String templateId = null;
    private String requestId = null;
    private String domainEntryPoint = null;
    private Element domainEntryPointElement = null;
    List<PersonIdentifierInterface> personIdentifiers = null;
    private static final String XS_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private Map<String, Object> dataMap;

    public CdsWriteData(Element domainEntryPointElement, String templateId, String requestId, String domainEntryPoint, List<PersonIdentifierInterface> personIdentifiers) {
        this.templateId = templateId;
        this.domainEntryPoint = domainEntryPoint;
        this.requestId = requestId;
        this.domainEntryPointElement = domainEntryPointElement;
        this.personIdentifiers = personIdentifiers;
        this.extractAdditionalParameters();
    }

    @Override
    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    protected void extractAdditionalParameters() {
        List dataList = this.domainEntryPointElement.elements();
        String name = null;
        String value = null;
        this.dataMap = new HashMap<String, Object>();
        for (Element data : dataList) {
            if (data.getName().equals("patient")) {
                PersonIdentifier patientIdentifier = new PersonIdentifier();
                Element identitifier = data.element("identifier");
                patientIdentifier.setAssigningAuthority(identitifier.element("assigningAuthority").getTextTrim());
                if (patientIdentifier.getAssigningAuthority() == null || patientIdentifier.getAssigningAuthority().isEmpty()) {
                    throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_ASSIGNING_AUTHORITY);
                }
                patientIdentifier.setAssigningFacility(identitifier.element("assigningFacility").getTextTrim());
                if (patientIdentifier.getAssigningFacility() == null || patientIdentifier.getAssigningFacility().isEmpty()) {
                    throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_ASSIGNING_FACILITY);
                }
                patientIdentifier.setIdentity(identitifier.element("identity").getTextTrim());
                if (patientIdentifier.getIdentity() == null || patientIdentifier.getIdentity().isEmpty()) {
                    throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_IDENTITY);
                }
                this.dataMap.put("pidInfo", patientIdentifier);
                continue;
            }
            name = data.getName();
            value = data.getTextTrim();
            this.dataMap.put(name, value);
        }
    }

    @Override
    public boolean isPatientCentricFilter() {
        return this.isPatientCentricFilter;
    }

    public EntryFilterInterface getEntryFilter(String queryName) {
        return null;
    }

    @Override
    public boolean isSiteCentricFilter() {
        boolean siteCentric = false;
        if (!this.isPatientCentricFilter()) {
            siteCentric = this.facilityId != null;
        }
        return siteCentric;
    }

    @Override
    public Calendar getStartDate() {
        return null;
    }

    @Override
    public Calendar getEndDate() {
        return null;
    }

    @Override
    public List<String> getRecordIdentifiers() {
        return null;
    }

    @Override
    public String getXpathQuery() {
        return null;
    }

    @Override
    public String getJsonPathQuery() {
        return null;
    }

    @Override
    public String getQueryName() {
        return null;
    }

    @Override
    public boolean useDates() {
        return false;
    }

    @Override
    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public String getFacilityId() {
        return null;
    }

    @Override
    public String getXpathFilterExpression() {
        return null;
    }

    @Override
    public String getXpathExtractExpression() {
        return null;
    }

    @Override
    public boolean isCountOnly() {
        return false;
    }

    @Override
    public int getPageNumber() {
        return 0;
    }

    @Override
    public int getPageSize() {
        return 0;
    }

    @Override
    public boolean isPagingFilter() {
        return false;
    }

    @Override
    public boolean hasRecordIdentifiers() {
        return false;
    }

    @Override
    public boolean containsXpathFilterExpression() {
        return false;
    }

    @Override
    public String getXpathExtractExpressionNamespace() {
        return null;
    }

    @Override
    public String getXpathFilterExpressionNamespace() {
        return null;
    }

    private QueryParameter<Map<String, Calendar>> extractDateRangeParameter(Element additionalParameter) {
        QueryParameter<HashMap<String, Calendar>> queryParameter = null;
        List elements = additionalParameter.elements();
        if (elements != null && elements.size() > 0 && elements.size() < 3) {
            Element beginDateElement = (Element)elements.get(0);
            Element endDateElement = (Element)elements.get(1);
            HashMap<String, Calendar> valueMap = new HashMap<String, Calendar>();
            queryParameter = new QueryParameter<HashMap<String, Calendar>>();
            queryParameter.setName(additionalParameter.attributeValue("name"));
            queryParameter.setValue(valueMap);
            Calendar c = null;
            if (beginDateElement != null) {
                c = this.extractCalendar(beginDateElement, -1);
                valueMap.put("begin", c);
            }
            if (endDateElement != null) {
                c = this.extractCalendar(endDateElement, 1);
                valueMap.put("end", c);
            }
        }
        return queryParameter;
    }

    private Calendar extractCalendar(Element dateElement, int dayOffset) {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(XS_DATE_FORMAT_PATTERN);
        Calendar c = null;
        if (dateElement != null) {
            String dateString = dateElement.getTextTrim();
            c = this.extractDate(dateString, xmlDateFormat);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.add(5, dayOffset);
        }
        return c;
    }

    private Calendar extractDate(String dateString, DateFormat dateFormatter) {
        try {
            Date dateFromString = dateFormatter.parse(dateString);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateFromString);
            return cal;
        }
        catch (ParseException e) {
            throw new ValidationException(ErrorCodeEnum.CANNOT_PARSE_DATE, dateString);
        }
    }

    private QueryParameter<List<String>> extractListTypeParameter(List<Element> valueElements) {
        ArrayList<String> values = new ArrayList<String>();
        QueryParameter<List<String>> queryParameter = new QueryParameter<List<String>>();
        queryParameter.setValue(values);
        for (Element valueElement : valueElements) {
            values.add(valueElement.getTextTrim());
        }
        return queryParameter;
    }

    public Set<String> getFilterParameterNames() {
        HashSet<String> parameterNames = new HashSet<String>();
        if (this.dataMap != null && this.dataMap.size() > 0) {
            parameterNames.addAll(this.dataMap.keySet());
        }
        return parameterNames;
    }

    public Object getParameterValue(String parameterName) {
        return this.dataMap.get(parameterName);
    }

    @Override
    public List<PersonIdentifierInterface> getPersonIdentifiers() {
        ArrayList<PersonIdentifierInterface> pidsList = new ArrayList<PersonIdentifierInterface>();
        pidsList.add((PersonIdentifierInterface)this.dataMap.get("pidInfo"));
        return pidsList;
    }

    @Override
    public String getDomainEntryPoint() {
        return this.domainEntryPoint;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public ParameterMapInterface getAdditionalParametersMap() {
        return null;
    }
}

