/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.request.vista.write;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.vista.write.CdsWriteData;
import gov.va.med.cds.request.vista.write.CdsWriteInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class CdsWrite
implements CdsWriteInterface {
    private String templateId;
    private DomainEntryPoint domainEntryPoint;
    private String requestId;
    private Element parentDataElement;
    private List<PersonIdentifierInterface> personIdentifiers = null;
    private List<EntryFilterInterface> writeData = null;
    private String entryPointElement = null;
    private Map<String, String> templateEntryPointMap = null;

    public void setTemplateEntryPointMap(Map<String, String> templateEntryPointMap) {
        this.templateEntryPointMap = templateEntryPointMap;
    }

    public List<EntryFilterInterface> getWriteData() {
        return this.writeData;
    }

    @Override
    public void extractData() {
        List dataElementsList = this.parentDataElement.elements(this.templateEntryPointMap.get(String.format("%s-%s", this.templateId, this.domainEntryPoint.getName())));
        this.extractPatientIdentifiers(dataElementsList);
        this.extractCreateData(dataElementsList);
    }

    @Override
    public void setDomainEntryPoint(DomainEntryPoint domainEntryPoint) {
        this.domainEntryPoint = domainEntryPoint;
    }

    @Override
    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @Override
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public List<PersonIdentifierInterface> getPersonIdentifiers() {
        return this.personIdentifiers;
    }

    @Override
    public String getDomainEntryPoint() {
        return this.domainEntryPoint.getName();
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    private void extractPatientIdentifiers(List<Element> accessEventElementsList) {
        PersonIdentifier patientIdentifier = new PersonIdentifier();
        this.personIdentifiers = new ArrayList<PersonIdentifierInterface>();
        for (Element accessEvent : accessEventElementsList) {
            Element patient = accessEvent.element("patient");
            if (patient == null) {
                throw new ValidationException(ErrorCodeEnum.NO_PATIENT_IDS_REQUESTED);
            }
            Element identitifier = patient.element("identifier");
            patientIdentifier.setAssigningAuthority(identitifier.element("assigningAuthority").getTextTrim());
            if (patientIdentifier.getAssigningAuthority() == null || patientIdentifier.getAssigningAuthority().isEmpty()) {
                throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_ASSIGNING_AUTHORITY);
            }
            patientIdentifier.setAssigningFacility(identitifier.element("assigningFacility").getTextTrim());
            if (patientIdentifier.getAssigningFacility() == null || patientIdentifier.getAssigningFacility().isEmpty()) {
                throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_ASSIGNING_FACILITY);
            }
            patientIdentifier.setIdentity(identitifier.element("identity").getTextTrim());
            if (patientIdentifier.getIdentity() == null || patientIdentifier.getIdentity().isEmpty()) {
                throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_IDENTITY);
            }
            this.personIdentifiers.add((PersonIdentifierInterface)patientIdentifier);
        }
    }

    @Override
    public List<EntryFilterInterface> getCreateData() {
        return this.writeData;
    }

    private void extractCreateData(List<Element> dataList) {
        this.writeData = new ArrayList<EntryFilterInterface>();
        for (Element record : dataList) {
            CdsWriteData dataObj = new CdsWriteData(record, this.templateId, this.requestId, this.domainEntryPoint.getName(), this.personIdentifiers);
            this.writeData.add(dataObj);
        }
    }

    @Override
    public void setEntryPointElement(String entryPointElement) {
        this.entryPointElement = entryPointElement;
    }

    @Override
    public void setDataElement(Element parentDataElement) {
        this.parentDataElement = parentDataElement;
    }
}

