/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.request;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.FilterValidatorInterface;
import gov.va.med.cds.internal.ClinicalDataServiceSynchronousInternalInterface;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.ResponseValidatorMBeanInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.template.TemplateHelperInterface;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.util.StringUtils;

public class TemplateRequestProcessor
implements RequestProcessorInterface,
ResponseValidatorMBeanInterface {
    private static final int MAX_TEMPLATE_ID_LENGTH = 128;
    private static final int MAX_CUAD_REQUEST_LENGTH = 1000000;
    private static final int MAX_FILTER_REQUEST_LENGTH = 10000;
    private static final int MAX_FILTER_ID_LENGTH = 128;
    private static final int MAX_REQUEST_ID_LENGTH = 256;
    private static final String TEMPLATE_ID_PARAMETER_NAME = "TemplateId ";
    private static final String CUAD_REQUEST_PARAMETER_NAME = "CUADRequestXML ";
    private static final String FILTER_REQUEST_PARAMETER_NAME = "FilterRequestXML ";
    private static final String FILTER_ID_PARAMETER_NAME = "FilterId ";
    private static final String REQUEST_ID_PARAMETER_NAME = "RequestId ";
    private ClinicalDataServiceSynchronousInternalInterface delegatingClinicalDataServiceSynchronousInternal = null;
    private TemplateHelperInterface templateHelper;
    private FilterValidatorInterface filterManager;
    private boolean validateReadResponseXML = false;
    private List<String> vistaCreateTemplateIdsList;

    @Override
    public Document readClinicalData(String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId) {
        Document responseDocument = null;
        try {
            this.checkForNullReadParameters(aTemplateId, aFilterId, aFilterRequest, aRequestId);
            this.checkReadParameterLengths(aTemplateId, aFilterId, aFilterRequest, aRequestId);
            responseDocument = DocumentHelper.createDocument();
            this.filterManager.validateFilterXml(aFilterId, aFilterRequest);
            List<Document> readResponses = this.delegatingClinicalDataServiceSynchronousInternal.readClinicalData(aFilterRequest, aFilterId, aTemplateId, aRequestId);
            responseDocument = this.templateHelper.getResponseAggregator(aTemplateId).aggregateResponses(readResponses);
            responseDocument = this.templateHelper.getResponseSequencer(aTemplateId).sequence(aTemplateId, responseDocument, this.validateReadResponseXML);
            responseDocument = this.templateHelper.getResponseOrganizer(aTemplateId) != null ? this.templateHelper.getResponseOrganizer(aTemplateId).organize(aFilterRequest, responseDocument) : responseDocument;
        }
        catch (Exception e) {
            responseDocument = this.processException(e, aTemplateId, aFilterRequest, aFilterId, aRequestId, this.templateHelper.getApplicationName(aTemplateId));
        }
        return responseDocument;
    }

    private void checkForNullReadParameters(String aTemplateId, String aFilterId, String aFilterRequest, String aRequestId) {
        StringBuffer nullParams = new StringBuffer();
        if (!StringUtils.hasText((String)aTemplateId)) {
            nullParams.append(TEMPLATE_ID_PARAMETER_NAME);
        }
        if (!StringUtils.hasText((String)aFilterId)) {
            nullParams.append(FILTER_ID_PARAMETER_NAME);
        }
        if (!StringUtils.hasText((String)aFilterRequest)) {
            nullParams.append(FILTER_REQUEST_PARAMETER_NAME);
        }
        if (!StringUtils.hasText((String)aRequestId)) {
            nullParams.append(REQUEST_ID_PARAMETER_NAME);
        }
        if (nullParams.length() > 0) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_INPUT_PARAMETERS_NULL, nullParams.toString());
        }
    }

    private void checkForNullCUADParameters(String aCUADRequest, String aTemplateId, String aRequestId) {
        StringBuffer nullParams = new StringBuffer();
        if (!StringUtils.hasText((String)aCUADRequest)) {
            nullParams.append(CUAD_REQUEST_PARAMETER_NAME);
        }
        if (!StringUtils.hasText((String)aTemplateId)) {
            nullParams.append(TEMPLATE_ID_PARAMETER_NAME);
        }
        if (!StringUtils.hasText((String)aRequestId)) {
            nullParams.append(REQUEST_ID_PARAMETER_NAME);
        }
        if (nullParams.length() > 0) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_INPUT_PARAMETERS_NULL, nullParams.toString());
        }
    }

    private void checkReadParameterLengths(String aTemplateId, String aFilterId, String aFilterRequest, String aRequestId) {
        StringBuffer nullParams = new StringBuffer();
        if (aTemplateId.length() > 128) {
            nullParams.append(TEMPLATE_ID_PARAMETER_NAME);
        }
        if (aFilterId.length() > 128) {
            nullParams.append(FILTER_ID_PARAMETER_NAME);
        }
        if (aFilterRequest.length() > 10000) {
            nullParams.append(FILTER_REQUEST_PARAMETER_NAME);
        }
        if (aRequestId.length() > 256) {
            nullParams.append(REQUEST_ID_PARAMETER_NAME);
        }
        if (nullParams.length() > 0) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_PARAMETERS_LENGTH_INVALID, nullParams.toString());
        }
    }

    private void checkCUADParameterLengths(String aCUADRequest, String aTemplateId, String aRequestId) {
        StringBuffer nullParams = new StringBuffer();
        if (aCUADRequest.length() > 1000000) {
            nullParams.append(CUAD_REQUEST_PARAMETER_NAME);
        }
        if (aTemplateId.length() > 128) {
            nullParams.append(TEMPLATE_ID_PARAMETER_NAME);
        }
        if (aRequestId.length() > 256) {
            nullParams.append(REQUEST_ID_PARAMETER_NAME);
        }
        if (nullParams.length() > 0) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_PARAMETERS_LENGTH_INVALID, nullParams.toString());
        }
    }

    private Document processException(Exception anException, String aTemplateId, String aRequestId, String anAppName) {
        Document errorResponseDocument = null;
        try {
            errorResponseDocument = ExceptionHandler.handleException(anException, aTemplateId, aRequestId, anAppName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorResponseDocument;
    }

    private Document processException(Exception anException, String aTemplateId, String aFilterRequest, String aFilterId, String aRequestId, String anAppName) {
        Document errorResponseDocument = null;
        try {
            errorResponseDocument = ExceptionHandler.handleException(anException, aTemplateId, aFilterRequest, aFilterId, aRequestId, anAppName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorResponseDocument;
    }

    @Override
    public Document createClinicalData(String aCreateRequest, String aTemplateId, String aRequestId) {
        Document writeResponse = null;
        try {
            this.checkForNullCUADParameters(aCreateRequest, aTemplateId, aRequestId);
            this.checkCUADParameterLengths(aCreateRequest, aTemplateId, aRequestId);
            writeResponse = this.vistaCreateTemplateIdsList.contains(aTemplateId) ? this.writeClinicalData(aCreateRequest, aTemplateId, aRequestId) : this.delegatingClinicalDataServiceSynchronousInternal.createClinicalData(aCreateRequest, aTemplateId, aRequestId);
        }
        catch (Exception e) {
            writeResponse = this.processException(e, aTemplateId, aRequestId, this.templateHelper.getApplicationName(aTemplateId));
        }
        return writeResponse;
    }

    private Document writeClinicalData(String aWritRequest, String aTemplateId, String aRequestId) {
        Document responseDocument = null;
        responseDocument = DocumentHelper.createDocument();
        List<Document> createResponses = this.delegatingClinicalDataServiceSynchronousInternal.writeClinicalData(aWritRequest, aTemplateId, aRequestId);
        responseDocument = this.templateHelper.getResponseAggregator(aTemplateId).aggregateResponses(createResponses);
        return responseDocument;
    }

    @Override
    public Document createOrUpdateClinicalData(String aCreateOrUpdateRequest, String aTemplateId, String aRequestId) {
        Document writeResponse = null;
        try {
            this.checkForNullCUADParameters(aCreateOrUpdateRequest, aTemplateId, aRequestId);
            this.checkCUADParameterLengths(aCreateOrUpdateRequest, aTemplateId, aRequestId);
            writeResponse = this.delegatingClinicalDataServiceSynchronousInternal.createClinicalData(aCreateOrUpdateRequest, aTemplateId, aRequestId);
        }
        catch (Exception e) {
            writeResponse = this.processException(e, aTemplateId, aRequestId, this.templateHelper.getApplicationName(aTemplateId));
        }
        return writeResponse;
    }

    @Override
    public Document updateClinicalData(String anUpdateRequest, String aTemplateId, String aRequestId) {
        Document writeResponse = null;
        try {
            this.checkForNullCUADParameters(anUpdateRequest, aTemplateId, aRequestId);
            this.checkCUADParameterLengths(anUpdateRequest, aTemplateId, aRequestId);
            writeResponse = this.delegatingClinicalDataServiceSynchronousInternal.updateClinicalData(anUpdateRequest, aTemplateId, aRequestId);
        }
        catch (Exception e) {
            writeResponse = this.processException(e, aTemplateId, aRequestId, this.templateHelper.getApplicationName(aTemplateId));
        }
        return writeResponse;
    }

    @Override
    public Document appendClinicalData(String anAppendRequest, String aTemplateId, String aRequestId) {
        Document writeResponse = null;
        try {
            this.checkForNullCUADParameters(anAppendRequest, aTemplateId, aRequestId);
            this.checkCUADParameterLengths(anAppendRequest, aTemplateId, aRequestId);
            writeResponse = this.delegatingClinicalDataServiceSynchronousInternal.appendClinicalData(anAppendRequest, aTemplateId, aRequestId);
        }
        catch (Exception e) {
            writeResponse = this.processException(e, aTemplateId, aRequestId, this.templateHelper.getApplicationName(aTemplateId));
        }
        return writeResponse;
    }

    @Override
    public Document deleteClinicalData(String aDeleteRequest, String aTemplateId, String aRequestId) {
        Document writeResponse = null;
        try {
            this.checkForNullCUADParameters(aDeleteRequest, aTemplateId, aRequestId);
            this.checkCUADParameterLengths(aDeleteRequest, aTemplateId, aRequestId);
            writeResponse = this.delegatingClinicalDataServiceSynchronousInternal.deleteClinicalData(aDeleteRequest, aTemplateId, aRequestId);
        }
        catch (Exception e) {
            writeResponse = this.processException(e, aTemplateId, aRequestId, this.templateHelper.getApplicationName(aTemplateId));
        }
        return writeResponse;
    }

    public void setFilterManager(FilterValidatorInterface aFilterManager) {
        this.filterManager = aFilterManager;
    }

    public void setDelegatingClinicalDataServiceSynchronousInternal(ClinicalDataServiceSynchronousInternalInterface aDelegatingClinicalDataServiceSynchronousInternal) {
        this.delegatingClinicalDataServiceSynchronousInternal = aDelegatingClinicalDataServiceSynchronousInternal;
    }

    public void setTemplateHelper(TemplateHelperInterface aTemplateHelper) {
        this.templateHelper = aTemplateHelper;
    }

    @Override
    public boolean isValidateReadResponseXML() {
        return this.validateReadResponseXML;
    }

    @Override
    public void setValidateReadResponseXML(boolean aValidateReadResponseXML) {
        this.validateReadResponseXML = aValidateReadResponseXML;
    }

    public void setVistaCreateTemplateIdsList(List<String> aVistaCreateTemplateIdsList) {
        this.vistaCreateTemplateIdsList = aVistaCreateTemplateIdsList;
    }
}

