/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.interceptor;

import gov.va.med.cds.persistence.hibernate.interceptor.DefaultInterceptor;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Required;

public class XmlTypeExtractQueryInterceptor
extends DefaultInterceptor
implements Serializable {
    private static final long serialVersionUID = -918760231184746966L;
    private String extractExpression;
    private String extractExpressionNamespace;
    private String xPathParameterName;
    private String xPathNamespaceParameterName;

    public void setExtractExpression(String extractExpression) {
        this.extractExpression = this.escapeExpression(extractExpression);
    }

    public void setExtractExpressionNamespace(String extractExpressionNamespace) {
        this.extractExpressionNamespace = this.escapeExpression(extractExpressionNamespace);
    }

    @Required
    public void setxPathParameterName(String xPathParameterName) {
        this.xPathParameterName = xPathParameterName;
    }

    @Required
    public void setxPathNamespaceParameterName(String xPathNamespaceParameterName) {
        this.xPathNamespaceParameterName = xPathNamespaceParameterName;
    }

    private String escapeExpression(String expression) {
        return expression.replaceAll("'", "''");
    }

    @Override
    public String onPrepareStatement(String sql) {
        if (this.extractExpression != null && this.extractExpression.length() > 0) {
            sql = sql.replaceFirst(this.xPathParameterName, this.extractExpression).replaceFirst(this.xPathNamespaceParameterName, this.extractExpressionNamespace);
        }
        return sql;
    }
}

