/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.common;

import gov.va.med.cds.persistence.hibernate.common.VistaPointInTimeUserTypeQuery;
import gov.va.med.cds.template.generated.basedatatypes.PointInTime;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;

public class VistaPointInTimeUserTypeQueryNoTimezone
extends VistaPointInTimeUserTypeQuery {
    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object owner) throws HibernateException, SQLException {
        String rawDate = rs.getString(names[0]);
        String namespace = rs.getString(names[1]);
        if (rawDate == null) {
            return null;
        }
        String timestamp = null;
        timestamp = rawDate.indexOf("-") > 0 ? this.formatHdrTime(rawDate, namespace) : this.formatVistaTime(rawDate, namespace);
        PointInTime pointInTime = null;
        if (!rs.wasNull()) {
            pointInTime = new PointInTime();
            pointInTime.setLiteral(timestamp);
        }
        return pointInTime;
    }

    @Override
    protected String formatVistaTime(String vistaDate, String namespace) {
        String retVal = null;
        if (vistaDate != null && vistaDate.length() >= 3) {
            String[] dateTime = vistaDate.split("[.^]+");
            if (this.isNonConformatString(vistaDate = dateTime[0])) {
                return vistaDate;
            }
            int dateMaxIndex = vistaDate.length() >= 7 ? 7 : vistaDate.length();
            String datePart = vistaDate.substring(0, dateMaxIndex) + "0000".substring(0, 7 - dateMaxIndex);
            retVal = datePart = Integer.parseInt(datePart.substring(0, 3)) + 1700 + datePart.substring(3);
            int timeLength = dateTime.length > 2 ? dateTime[1].length() : 0;
            String timePart = timeLength > 0 ? dateTime[1].concat("000000".substring(0, 6 - timeLength)) : "";
            retVal = datePart + timePart;
        } else {
            retVal = vistaDate;
        }
        return retVal;
    }

    @Override
    protected String formatHdrTime(String rawDate, String namespace) {
        if (rawDate == null) {
            return null;
        }
        String[] dateTime = rawDate.split("\\.");
        String dtTime = dateTime[0];
        String retVal = dtTime.replaceAll("[- :]", "");
        int dateMaxIndex = retVal.length() >= 8 ? 8 : retVal.length();
        String datePart = retVal.substring(0, dateMaxIndex) + "0000".substring(0, 8 - dateMaxIndex);
        String timePart = retVal.substring(dateMaxIndex, retVal.length());
        if ("000000".equals(timePart)) {
            return retVal.substring(0, 8);
        }
        return retVal;
    }
}

