/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.common;

import java.io.Serializable;

public class VistaPersonName
implements Serializable {
    private static final long serialVersionUID = -7944415414341369419L;
    private static final String DELIMETER = "\\^";
    private String identity;
    private String prefix;
    private String given;
    private String middle;
    private String family;
    private String suffix;
    private String title;
    private String stationNumber;
    static final int maxNumberOfTokens = 8;
    static final int minNumberOfTokens = 7;

    public VistaPersonName(String personWithDelimeters) {
        String[] persons = personWithDelimeters.split(DELIMETER, 8);
        if (persons.length != 7 && persons.length != 8) {
            throw new IllegalArgumentException("Format of person with delimeters must follow the following format:\nidentity^family^given^middle^prefix^suffix^title[^namespaceid]");
        }
        this.identity = persons[0];
        this.family = persons[1];
        this.given = persons[2];
        this.middle = persons[3];
        this.prefix = persons[4];
        this.suffix = persons[5];
        this.title = persons[6];
        this.stationNumber = persons.length == 8 ? persons[7] : "";
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getGiven() {
        return this.given;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getFamily() {
        return this.family;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getTitle() {
        return this.title;
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setGiven(String given) {
        this.given = given;
    }

    public void setMiddle(String middle) {
        this.middle = middle;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStationNameber(String stationNameber) {
        this.stationNumber = stationNameber;
    }

    public boolean hasNameComponents() {
        return this.family != null && this.family.length() != 0 || this.given != null && this.given.length() != 0 || this.middle != null && this.middle.length() != 0 || this.prefix != null && this.prefix.length() != 0 || this.suffix != null && this.suffix.length() != 0;
    }

    public boolean hasIdentity() {
        return this.identity != null && this.identity.length() != 0;
    }
}

