/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.common;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.persistence.hibernate.common.AbstractPointInTimeUserType;
import gov.va.med.cds.persistence.hibernate.common.LabTestsParsedFromGlobal;
import gov.va.med.cds.persistence.hibernate.common.MethodNotImplementedException;
import gov.va.med.cds.persistence.hibernate.common.VistaGlobalParser;
import gov.va.med.cds.util.QueryCacheUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;

public class VistaMHVLabTestsUserType
extends AbstractPointInTimeUserType
implements CompositeUserType {
    private static final Log LOGGER = LogFactory.getLog(VistaMHVLabTestsUserType.class);
    private static final int NO_OF_COLUMNS = 8;
    private static String[] PROPERTY_NAMES = new String[8];
    private static Type[] PROPERTY_TYPES = new Type[8];

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            return false;
        }
        return x == y;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Type[] getPropertyTypes() {
        return PROPERTY_TYPES;
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        throw new UnsupportedOperationException((Throwable)((Object)new MethodNotImplementedException(ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName())));
    }

    public int hashCode(Object object) throws HibernateException {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Session mhvLaboratoryTes60DatatSession = session.getFactory().openSession();
        Element labTests = null;
        Map<String, LabTestsParsedFromGlobal> labTestsParsedFromGlobalMap = null;
        LabTestsParsedFromGlobal labTestsParsedFromGlobal = null;
        LabTestsParsedFromGlobal tempLabTestsParsedFromGlobal = null;
        VistaGlobalParser vistaGlobalParser = new VistaGlobalParser();
        if (rs == null) {
            return null;
        }
        int labTestCounter = 0;
        int chemistryResultsCounter = 1;
        Document document = DocumentHelper.createDocument();
        labTests = document.addElement("labTests");
        String concatenatedResultsExt = rs.getString(names[0]);
        String concatenatedResultsManualExt = rs.getString(names[1]);
        if (null == concatenatedResultsExt) {
            return labTests;
        }
        if (concatenatedResultsManualExt != null && !concatenatedResultsManualExt.equalsIgnoreCase("null")) {
            labTestsParsedFromGlobalMap = vistaGlobalParser.parseGlobal(concatenatedResultsManualExt);
        }
        block2: for (String testValues : concatenatedResultsExt.split(",")) {
            String[] testValuesIndividual = testValues.split("\\^");
            if (testValuesIndividual.length < 3 || testValuesIndividual[testValuesIndividual.length - 1].toUpperCase().contains("ERROR") || !this.isNumeric(testValuesIndividual[1].trim())) continue;
            String labTestFieldNum = testValuesIndividual[1].trim();
            if (labTestsParsedFromGlobalMap != null) {
                labTestsParsedFromGlobal = labTestsParsedFromGlobalMap.get(labTestFieldNum);
            }
            try {
                List<Object> labTestElements = null;
                labTestElements = labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.isPanelTest() ? new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "MHVLabRead40011ForNLT.LabTestPromises.labTests.orderedTestCode3", "partOfPanelTest", new String("%" + labTestsParsedFromGlobal.getPartOfPanelTest() + "%")) : new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "MHVLabRead40011.LabTestPromises.labTests", "labTestFieldNum", new BigDecimal(labTestFieldNum));
                for (Object labTestElement : labTestElements) {
                    ++labTestCounter;
                    String siteSpecimen = null;
                    siteSpecimen = rs.getString(names[names.length - 1]);
                    if (siteSpecimen == null) continue block2;
                    List<Object> chemistryResultElements = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "labTests.chemistryResults", "labTestFieldNum", new BigDecimal(labTestFieldNum), "siteSpecimen", new BigDecimal(siteSpecimen));
                    if (chemistryResultElements.size() == 0) {
                        --labTestCounter;
                    }
                    for (Object chemistryResults : chemistryResultElements) {
                        Node tempLabTestsChemistryResultsTestIdentifierCodeNode;
                        Object orderedTestCode;
                        Iterator<Object> iterator;
                        List<Object> performingOrganizationElements;
                        if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getPerormanceOrgCode() != null && labTestsParsedFromGlobal.getPerormanceOrgCode().length() > 0) {
                            performingOrganizationElements = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "labTests.labTest.chemistryResults.chemistryResult.inst4PerformingOrganization", "labTestFieldNum", new BigDecimal(labTestsParsedFromGlobal.getPerormanceOrgCode()));
                            iterator = performingOrganizationElements.iterator();
                            if (iterator.hasNext()) {
                                Object performingOrganizationElement = iterator.next();
                                ((Element)chemistryResults).add((Element)((Element)performingOrganizationElement).clone());
                            }
                        } else {
                            performingOrganizationElements = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "labTests.labTest.chemistryResults.chemistryResult.performingOrganization", "labTestFieldNum", new BigDecimal(labTestFieldNum));
                            iterator = performingOrganizationElements.iterator();
                            if (iterator.hasNext()) {
                                Object performingOrganizationElement = iterator.next();
                                ((Element)chemistryResults).add((Element)((Element)performingOrganizationElement).clone());
                            }
                        }
                        if (tempLabTestsParsedFromGlobal != null && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.isPanelTest() && labTestsParsedFromGlobal.getPartOfPanelTest().equals(tempLabTestsParsedFromGlobal.getPartOfPanelTest())) {
                            ++chemistryResultsCounter;
                            ((Element)labTests.selectSingleNode("labTests[" + --labTestCounter + "]")).add(((Element)chemistryResults).detach());
                        } else {
                            chemistryResultsCounter = 1;
                            ((Element)labTestElement).add((Element)((Element)chemistryResults).detach());
                            labTests.add((Element)labTestElement);
                        }
                        Element templabTestsLabTestsOrderedTestCode = (Element)labTests.selectSingleNode("labTests[" + labTestCounter + "]/orderedTestCode");
                        if (templabTestsLabTestsOrderedTestCode == null && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getLoincCode() != null && labTestsParsedFromGlobal.getNltReportedTestCode() != null && !labTestsParsedFromGlobal.getLoincCode().equals("") && !labTestsParsedFromGlobal.getNltReportedTestCode().equals("")) {
                            iterator = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode1", "loincCode", new BigDecimal(labTestsParsedFromGlobal.getLoincCode()), "workLoadCode", "%" + labTestsParsedFromGlobal.getNltReportedTestCode() + "%").iterator();
                            if (iterator.hasNext()) {
                                orderedTestCode = iterator.next();
                                ((Element)labTestElement).add((Element)((Element)orderedTestCode).detach());
                            }
                        } else if (templabTestsLabTestsOrderedTestCode == null && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getLoincCode() != null && !labTestsParsedFromGlobal.getLoincCode().equals("")) {
                            iterator = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode2", "loincCode", new BigDecimal(labTestsParsedFromGlobal.getLoincCode())).iterator();
                            if (iterator.hasNext()) {
                                orderedTestCode = iterator.next();
                                ((Element)labTestElement).add((Element)((Element)orderedTestCode).detach());
                            }
                        } else if (templabTestsLabTestsOrderedTestCode == null && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getNltOrderedTestCode() != null && !labTestsParsedFromGlobal.getNltOrderedTestCode().equals("") && (iterator = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "MHVLabRead40011.LabTestPromises.labTests.orderedTestCode4", "nltOrderedTestCode", "%" + labTestsParsedFromGlobal.getNltOrderedTestCode() + "%").iterator()).hasNext()) {
                            orderedTestCode = iterator.next();
                            ((Element)labTestElement).add((Element)((Element)orderedTestCode).detach());
                        }
                        Element tempChemistryResults = null;
                        tempChemistryResults = chemistryResultsCounter > 1 ? (Element)labTests.selectSingleNode("labTests[" + labTestCounter + "]/chemistryResults[" + chemistryResultsCounter + "]") : (Element)labTests.selectSingleNode("labTests[" + labTestCounter + "]/chemistryResults");
                        tempLabTestsParsedFromGlobal = labTestsParsedFromGlobal;
                        if (tempChemistryResults == null) continue;
                        Node tempLabTestsChemistryResultsReferenceRange = tempChemistryResults.selectSingleNode("referenceRange");
                        if (tempLabTestsChemistryResultsReferenceRange != null) {
                            if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getReferenceLow() != null && !labTestsParsedFromGlobal.getReferenceLow().equals("") && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getReferenceHigh() != null && !labTestsParsedFromGlobal.getReferenceHigh().equals("")) {
                                tempLabTestsChemistryResultsReferenceRange.setText(labTestsParsedFromGlobal.getReferenceLow() + "-" + labTestsParsedFromGlobal.getReferenceHigh());
                            } else if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getReferenceLow() != null && !labTestsParsedFromGlobal.getReferenceLow().equals("")) {
                                if (!labTestsParsedFromGlobal.getReferenceLow().contains(">") && this.isNumeric(labTestsParsedFromGlobal.getReferenceLow())) {
                                    labTestsParsedFromGlobal.setReferenceLow(">" + labTestsParsedFromGlobal.getReferenceLow());
                                }
                                tempLabTestsChemistryResultsReferenceRange.setText(labTestsParsedFromGlobal.getReferenceLow());
                            } else if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getReferenceHigh() != null && !labTestsParsedFromGlobal.getReferenceHigh().equals("")) {
                                if (!labTestsParsedFromGlobal.getReferenceHigh().contains("<") && this.isNumeric(labTestsParsedFromGlobal.getReferenceHigh())) {
                                    labTestsParsedFromGlobal.setReferenceHigh("<" + labTestsParsedFromGlobal.getReferenceHigh());
                                }
                                tempLabTestsChemistryResultsReferenceRange.setText(labTestsParsedFromGlobal.getReferenceHigh());
                            }
                        }
                        if (tempChemistryResults.selectSingleNode("observationUnits") != null && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getUnitsOfMeasure() != null && !labTestsParsedFromGlobal.getUnitsOfMeasure().equals("")) {
                            tempChemistryResults.selectSingleNode("observationUnits/code").setText(labTestsParsedFromGlobal.getUnitsOfMeasure());
                            tempChemistryResults.selectSingleNode("observationUnits/displayText").setText(labTestsParsedFromGlobal.getUnitsOfMeasure());
                        }
                        if ((tempLabTestsChemistryResultsTestIdentifierCodeNode = tempChemistryResults.selectSingleNode("testIdentifier/code")) == null && labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getLoincCode() != null && this.isNumeric(labTestsParsedFromGlobal.getLoincCode())) {
                            List<Object> testIdentifiers = new QueryCacheUtil().getNamedQueryList(mhvLaboratoryTes60DatatSession, "labTests.chemistryResults.testIdentifier", "loincCode", BigDecimal.valueOf(Float.valueOf(labTestsParsedFromGlobal.getLoincCode()).floatValue()));
                            for (Object testIdentifier : testIdentifiers) {
                                tempChemistryResults.add(((Element)testIdentifier).detach());
                            }
                        } else if (tempLabTestsChemistryResultsTestIdentifierCodeNode == null && testValuesIndividual[2] != null) {
                            tempChemistryResults.selectSingleNode("testIdentifier/displayText").setText(testValuesIndividual[2].trim());
                            tempChemistryResults.selectSingleNode("testIdentifier/originalText").setText(testValuesIndividual[2].trim());
                        }
                        tempChemistryResults.selectSingleNode("observationValue").setText(testValuesIndividual[0].trim());
                        if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getReferenceLow() != null && !labTestsParsedFromGlobal.getReferenceLow().equals("")) {
                            tempChemistryResults.selectSingleNode("referenceLow").setText(labTestsParsedFromGlobal.getReferenceLow());
                        }
                        Node nodeReferenceLow = tempChemistryResults.selectSingleNode("referenceLow");
                        if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getReferenceHigh() != null && !labTestsParsedFromGlobal.getReferenceHigh().equals("")) {
                            tempChemistryResults.selectSingleNode("referenceHigh").setText(labTestsParsedFromGlobal.getReferenceHigh());
                        }
                        Node nodeReferenceHigh = tempChemistryResults.selectSingleNode("referenceHigh");
                        if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getCriticalLow() != null && !labTestsParsedFromGlobal.getCriticalLow().equals("")) {
                            tempChemistryResults.selectSingleNode("criticalLow").setText(labTestsParsedFromGlobal.getCriticalLow());
                        }
                        Node nodeCriticalLow = tempChemistryResults.selectSingleNode("criticalLow");
                        if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getCriticalHigh() != null && !labTestsParsedFromGlobal.getCriticalHigh().equals("")) {
                            tempChemistryResults.selectSingleNode("criticalHigh").setText(labTestsParsedFromGlobal.getCriticalHigh());
                        }
                        Node nodeCriticalHigh = tempChemistryResults.selectSingleNode("criticalHigh");
                        if (labTestsParsedFromGlobal != null && labTestsParsedFromGlobal.getValueInterpretation() != null && !labTestsParsedFromGlobal.getValueInterpretation().equals("")) {
                            tempChemistryResults.selectSingleNode("valueInterpretation").setText(labTestsParsedFromGlobal.getValueInterpretation());
                        } else if (this.isNumeric(testValuesIndividual[0].trim())) {
                            float observationValue = Float.valueOf(testValuesIndividual[0].trim()).floatValue();
                            if (nodeReferenceLow != null && this.isNumeric(nodeReferenceLow.getText())) {
                                float referenceLow = Float.valueOf(nodeReferenceLow.getText()).floatValue();
                                if (nodeCriticalLow != null && this.isNumeric(nodeCriticalLow.getText())) {
                                    float criticalLow = Float.valueOf(nodeCriticalLow.getText()).floatValue();
                                    if (observationValue < referenceLow && observationValue > criticalLow) {
                                        tempChemistryResults.selectSingleNode("valueInterpretation").setText("L");
                                    } else if (observationValue <= criticalLow) {
                                        tempChemistryResults.selectSingleNode("valueInterpretation").setText("LL");
                                    }
                                } else if (observationValue < referenceLow) {
                                    tempChemistryResults.selectSingleNode("valueInterpretation").setText("L");
                                }
                            }
                            if (nodeReferenceHigh != null && this.isNumeric(nodeReferenceHigh.getText())) {
                                float referenceHigh = Float.valueOf(nodeReferenceHigh.getText()).floatValue();
                                if (nodeCriticalHigh != null && this.isNumeric(nodeCriticalHigh.getText())) {
                                    float criticalHigh = Float.valueOf(nodeCriticalHigh.getText()).floatValue();
                                    if (observationValue > referenceHigh && observationValue < criticalHigh) {
                                        tempChemistryResults.selectSingleNode("valueInterpretation").setText("H");
                                    } else if (observationValue >= criticalHigh) {
                                        tempChemistryResults.selectSingleNode("valueInterpretation").setText("HH");
                                    }
                                } else if (observationValue > referenceHigh) {
                                    tempChemistryResults.selectSingleNode("valueInterpretation").setText("H");
                                }
                            }
                        }
                        Node observationStatus = tempChemistryResults.selectSingleNode("observationStatus");
                        if (null == labTestsParsedFromGlobal || null == labTestsParsedFromGlobal.getAmendedFlag()) {
                            observationStatus.setText("F");
                            continue;
                        }
                        if (labTestsParsedFromGlobal.getAmendedFlag().trim().equals("1")) {
                            if (labTestsParsedFromGlobal.getObservationValue().trim().equalsIgnoreCase("pending")) {
                                observationStatus.setText("I");
                                continue;
                            }
                            observationStatus.setText("F");
                            continue;
                        }
                        if (labTestsParsedFromGlobal.getAmendedFlag().trim().equals("2")) {
                            if (labTestsParsedFromGlobal.getObservationValue().trim().equalsIgnoreCase("pending")) {
                                observationStatus.setText("I");
                                continue;
                            }
                            observationStatus.setText("C");
                            continue;
                        }
                        if (!labTestsParsedFromGlobal.getObservationValue().trim().equalsIgnoreCase("pending")) continue;
                        observationStatus.setText("I");
                    }
                }
            }
            catch (Exception e) {
                Element labTestsElement = (Element)labTests.selectSingleNode("//labTests/labTests[" + labTestCounter + "]");
                if (labTestsElement != null) {
                    labTestsElement.detach();
                }
                --labTestCounter;
            }
        }
        mhvLaboratoryTes60DatatSession.disconnect();
        return labTests;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        throw new UnsupportedOperationException((Throwable)((Object)new MethodNotImplementedException(ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName())));
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return original;
    }

    public Class<String> returnedClass() {
        return String.class;
    }

    @Override
    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new UnsupportedOperationException((Throwable)((Object)new MethodNotImplementedException(ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName())));
    }

    static {
        for (int column = 0; column < 8; ++column) {
            VistaMHVLabTestsUserType.PROPERTY_NAMES[column] = "";
            VistaMHVLabTestsUserType.PROPERTY_TYPES[column] = StandardBasicTypes.STRING;
        }
    }
}

