/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.common;

import java.io.Serializable;

public class SupplementalOxygen
implements Serializable {
    private static final long serialVersionUID = -7944415414341369419L;
    private static final String COLUMNS_DELIMETER = "\\^";
    private static final String SUPPLEMENTALO2_DELIMETER = " ";
    private String flowRateValue;
    private String flowRateUnitCode;
    private String flowRateUnitDisplayText;
    private String flowRateUnitCodingSystem;
    private String concentrationValue;
    private String concentrationUnitCode;
    private String concentrationUnitDisplayText;
    private String concentrationUnitCodingSystem;
    private String unitOfMeasure;
    static final int maxNumberOfTokens = 3;
    static final int minNumberOfTokens = 0;

    public SupplementalOxygen(String supplementalO2UomColumns) {
        int pctIndex;
        String[] supplementalO2Uom = supplementalO2UomColumns.split(COLUMNS_DELIMETER);
        int supplementalO2UomLength = supplementalO2Uom.length;
        String supplementalO2WithDelimeters = supplementalO2UomLength > 0 ? supplementalO2Uom[0].trim() : "";
        String uom = supplementalO2UomLength > 1 ? supplementalO2Uom[1].trim() : "";
        String[] supplementalO2 = supplementalO2WithDelimeters.split(SUPPLEMENTALO2_DELIMETER, 3);
        int supplementalO2Length = supplementalO2.length;
        if (supplementalO2Length < 0 || supplementalO2Length > 3) {
            throw new IllegalArgumentException("Format of Supplemental Oxygen with delimeters must follow the following format:\nFlowRateValue FlowRateUnit ConcentrationValue");
        }
        this.unitOfMeasure = uom != null ? uom.trim() : null;
        switch (supplementalO2Length) {
            case 1: {
                this.flowRateValue = null;
                this.flowRateUnitCode = null;
                this.concentrationValue = supplementalO2[0].trim();
                break;
            }
            case 2: {
                this.flowRateValue = supplementalO2[0].trim();
                this.flowRateUnitCode = supplementalO2[1].trim();
                this.concentrationValue = null;
                break;
            }
            case 3: {
                this.flowRateValue = supplementalO2[0].trim();
                this.flowRateUnitCode = supplementalO2[1].trim();
                this.concentrationValue = supplementalO2[2].trim();
                break;
            }
            default: {
                this.flowRateValue = null;
                this.flowRateUnitCode = null;
                this.concentrationValue = null;
            }
        }
        this.flowRateUnitDisplayText = this.flowRateUnitCode;
        this.flowRateUnitCodingSystem = this.flowRateUnitCode != null && this.flowRateUnitCode.length() > 0 ? "L" : null;
        int n = pctIndex = this.concentrationValue != null ? this.concentrationValue.indexOf("%") : -1;
        if (pctIndex >= 0) {
            this.concentrationUnitCode = this.concentrationValue.substring(pctIndex).trim();
            this.concentrationValue = this.concentrationValue.substring(0, pctIndex).trim();
        } else {
            this.concentrationUnitCode = null;
        }
        this.concentrationUnitDisplayText = this.concentrationUnitCode;
        this.concentrationUnitCodingSystem = this.concentrationUnitCode != null && this.concentrationUnitCode.length() > 0 ? "L" : null;
    }

    public String getFlowRateValue() {
        return this.flowRateValue;
    }

    public void setFlowRateValue(String flowRateValue) {
        this.flowRateValue = flowRateValue;
    }

    public String getFlowRateUnitCode() {
        return this.flowRateUnitCode;
    }

    public void setFlowRateUnitCode(String flowRateUnitCode) {
        this.flowRateUnitCode = flowRateUnitCode;
    }

    public String getFlowRateUnitDisplayText() {
        return this.flowRateUnitDisplayText;
    }

    public void setFlowRateUnitDisplayText(String flowRateUnitDisplayText) {
        this.flowRateUnitDisplayText = flowRateUnitDisplayText;
    }

    public String getFlowRateUnitCodingSystem() {
        return this.flowRateUnitCodingSystem;
    }

    public void setFlowRateUnitCodingSystem(String flowRateUnitCodingSystem) {
        this.flowRateUnitCodingSystem = flowRateUnitCodingSystem;
    }

    public String getConcentrationValue() {
        return this.concentrationValue;
    }

    public void setConcentrationValue(String concentrationValue) {
        this.concentrationValue = concentrationValue;
    }

    public String getConcentrationUnitCode() {
        return this.concentrationUnitCode;
    }

    public void setConcentrationUnitCode(String concentrationUnitCode) {
        this.concentrationUnitCode = concentrationUnitCode;
    }

    public String getConcentrationUnitDisplayText() {
        return this.concentrationUnitDisplayText;
    }

    public void setConcentrationUnitDisplayText(String concentrationUnitDisplayText) {
        this.concentrationUnitDisplayText = concentrationUnitDisplayText;
    }

    public String getConcentrationUnitCodingSystem() {
        return this.concentrationUnitCodingSystem;
    }

    public void setConcentrationUnitCodingSystem(String concentrationUnitCodingSystem) {
        this.concentrationUnitCodingSystem = concentrationUnitCodingSystem;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean hasNameComponents() {
        return this.flowRateValue != null && this.flowRateValue.length() > 0 || this.flowRateUnitCode != null && this.flowRateUnitCode.length() > 0 || this.concentrationValue != null && this.concentrationValue.length() > 0 || this.concentrationUnitCode != null && this.concentrationUnitCode.length() > 0;
    }
}

