/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.common;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.hibernate.common.AbstractVistaPreQueryExecution;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate4.SessionFactoryUtils;

public class OutpatientPharmacyPreQueryExecution
extends AbstractVistaPreQueryExecution {
    protected static final String DATA_FORMAT_PATTERN = "yyyyMMdd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List getRowIds(Session session, EntryFilterInterface entryFilter, List patientIdentifiers) throws ReadException {
        ArrayList<String> idList = null;
        if (!entryFilter.getDomainEntryPoint().equals(this.domainEntryPoint)) return patientIdentifiers;
        idList = new ArrayList();
        Connection conn = null;
        CallableStatement cstmt = null;
        ResultSet rs = null;
        DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)session.getSessionFactory());
        Query query = session.getNamedQuery(this.namedQuery);
        Iterator iterator = patientIdentifiers.iterator();
        block29: while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                conn = dataSource.getConnection();
                cstmt = conn.prepareCall(query.getQueryString());
                cstmt.setString(1, e.toString());
                rs = this.updateStatement(cstmt, entryFilter).executeQuery();
                if (rs == null) continue;
                while (true) {
                    if (!rs.next()) continue block29;
                    idList.add(rs.getString(this.resultColumnName));
                }
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (ex.getCause() != null) {
                    msg = String.format("%s%s%s", ex.getMessage(), ": ", ex.getCause().getMessage());
                }
                throw new PersistenceException(ErrorCodeEnum.READ_REQUEST_PRE_QUERY_FAILURE, e.toString(), entryFilter.getDomainEntryPoint(), msg);
            }
            finally {
                if (rs != null) {
                    try {
                        try {
                            rs.close();
                            rs = null;
                        }
                        catch (Exception er) {
                            er.printStackTrace();
                            rs = null;
                        }
                    }
                    catch (Throwable throwable) {
                        rs = null;
                        throw throwable;
                    }
                }
                if (cstmt != null) {
                    try {
                        try {
                            cstmt.close();
                            cstmt = null;
                        }
                        catch (SQLException ec) {
                            ec.printStackTrace();
                            cstmt = null;
                        }
                    }
                    catch (Throwable throwable) {
                        cstmt = null;
                        throw throwable;
                    }
                }
                if (conn == null) continue;
                try {
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException ep) {
                        ep.printStackTrace();
                        conn = null;
                    }
                }
                catch (Throwable throwable) {
                    conn = null;
                    throw throwable;
                }
            }
        }
        return idList;
    }

    private CallableStatement updateStatement(CallableStatement cstmt, EntryFilterInterface entryFilter) throws SQLException {
        ParameterMetaData paramMetaData = cstmt.getParameterMetaData();
        if (paramMetaData.getParameterCount() == 3) {
            Calendar endDateCal;
            Calendar startDateCal = entryFilter.getStartDate();
            cstmt.setString(2, "");
            if (startDateCal != null) {
                String startDate = new SimpleDateFormat(DATA_FORMAT_PATTERN).format(startDateCal.getTime());
                cstmt.setString(2, startDate);
            }
            if ((endDateCal = entryFilter.getEndDate()) != null) {
                cstmt.setString(3, "");
            }
            String endDate = new SimpleDateFormat(DATA_FORMAT_PATTERN).format(endDateCal.getTime());
            cstmt.setString(3, endDate);
        }
        return cstmt;
    }
}

