/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate.common;

import gov.va.med.cds.persistence.hibernate.common.VistaTimeZoneOffset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.ParameterizedType;

public abstract class AbstractPointInTimeUserType
implements ParameterizedType,
CompositeUserType {
    private static String DATE_FORMAT = "yyyyMMddHHmmss";
    private static String DATE_FORMAT_NO_TIME = "yyyyMMdd";
    public static final String SET_VALUES = "setValues";
    public static final String SV_ALL = "all";
    public static final String SV_LITERAL_ONLY = "literalOnly";
    public static final String SV_NUMERIC_ONLY = "numericOnly";
    public static final String STATION_ID = "stationId";
    protected String setValues;

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return original;
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new UnsupportedOperationException("Point In Time property is immutable.");
    }

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            this.setValues = parameters.getProperty(SET_VALUES);
        }
    }

    protected Double isoTime2Double(String isoDate) {
        Double retVal;
        if (isoDate != null && isoDate.length() >= 4) {
            if (this.isNonConformatString(isoDate = isoDate.split("[-+]")[0].split("\\.")[0])) {
                return null;
            }
            int dateMaxIndex = isoDate.length() >= 8 ? 8 : isoDate.length();
            String datePart = isoDate.substring(0, dateMaxIndex) + "0000".substring(0, 8 - dateMaxIndex);
            String timePart = isoDate.length() > dateMaxIndex ? isoDate.substring(dateMaxIndex) : "0";
            datePart = Integer.parseInt(datePart.substring(0, 4)) - 1700 + datePart.substring(4);
            retVal = new Double(datePart + "." + timePart);
        } else {
            retVal = new Double(0.0);
        }
        return retVal;
    }

    protected java.sql.Date isoTime2Date(String isoDate) {
        java.sql.Date retVal = null;
        if (isoDate != null) {
            String[] dateTime = isoDate.split("\\.");
            if (this.isNonConformatString(isoDate = dateTime[0])) {
                return null;
            }
            int dateMaxIndex = isoDate.length() >= 8 ? 8 : isoDate.length();
            String datePart = isoDate.substring(0, dateMaxIndex) + "0000".substring(0, 8 - dateMaxIndex);
            String timePart = isoDate.length() > dateMaxIndex ? isoDate.substring(dateMaxIndex) : "0";
            isoDate = datePart + timePart;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                retVal = new java.sql.Date(formatter.parse(isoDate).getTime());
            }
            catch (ParseException pe) {
                retVal = new java.sql.Date(0L);
            }
        }
        return retVal;
    }

    protected boolean isNonConformatString(String isoDate) {
        boolean returnValue = false;
        if (isoDate.length() < 4) {
            returnValue = true;
        } else {
            for (int index = 0; index < isoDate.length(); ++index) {
                char isoDateCharacter = isoDate.charAt(index);
                if (isoDateCharacter <= '9' && isoDateCharacter >= '0') continue;
                returnValue = true;
                break;
            }
        }
        return returnValue;
    }

    protected String formatHdrTime(String rawDate, String namespace) {
        if (rawDate == null) {
            return null;
        }
        String[] dateTime = rawDate.split("\\.");
        String dtTime = dateTime[0];
        String retVal = dtTime.replaceAll("[- :]", "");
        retVal = this.getOffset(retVal, namespace);
        return retVal;
    }

    protected String formatVistaTime(String vistaDate, String namespace) {
        String retVal = null;
        if (vistaDate != null && vistaDate.length() >= 3) {
            String[] dateTime = vistaDate.split("[.^]+");
            if (this.isNonConformatString(vistaDate = dateTime[0])) {
                return vistaDate;
            }
            int dateMaxIndex = vistaDate.length() >= 7 ? 7 : vistaDate.length();
            String datePart = vistaDate.substring(0, dateMaxIndex) + "0000".substring(0, 7 - dateMaxIndex);
            retVal = datePart = Integer.parseInt(datePart.substring(0, 3)) + 1700 + datePart.substring(3);
            int timeLength = dateTime.length > 2 ? dateTime[1].length() : 0;
            String timePart = timeLength > 0 ? dateTime[1].concat("000000".substring(0, 6 - timeLength)) : "";
            retVal = datePart + timePart;
            retVal = this.getOffset(retVal, namespace);
        } else {
            retVal = vistaDate;
        }
        return retVal;
    }

    protected String getOffset(String timestamp, String facilityId) {
        String timezone = VistaTimeZoneOffset.getTimeZone(facilityId);
        if (timezone == null) {
            return timestamp;
        }
        String time = null;
        try {
            String format = DATE_FORMAT;
            if (timestamp.length() == 8) {
                format = DATE_FORMAT_NO_TIME;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date remoteDate = sdf.parse(timestamp);
            TimeZone tz = TimeZone.getTimeZone(timezone);
            int offset = tz.getOffset(remoteDate.getTime());
            time = String.format("%s%s%02d%02d", timestamp, offset >= 0 ? "+" : "-", Math.abs(offset) / 3600000, offset / 60000 % 60);
        }
        catch (ParseException pe) {
            time = timestamp;
        }
        return time;
    }

    protected boolean isNumeric(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        try {
            Float.parseFloat(value);
        }
        catch (Exception e) {
            return false;
        }
        return value.matches("-?\\d+(.\\d+)?");
    }
}

