/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.OperationNotSupportedException;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.WritePersistenceManagerInterface;
import gov.va.med.cds.persistence.hibernate.AbstractHibernatePersistenceManager;
import gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException;
import gov.va.med.cds.persistence.hibernate.IdentityException;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.template.generated.common.PatientLite;
import gov.va.med.cds.template.generated.surveyscommon.CareCoordinator;
import gov.va.med.cds.template.generated.surveyscommon.Facility;
import gov.va.med.cds.template.generated.surveyscommon.Survey;
import gov.va.med.cds.template.generated.surveyscommon.SurveyChoice;
import gov.va.med.cds.template.generated.surveyscommon.SurveyPatient;
import gov.va.med.cds.template.generated.surveyscommon.SurveyQuestion;
import gov.va.med.cds.template.generated.surveyscommon.SurveyQuestionAndAnswer;
import gov.va.med.cds.template.generated.surveyscommon.SurveyQuestionsAndAnswers;
import gov.va.med.cds.template.generated.surveyscommon.SurveyResponse;
import gov.va.med.cds.template.generated.surveyscommon.Vendor;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;

public class WriteableSurveyPersistenceManager
extends AbstractHibernatePersistenceManager
implements WritePersistenceManagerInterface {
    private static final String SURVEY_QS_AND_AS = "surveyQuestionsAndAnswers";
    private static final String SURVEY_TYPE = "type";
    private static final String SURVEY_PATIENT = "surveyPatient";
    private static final String PATIENT = "patient";
    private static final String CARE_COORDINATOR = "careCoordinator";
    private List<BooleanRuleInterface> rules;
    private String cdsAppName;

    @Override
    public boolean isApplicable(Object critera) throws PersistenceException {
        BooleanRuleInterface r;
        boolean b = false;
        Iterator<BooleanRuleInterface> iterator = this.rules.iterator();
        while (iterator.hasNext() && !(b = (r = iterator.next()).evaluate(critera))) {
        }
        return b;
    }

    @Override
    public String performCUADOnClinicalData(String templateId, Operation operation, Object aObject, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        Session session = null;
        String resultId = "";
        try {
            session = this.getSessionFactory(templateId).getCurrentSession();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)LogMessageUtil.buildMessage((String)templateId, null, (String)this.cdsAppName, (String)(operation.name() + aObject)));
            }
            switch (operation) {
                case Create: {
                    resultId = this.createData(session, aObject, domainEntryPoint);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The %s operation is not supported by the WriteableHibernatePersistenceManager.", operation.toString()));
                }
            }
            session.flush();
            session.clear();
            return resultId;
        }
        catch (ConstraintViolationException e) {
            throw new HibernateConstraintViolationException(e);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCause((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage();
            throw new PersistenceException(ErrorCodeEnum.HDRII_OPERATION_FAILED, e, operation.name(), rootCauseMessage, domainEntryPoint.getName());
        }
    }

    protected String createData(Session session, Object aObject, DomainEntryPoint domainEntryPoint) {
        SurveyResponse surveyResponse = (SurveyResponse)this.unmarshalElementToObject((Element)aObject, domainEntryPoint);
        this.validateAndRetrieveVendor(session, surveyResponse);
        this.validateAndRetrieveFacility(session, surveyResponse);
        this.retrieveOrStoreSurveyPatient(session, surveyResponse);
        this.retrieveOrStoreSurveyCareCoordinator(session, surveyResponse);
        this.storeSurveyAnswers(session, surveyResponse);
        return session.save((Object)surveyResponse).toString();
    }

    private void storeSurveyAnswers(Session session, SurveyResponse aSurveyResponse) {
        List results = null;
        Survey incomingSurvey = aSurveyResponse.getSurvey();
        try {
            Criteria criteria = session.createCriteria("survey");
            criteria.add((Criterion)Example.create((Object)incomingSurvey));
            results = criteria.list();
            if (results.size() != 1) {
                throw new IdentityException(ErrorCodeEnum.WRITE_REQUEST_SURVEY_SURVEYID_INVALID, incomingSurvey.getSurveyTitle());
            }
            Survey survey = (Survey)results.get(0);
            aSurveyResponse.setSurvey(survey);
            SurveyQuestionsAndAnswers surveyQuestionsAndAnswers = aSurveyResponse.getSurveyQuestionsAndAnswers();
            if (aSurveyResponse.getResponseStatus().equalsIgnoreCase("ACCEPTED")) {
                int numSurveyResponses;
                List surveyQuestions = survey.getSurveyQuestions();
                List responseQAs = surveyQuestionsAndAnswers.getSurveyQuestionAndAnswer();
                surveyQuestions.removeAll(Collections.singleton(null));
                responseQAs.removeAll(Collections.singleton(null));
                int numQuestions = surveyQuestions == null ? -1 : surveyQuestions.size();
                int n = numSurveyResponses = responseQAs == null ? -1 : responseQAs.size();
                if (numQuestions == -1 || numSurveyResponses == -1 || numQuestions != numSurveyResponses) {
                    throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_SURVEY_RESPONSES_INVALID, Integer.toString(numQuestions), Integer.toString(numSurveyResponses));
                }
                for (SurveyQuestionAndAnswer answer : responseQAs) {
                    Integer answerQuestionNumber = answer.getQuestionNumber();
                    Integer answerQuestionAnswer = answer.getAnswer();
                    SurveyQuestion surveyQuestion = this.getQuestion(answerQuestionNumber, surveyQuestions);
                    SurveyChoice surveyChoice = this.getChoice(answerQuestionAnswer, surveyQuestion);
                    answer.setSurveyChoice(surveyChoice);
                    answer.setQuestionNumber(null);
                    answer.setAnswer(null);
                }
            } else {
                aSurveyResponse.setSurveyQuestionsAndAnswers(null);
            }
        }
        catch (GenericJDBCException e) {
            throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
        }
    }

    private String getElementNameEndingWith(Element parent, String endsWith) {
        Iterator childIterator = parent.elementIterator();
        while (childIterator.hasNext()) {
            Element child = (Element)childIterator.next();
            if (!child.getName().endsWith(endsWith)) continue;
            return child.getName();
        }
        throw new IllegalArgumentException("Survey response contains must contain questions and answers.");
    }

    private SurveyQuestion getQuestion(Integer questionNumber, List<SurveyQuestion> questionList) {
        for (SurveyQuestion question : questionList) {
            if (!question.getQuestionNumber().equals(questionNumber)) continue;
            return question;
        }
        return null;
    }

    private SurveyChoice getChoice(Integer answerNumber, SurveyQuestion question) {
        List choices = question.getSurveyChoices();
        choices.removeAll(Collections.singleton(null));
        for (SurveyChoice choice : choices) {
            if (!choice.getChoiceNumber().equals(answerNumber)) continue;
            return choice;
        }
        return null;
    }

    protected void retrieveOrStoreSurveyPatient(Session session, SurveyResponse response) {
        List results = null;
        SurveyPatient surveyPatient = response.getSurveyPatient();
        Criteria criteria = session.createCriteria(SURVEY_PATIENT);
        criteria.add((Criterion)Example.create((Object)surveyPatient));
        try {
            results = criteria.list();
        }
        catch (GenericJDBCException e) {
            throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
        }
        if (results.size() < 1) {
            session.save(SURVEY_PATIENT, (Object)surveyPatient);
        } else {
            PatientLite patient = surveyPatient.getPatient();
            SurveyPatient firstSurveyPatient = (SurveyPatient)results.get(0);
            firstSurveyPatient.setPatient(patient);
            response.setSurveyPatient(firstSurveyPatient);
        }
    }

    protected void retrieveOrStoreSurveyCareCoordinator(Session session, SurveyResponse response) {
        List results = null;
        CareCoordinator careCoordinator = response.getCareCoordinator();
        Criteria criteria = session.createCriteria(CARE_COORDINATOR);
        criteria.add((Criterion)Example.create((Object)careCoordinator));
        try {
            results = criteria.list();
        }
        catch (GenericJDBCException e) {
            throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
        }
        if (results.size() < 1) {
            session.save(CARE_COORDINATOR, (Object)careCoordinator);
        } else {
            response.setCareCoordinator((CareCoordinator)results.get(0));
        }
    }

    protected void validateAndRetrieveVendor(Session session, SurveyResponse aSurveyResponse) {
        String vendorName;
        List results = null;
        boolean foundVendor = false;
        Vendor incomingVendor = aSurveyResponse.getVendor();
        String vendorNameToStore = vendorName = incomingVendor.getVendorName();
        incomingVendor.setVendorName(null);
        Criteria criteria = session.createCriteria("vendor");
        criteria.add((Criterion)Example.create((Object)incomingVendor));
        try {
            results = criteria.list();
        }
        catch (GenericJDBCException e) {
            throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
        }
        if (results.size() < 1) {
            throw new ReadException(ErrorCodeEnum.WRITE_REQUEST_SURVEY_VENDOR_NUMBER_INVALID, incomingVendor.getVendorNumber());
        }
        for (Vendor vendor : results) {
            if (!vendor.getVendorName().equals(vendorNameToStore)) continue;
            aSurveyResponse.setVendor(vendor);
            foundVendor = true;
            break;
        }
        if (!foundVendor) {
            incomingVendor.setVendorName(vendorName);
            session.save("vendor", (Object)incomingVendor);
        }
    }

    protected void validateAndRetrieveFacility(Session session, SurveyResponse aSurveyResponse) {
        List results = null;
        Facility incomingFacility = aSurveyResponse.getFacility();
        Criteria criteria = session.createCriteria("facility");
        criteria.add((Criterion)Example.create((Object)incomingFacility));
        try {
            results = criteria.list();
        }
        catch (GenericJDBCException e) {
            throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
        }
        if (results.size() != 1) {
            throw new ReadException(ErrorCodeEnum.WRITE_REQUEST_SURVEY_FACILITY_INVALID, incomingFacility.getFacilityNumber());
        }
        aSurveyResponse.setFacility((Facility)results.get(0));
    }

    public void setRules(List<BooleanRuleInterface> rules) {
        this.rules = rules;
    }

    public void setCdsAppName(String cdsAppName) {
        this.cdsAppName = cdsAppName;
    }

    @Override
    public String performCUADOnPatientsData(String templateId, String aRequestId, Operation aOperation, Object aObject, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        throw new OperationNotSupportedException(ErrorCodeEnum.METHOD_NOT_IMPLEMENTED);
    }
}

