/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.persistence.DeleteException;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.WritePersistenceManagerInterface;
import gov.va.med.cds.persistence.hibernate.AbstractHibernatePersistenceManager;
import gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;

public class WriteableHibernatePersistenceManager
extends AbstractHibernatePersistenceManager
implements WritePersistenceManagerInterface {
    private static final String LOGICAL_DELETE_VALUE = "1";
    private List<BooleanRuleInterface> rules;
    private String cdsAppName;
    private Map<String, String> logicalDeleteTemplateIdsMap;

    @Override
    public boolean isApplicable(Object critera) throws PersistenceException {
        BooleanRuleInterface r;
        boolean b = false;
        Iterator<BooleanRuleInterface> iterator = this.rules.iterator();
        while (iterator.hasNext() && !(b = (r = iterator.next()).evaluate(critera))) {
        }
        return b;
    }

    @Override
    public String performCUADOnClinicalData(String templateId, Operation operation, Object aObject, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        Session session = null;
        String resultId = "";
        try {
            session = this.getSessionFactory(templateId).getCurrentSession();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)LogMessageUtil.buildMessage((String)templateId, null, (String)this.cdsAppName, (String)(operation.name() + aObject)));
            }
            aObject = this.unmarshalElementToObject((Element)aObject, domainEntryPoint);
            switch (operation) {
                case Create: {
                    resultId = this.createData(session, aObject);
                    break;
                }
                case Delete: {
                    if (this.logicalDeleteTemplateIdsMap.containsKey(templateId)) {
                        this.deleteOrUpdateData(session, aObject, this.logicalDeleteTemplateIdsMap.get(templateId));
                        break;
                    }
                    this.deleteData(session, aObject);
                    break;
                }
                case Update: {
                    this.updateData(session, aObject);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The %s operation is not supported by the WriteableHibernatePersistenceManager.", operation.toString()));
                }
            }
            session.flush();
            return resultId;
        }
        catch (ConstraintViolationException e) {
            throw new HibernateConstraintViolationException(e);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCause((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage();
            throw new PersistenceException(ErrorCodeEnum.HDRII_OPERATION_FAILED, e, operation.name(), rootCauseMessage, domainEntryPoint.getName());
        }
    }

    private void deleteOrUpdateData(Session session, Object aObject, String elementName) throws InstantiationException, IllegalAccessException {
        Element record = (Element)aObject;
        Element recordStatus = (Element)record.selectSingleNode(String.format("//%s", elementName));
        if (recordStatus != null && recordStatus.getStringValue().equals(LOGICAL_DELETE_VALUE)) {
            this.updateData(session, aObject);
        } else {
            this.deleteData(session, aObject);
        }
    }

    private void deleteData(Session session, Object aObject) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)LogMessageUtil.buildMessage(null, null, (String)this.cdsAppName, (String)("record to delete: " + aObject)));
        }
        try {
            session.delete(aObject);
        }
        catch (GenericJDBCException e) {
            throw new DeleteException(ErrorCodeEnum.HIBERNATE_DELETE_FAILURE, e);
        }
    }

    private String createData(Session session, Object aObject) {
        return session.save(aObject).toString();
    }

    protected void updateData(Session session, Object aObject) throws InstantiationException, IllegalAccessException {
        session.update(aObject);
    }

    public void setRules(List<BooleanRuleInterface> rules) {
        this.rules = rules;
    }

    public void setCdsAppName(String cdsAppName) {
        this.cdsAppName = cdsAppName;
    }

    public void setLogicalDeleteTemplateIdsMap(Map<String, String> logicalDeleteTemplateIdsMap) {
        this.logicalDeleteTemplateIdsMap = logicalDeleteTemplateIdsMap;
    }

    @Override
    public String performCUADOnPatientsData(String templateId, String requestId, Operation operation, Object aObject, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        Session session = null;
        String resultId = "";
        try {
            session = this.getSessionFactory(templateId).getCurrentSession();
            aObject = this.unmarshalElementToObject((Element)aObject, domainEntryPoint);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)LogMessageUtil.buildMessage((String)templateId, null, (String)this.cdsAppName, (String)(operation.name() + aObject)));
            }
            switch (operation) {
                case Create: {
                    resultId = this.createData(session, aObject);
                    break;
                }
                case Delete: {
                    if (this.logicalDeleteTemplateIdsMap.containsKey(templateId)) {
                        this.deleteOrUpdateData(session, aObject, this.logicalDeleteTemplateIdsMap.get(templateId));
                        break;
                    }
                    this.deleteData(session, aObject);
                    break;
                }
                case Update: {
                    this.updateData(session, aObject);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The %s operation is not supported by the WriteableHibernatePersistenceManager.", operation.toString()));
                }
            }
            session.flush();
            return resultId;
        }
        catch (ConstraintViolationException e) {
            throw new HibernateConstraintViolationException(e);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCause((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage();
            throw new PersistenceException(ErrorCodeEnum.HDRII_OPERATION_FAILED, e, operation.name(), rootCauseMessage, domainEntryPoint.getName());
        }
    }
}

