/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.hibernate.WriteableSurveyPersistenceManager;
import gov.va.med.cds.template.generated.surveyscommon.Survey;
import gov.va.med.cds.template.generated.surveyscommon.SurveyResponse;
import java.util.List;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.exception.GenericJDBCException;

public class WriteableDMPSurveyPersistenceManager
extends WriteableSurveyPersistenceManager {
    private static final String SURVEY_TYPE_DMP = "DMP";
    private static final String SURVEY = "survey";

    @Override
    protected String createData(Session session, Object aObject, DomainEntryPoint domainEntryPoint) {
        SurveyResponse surveyResponse = (SurveyResponse)this.unmarshalElementToObject((Element)aObject, domainEntryPoint);
        this.validateAndRetrieveVendor(session, surveyResponse);
        this.validateAndRetrieveFacility(session, surveyResponse);
        this.retrieveOrStoreSurvey(session, surveyResponse);
        this.verifyStoringQuestionsAndAnswers(session, surveyResponse);
        return session.save((Object)surveyResponse).toString();
    }

    private void verifyStoringQuestionsAndAnswers(Session session, SurveyResponse aSurveyResponse) {
        if (!aSurveyResponse.getResponseStatus().equalsIgnoreCase("ACCEPTED")) {
            aSurveyResponse.setSurveyQuestionsAndAnswersWithScores(null);
        }
    }

    protected void retrieveOrStoreSurvey(Session session, SurveyResponse response) {
        List results = null;
        Survey survey = response.getSurvey();
        survey.setSurveyType(SURVEY_TYPE_DMP);
        Criteria criteria = session.createCriteria(SURVEY);
        criteria.add((Criterion)Example.create((Object)survey));
        try {
            results = criteria.list();
        }
        catch (GenericJDBCException e) {
            throw new ReadException(ErrorCodeEnum.HIBERNATE_READ_FAILURE, e, e.getMessage());
        }
        if (results.size() < 1) {
            session.save(SURVEY, (Object)survey);
        } else {
            response.setSurvey((Survey)results.get(0));
        }
    }
}

