/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.OperationNotSupportedException;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.WritePersistenceManagerInterface;
import gov.va.med.cds.persistence.hibernate.AbstractHibernatePersistenceManager;
import gov.va.med.cds.persistence.hibernate.CensusIDs;
import gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.template.generated.clinicaldata.Patients;
import gov.va.med.cds.template.generated.clinicaldata.RoutingDataType;
import gov.va.med.cds.template.generated.common.ClinicalDataPatient;
import gov.va.med.cds.template.generated.surveys.CensusSurveyResponse;
import gov.va.med.cds.template.generated.surveyscommon.Vendor;
import gov.va.med.cds.util.DateTimeUtil;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;

public class WriteableCensusSurveyPersistenceManager
extends AbstractHibernatePersistenceManager
implements WritePersistenceManagerInterface {
    private List<BooleanRuleInterface> rules;
    private String cdsAppName;

    @Override
    public boolean isApplicable(Object critera) throws PersistenceException {
        BooleanRuleInterface r;
        boolean b = false;
        Iterator<BooleanRuleInterface> iterator = this.rules.iterator();
        while (iterator.hasNext() && !(b = (r = iterator.next()).evaluate(critera))) {
        }
        return b;
    }

    @Override
    public String performCUADOnClinicalData(String templateId, Operation operation, Object aObject, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        throw new OperationNotSupportedException(ErrorCodeEnum.METHOD_NOT_IMPLEMENTED);
    }

    @Override
    public String performCUADOnPatientsData(String templateId, String aRequestId, Operation aOperation, Object aObject, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        Session session = null;
        String resultId = "";
        try {
            session = this.getSessionFactory(templateId).getCurrentSession();
            Patients patients = (Patients)this.unmarshalElementToObject((Element)aObject, domainEntryPoint);
            List patientsList = patients.getPatient();
            Long censusMasterID = 0L;
            Long censusSegmentID = 0L;
            Integer censusExpectedCount = patients.getSegment().getLast();
            String segmentDatetime = patients.getSegment().getDatetime().toString();
            Integer currentSegment = patients.getSegment().getCurrent();
            RoutingDataType routingData = (RoutingDataType)patients.getRoutingData().get(0);
            String sendingApplication = routingData.getSendingApplication();
            String stationNumber = routingData.getStationNumber();
            String sendingFacility = routingData.getSendingFacility();
            String receivingApplication = routingData.getReceivingApplication();
            String receivingFacility = routingData.getReceivingFacility();
            ClinicalDataPatient patient = (ClinicalDataPatient)patientsList.get(0);
            CensusSurveyResponse censusSurveyResponse = (CensusSurveyResponse)patient.getCensusSurveyResponse().get(0);
            Vendor vendor = censusSurveyResponse.getVendor();
            String vendorName = vendor.getVendorName();
            String vendorFacility = vendor.getVendorNumber();
            Date reportStartDate = censusSurveyResponse.getReportStartDate();
            Date reportEndDate = censusSurveyResponse.getReportEndDate();
            Query query = session.getNamedQuery("census_master_record_mgt.census_master_records").setParameter("reportStartDate", (Object)reportStartDate).setParameter("vendorName", (Object)vendorName).setParameter("vendorFacility", (Object)vendorFacility).setParameter("segmentDatetime", (Object)segmentDatetime).setParameter("censusExpectedCount", (Object)censusExpectedCount).setParameter("currentSegment", (Object)currentSegment).setParameter("senderAddress", null).setParameter("reportEndDt", (Object)reportEndDate).setParameter("requestId", (Object)aRequestId).setParameter("sendingApplication", (Object)sendingApplication).setParameter("stationNo", (Object)stationNumber).setParameter("sendingFacility", (Object)sendingFacility).setParameter("receivingApplication", (Object)receivingApplication).setParameter("receivingFacility", (Object)receivingFacility);
            List result = query.list();
            CensusIDs censusIDs = (CensusIDs)result.get(0);
            String errorMessage = censusIDs.geterrorMessage();
            String ackStatus = censusIDs.getAckStatus();
            if (!errorMessage.equalsIgnoreCase("SUCCESS")) {
                this.errorHanding(errorMessage, segmentDatetime, reportStartDate, currentSegment, reportEndDate, aRequestId, stationNumber, ackStatus);
            }
            censusMasterID = censusIDs.getcensusMasterID();
            censusSegmentID = censusIDs.getcensusSegmentID();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)LogMessageUtil.buildMessage((String)templateId, (String)aRequestId, (String)this.cdsAppName, (String)("Storing Census records for:" + patientsList.size() + " patients")));
            }
            int batchCount = 0;
            double start = System.currentTimeMillis();
            CensusSurveyResponse censusRecord = null;
            for (int i = 1; i <= patientsList.size(); ++i) {
                ++batchCount;
                patient = (ClinicalDataPatient)patientsList.get(i - 1);
                censusRecord = (CensusSurveyResponse)patient.getCensusSurveyResponse().get(0);
                censusRecord.setRequestId(aRequestId);
                censusRecord.setCensusSegmentID(censusSegmentID);
                censusRecord.setCensusMasterID(censusMasterID);
                resultId = this.createData(session, censusRecord);
                if (batchCount % 100 != 0) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Writing batch of 100 census records: " + i));
                }
                session.flush();
                session.clear();
            }
            session.flush();
            session.clear();
            Query completeQuery = session.getNamedQuery("census_master_record_mgt.census_segment_complete").setParameter("censusMasterID", (Object)censusMasterID).setParameter("censusSegmentID", (Object)censusSegmentID);
            List resultSegment = completeQuery.list();
            double end = (double)System.currentTimeMillis() - start;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"===========================================================================\n");
                LOGGER.debug((Object)("Total time storing census records: " + end + "\n"));
                LOGGER.debug((Object)("Total item or record count: " + batchCount + "\n"));
                LOGGER.debug((Object)"===========================================================================\n");
            }
        }
        catch (ConstraintViolationException e) {
            throw new HibernateConstraintViolationException(e);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCause((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage();
            throw new PersistenceException(ErrorCodeEnum.HDRII_OPERATION_FAILED, e, aOperation.name(), rootCauseMessage, domainEntryPoint.getName());
        }
        return resultId;
    }

    protected void errorHanding(String errorMessage, String segmentDatetime, Date reportStartDate, int currentSegment, Date reportEndDate, String requestId, String vendorId, String ackStatus) throws PersistenceException {
        if (null != ackStatus && !ackStatus.equalsIgnoreCase("INPROGRESS")) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_CENSUS_ACK_ALREADY_SENT);
        }
        if (errorMessage.contentEquals("WRITE_REQUEST_CENSUS_TOO_MANY_SEGMENTS")) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_CENSUS_NO_OF_SEGS_RECEPTION_TIME_EXPIRED, DateTimeUtil.convertDate2String((Date)reportStartDate), DateTimeUtil.convertDate2String((Date)reportEndDate), requestId, vendorId);
        }
        if (errorMessage.contentEquals("WRITE_REQUEST_CENSUS_SEGMENT_DUPLICATE") || errorMessage.contentEquals("WRITE_REQUEST_CENSUS_ALREADY_SUBMITTED")) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_CENSUS_SEGMENT_DUPLICATE, DateTimeUtil.convertDate2String((Date)reportStartDate), segmentDatetime, String.valueOf(currentSegment));
        }
        if (errorMessage.contentEquals("WRITE_REQUEST_CENSUS_STATUS_ALREADY_COMPLETE")) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_CENSUS_STATUS_COMPLETE, DateTimeUtil.convertDate2String((Date)reportStartDate), segmentDatetime);
        }
        if (errorMessage.contentEquals("WRITE_REQUEST_CENSUS_INVALID_START_DATE")) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_CENSUS_INVALID_START_DATE, DateTimeUtil.convertDate2String((Date)reportStartDate), DateTimeUtil.convertDate2String((Date)reportEndDate), requestId, vendorId);
        }
        throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_CENSUS_SEGMENT_FAILED, DateTimeUtil.convertDate2String((Date)reportStartDate), segmentDatetime, String.valueOf(currentSegment));
    }

    protected String createData(Session session, CensusSurveyResponse surveyResponse) {
        return session.save((Object)surveyResponse).toString();
    }

    public void setRules(List<BooleanRuleInterface> rules) {
        this.rules = rules;
    }

    public void setCdsAppName(String cdsAppName) {
        this.cdsAppName = cdsAppName;
    }
}

