/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import gov.va.med.cds.persistence.hibernate.VistaStoredProcedureQueryWork;
import gov.va.med.cds.response.strategy.VistaStoredProcedureResponseStrategyInterface;
import gov.va.med.cds.util.TimeoutUtil;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.util.StringUtils;

public class VistaStoredProcedureWriteWork
extends VistaStoredProcedureQueryWork {
    private Map<String, Set<String>> templateIdToDataListMap;

    public VistaStoredProcedureWriteWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, List<String> personIdentifiers, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, Map<String, String> queryMap, VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy, String applicationName, String siteId) {
        super(session, queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, queryMap, null, applicationName, siteId);
    }

    private String buildQueryString(String associationName, EntryFilterInterface aEntryFilter) throws ReadException {
        String sqlQuery = null;
        String queryName = String.format("%s.%s.%s", this.entryFilter.getTemplateId(), this.entryFilter.getDomainEntryPoint(), associationName);
        sqlQuery = (String)this.queryMap.get(queryName);
        return sqlQuery;
    }

    private String extractVistaPatientIdentifier(String pid) {
        QueryParameterTransformerInterface pidsParameterTransformer = (QueryParameterTransformerInterface)this.parameterTransformerMap.get("pids");
        if (pidsParameterTransformer == null) {
            throw new ReadException(ErrorCodeEnum.PARAMETER_TRANSFORMER_EXPECTED_ERROR, "pids");
        }
        String patientIdentifier = pidsParameterTransformer.transform(pid).toString();
        return patientIdentifier;
    }

    protected List<String> buildQueryParameterList(String query, String associationName, EntryFilterInterface aEntryFilter) {
        ArrayList<String> namedParameters = new ArrayList<String>();
        namedParameters.add(aEntryFilter.getRequestId());
        namedParameters.add("call name");
        namedParameters.add(this.extractVistaPatientIdentifier((String)this.personIdentifiers.get(0)));
        Set<String> paramNames = this.templateIdToDataListMap.get(aEntryFilter.getTemplateId());
        Map<String, Object> parameterMap = aEntryFilter.getDataMap();
        if (parameterMap != null) {
            for (String paramName : paramNames) {
                namedParameters.add((String)parameterMap.get(paramName));
            }
        } else {
            namedParameters.add("");
        }
        return namedParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Statement cstmt = null;
        Connection pooledConnection = null;
        Connection wrappedConnection = null;
        ResultSet rs = null;
        try {
            String query = this.buildQueryString(this.queryAssociation.getAssociationName(), this.entryFilter);
            List<String> namedParameters = this.buildQueryParameterList(query, this.queryAssociation.getAssociationName(), this.entryFilter);
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
            DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)this.session.getSessionFactory());
            wrappedConnection = dataSource.getConnection();
            pooledConnection = this.pooledConnectionUnwrapper.unwrap(wrappedConnection);
            cstmt = pooledConnection.prepareCall(query);
            for (int i = 0; i < namedParameters.size(); ++i) {
                cstmt.setString(i + 1, namedParameters.get(i));
            }
            long queryTimeout = TimeoutUtil.processTimeout(this.getTemplateTimeoutMap(), this.entryFilter, this.applicationName);
            cstmt.setQueryTimeout((int)queryTimeout);
            rs = cstmt.executeQuery();
            while (rs.next()) {
                String returnError = rs.getString("returnError");
                if (StringUtils.hasLength((String)returnError)) {
                    this.addException(new Exception(returnError), this.applicationName);
                }
                DefaultLobHandler lobHandler = new DefaultLobHandler();
                HashMap<String, Object> results = new HashMap<String, Object>();
                byte[] blobBytes = lobHandler.getBlobAsBytes(rs, "stream");
                results.put("stream", blobBytes);
                results.put("siteID", rs.getString("siteID"));
                results.put("params", rs.getString("params"));
                resultList.add(results);
            }
            if (resultList == null) return;
            if (resultList.size() <= 0) return;
            if (((Map)resultList.get(0)).get("stream") == null) return;
            this.results = this.vistaResponseStrategy.formatResponse(resultList, this.entryFilter.getDomainEntryPoint(), this.entryFilter.getTemplateId());
            return;
        }
        catch (SocketException se) {
            this.addException(se, this.applicationName);
            return;
        }
        catch (Exception ex) {
            this.addException(ex, this.applicationName);
            return;
        }
        finally {
            if (rs != null) {
                try {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (Exception er) {
                        er.printStackTrace();
                        rs = null;
                    }
                }
                catch (Throwable throwable) {
                    rs = null;
                    throw throwable;
                }
            }
            if (cstmt != null) {
                try {
                    try {
                        cstmt.close();
                        cstmt = null;
                    }
                    catch (SQLException ec) {
                        ec.printStackTrace();
                        cstmt = null;
                    }
                }
                catch (Throwable throwable) {
                    cstmt = null;
                    throw throwable;
                }
            }
            if (pooledConnection != null) {
                try {
                    try {
                        pooledConnection.close();
                        pooledConnection = null;
                    }
                    catch (SQLException ep) {
                        ep.printStackTrace();
                        pooledConnection = null;
                    }
                }
                catch (Throwable throwable) {
                    pooledConnection = null;
                    throw throwable;
                }
            }
            if (wrappedConnection != null) {
                try {
                    try {
                        wrappedConnection.close();
                        wrappedConnection = null;
                    }
                    catch (SQLException ew) {
                        ew.printStackTrace();
                        wrappedConnection = null;
                    }
                }
                catch (Throwable throwable) {
                    wrappedConnection = null;
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void setVistaResponseStrategy(VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy) {
        this.vistaResponseStrategy = vistaResponseStrategy;
    }

    @Override
    public void setQueryMap(Map<String, String> queryMap) {
        this.queryMap = queryMap;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public void release() {
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.cancelQuery();
                this.session.close();
            }
        }
        catch (HibernateException e) {
            this.addException((Exception)((Object)e), this.applicationName);
        }
        finally {
            this.session = null;
        }
    }

    @Override
    public QueryAssociationInterface getQueryAssociation() {
        return this.queryAssociation;
    }

    @Override
    public Object getResults() {
        return this.results;
    }

    @Override
    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void addException(Exception ex, String applicationName) {
        ExceptionHandler.logRootException(ex, this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), applicationName);
        this.exceptions.add(ex);
    }

    public void setTemplateIdToDataListMap(Map<String, Set<String>> templateIdToDataListMap) {
        this.templateIdToDataListMap = templateIdToDataListMap;
    }
}

