/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.filter.QueryParameter;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import gov.va.med.cds.persistence.hibernate.VistaStoredProcedureQueryWork;
import gov.va.med.cds.persistence.hibernate.rpc.RpcParamStringBuilderInterface;
import gov.va.med.cds.response.strategy.VistaGenericStoredProcedureSingleResponseStrategyInterface;
import gov.va.med.cds.util.CipherUtilities;
import gov.va.med.cds.util.TimeoutUtil;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.util.StringUtils;

public class VistaGenericStoredProcedureQueryWork
extends VistaStoredProcedureQueryWork {
    protected static final Log LOGGER = LogFactory.getLog(VistaGenericStoredProcedureQueryWork.class);
    private static final String STORED_PROCEDURE_NAME = "GenericObservationRead1.GSP";
    private static final String DOMAIN = "domain";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String RECORD_ID = "id";
    private static final String TEXT = "text";
    private static final String TEXT_TRUE = "true";
    private static final String TEXT_FALSE = "false";
    private static final String SHOW_DOCUMENTS = "1";
    private static final String NO_DOCUMENTS = "0";
    private static final String CACHE_DATE_FORMAT = "yyyyMMddHHmmss";
    private static final String ACCESS_LEVEL = "3X";
    private static final byte[] EKEY = new byte[]{83, -88, 66, 69, 29, -48, 35, -9, 46, 117, -61, -13, 48, -85, 32, -65};
    private String username;
    private String password;
    private byte[] key;
    private VistaGenericStoredProcedureSingleResponseStrategyInterface vistaGenericResponseStrategy;
    private RpcParamStringBuilderInterface rpcBuilder;

    public VistaGenericStoredProcedureQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, List<String> personIdentifiers, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, Map<String, String> queryMap, VistaGenericStoredProcedureSingleResponseStrategyInterface vistaGenericResponseStrategy, String applicationName, String siteId, String userName, String password, byte[] aKey, RpcParamStringBuilderInterface rpcBuilder) {
        super(session, queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, queryMap, null, applicationName, siteId);
        LOGGER.debug((Object)("VistaGenericStoredProcedureQueryWork(...username, password, key):" + this.username + ", " + password + ", " + this.key));
        this.setUsername(userName);
        this.setPassword(password);
        this.setKey(aKey);
        this.setRpcBuilder(rpcBuilder);
        this.setVistaGenericResponseStrategy(vistaGenericResponseStrategy);
    }

    @Override
    protected String buildQueryString(String associationName, EntryFilterInterface aEntryFilter, List<String> personIdentifiers) throws ReadException {
        return (String)this.queryMap.get(STORED_PROCEDURE_NAME);
    }

    @Override
    protected List<String> buildQueryParameterList(String query, String associationName, EntryFilterInterface aEntryFilter, List<String> personIdentifiers) {
        ArrayList<String> spParameters = new ArrayList<String>();
        spParameters.add(this.username);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(CACHE_DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            String datePlain = sdf.format(new Date());
            String decryptedPasswd = CipherUtilities.decrypt((byte[])EKEY, (byte[])new byte[16], (String)this.password);
            String newEncryptPassword = CipherUtilities.encrypt((String)(ACCESS_LEVEL + datePlain + decryptedPasswd), (byte[])this.key, (byte[])new byte[16]);
            spParameters.add(newEncryptPassword);
        }
        catch (Exception e) {
            throw new PersistenceException(ErrorCodeEnum.ROOT_CAUSE_MSG, e, "Error creating encrypted timestamp required by GSP.");
        }
        String rpcName = this.rpcBuilder.getRpcName();
        if (rpcName == null | "".equals(rpcName)) {
            throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, "RPC NAME");
        }
        spParameters.add(rpcName);
        HashMap<String, String> mApiParams = new HashMap<String, String>();
        String patientArgName = this.rpcBuilder.getRpcPatientArgName();
        if (patientArgName != null) {
            mApiParams.put(patientArgName, this.extractVistaPatientIdentifier(personIdentifiers));
        }
        String dateRangeStart = this.extractVistaDateFromFilter(aEntryFilter.getStartDate(), "18410101000000");
        String dateRangeEnd = this.extractVistaDateFromFilter(aEntryFilter.getEndDate(), "30001231235959");
        if (dateRangeEnd != null && !"".equals(dateRangeEnd)) {
            mApiParams.put(STOP, dateRangeEnd);
        }
        if (dateRangeStart != null && !"".equals(dateRangeStart)) {
            mApiParams.put(START, dateRangeStart);
        }
        if (aEntryFilter.getDomainEntryPoint() == null || "".equals(aEntryFilter.getDomainEntryPoint())) {
            throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, DOMAIN);
        }
        mApiParams.put(DOMAIN, aEntryFilter.getDomainEntryPoint());
        if (aEntryFilter.getRecordIdentifiers() != null) {
            if (aEntryFilter.getRecordIdentifiers().size() > 1) {
                throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, RECORD_ID);
            }
            if (aEntryFilter.getRecordIdentifiers().size() == 1) {
                mApiParams.put(RECORD_ID, aEntryFilter.getRecordIdentifiers().get(0));
            }
        }
        ParameterMapInterface parameterMap = aEntryFilter.getAdditionalParametersMap();
        String value = null;
        for (String filterParameterName : parameterMap.getFilterParameterNames()) {
            QueryParameter<Object> queryParameter = parameterMap.getParameterValue(filterParameterName);
            if (queryParameter == null) {
                throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, filterParameterName);
            }
            if ("dateRange".equals(queryParameter.getType())) {
                throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, filterParameterName);
            }
            if (!(queryParameter.getValue() instanceof String)) {
                throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, filterParameterName);
            }
            if (queryParameter.getName().equals(TEXT)) {
                QueryParameter<String> textParameter = new QueryParameter<String>();
                textParameter.setName(TEXT);
                value = (String)queryParameter.getValue();
                if (StringUtils.hasText((String)value)) {
                    if (value.equalsIgnoreCase(TEXT_TRUE)) {
                        textParameter.setValue(SHOW_DOCUMENTS);
                    } else if (value.equalsIgnoreCase(TEXT_FALSE)) {
                        textParameter.setValue(NO_DOCUMENTS);
                    }
                    queryParameter = textParameter;
                }
            }
            mApiParams.put(queryParameter.getName(), (String)queryParameter.getValue());
        }
        spParameters.add(this.rpcBuilder.build(mApiParams));
        return spParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Statement cstmt = null;
        Connection pooledConnection = null;
        Connection wrappedConnection = null;
        ResultSet rs = null;
        try {
            String query = this.buildQueryString(this.queryAssociation.getAssociationName(), this.entryFilter, this.personIdentifiers);
            List<String> namedParameters = this.buildQueryParameterList(query, this.queryAssociation.getAssociationName(), this.entryFilter, this.personIdentifiers);
            ArrayList resultList = new ArrayList();
            DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)this.session.getSessionFactory());
            wrappedConnection = dataSource.getConnection();
            pooledConnection = this.pooledConnectionUnwrapper.unwrap(wrappedConnection);
            cstmt = pooledConnection.prepareCall(query);
            for (int i = 0; i < namedParameters.size(); ++i) {
                cstmt.setString(i + 1, namedParameters.get(i));
            }
            long queryTimeout = TimeoutUtil.processTimeout(this.getTemplateTimeoutMap(), this.entryFilter, this.applicationName);
            cstmt.setQueryTimeout((int)queryTimeout);
            rs = cstmt.executeQuery();
            ArrayList<String> records = new ArrayList<String>();
            while (rs.next()) {
                String dataRecord = rs.getString("Data");
                String errorRecord = rs.getString("Error");
                if (StringUtils.hasLength((String)errorRecord)) {
                    this.addEmbeddedRpcError(errorRecord);
                    continue;
                }
                records.add(dataRecord);
            }
            if (records == null) return;
            if (records.size() <= 0) return;
            this.results = this.vistaGenericResponseStrategy.formatResponse(records, this.extractVistaPatientIdentifier(this.personIdentifiers), this.entryFilter, this.siteId);
            return;
        }
        catch (SocketException se) {
            this.addException(se, this.applicationName);
            return;
        }
        catch (Exception ex) {
            this.addException(ex, this.applicationName);
            return;
        }
        finally {
            if (rs != null) {
                try {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (Exception er) {
                        er.printStackTrace();
                        rs = null;
                    }
                }
                catch (Throwable throwable) {
                    rs = null;
                    throw throwable;
                }
            }
            if (cstmt != null) {
                try {
                    try {
                        cstmt.close();
                        cstmt = null;
                    }
                    catch (SQLException ec) {
                        ec.printStackTrace();
                        cstmt = null;
                    }
                }
                catch (Throwable throwable) {
                    cstmt = null;
                    throw throwable;
                }
            }
            if (pooledConnection != null) {
                try {
                    try {
                        pooledConnection.close();
                        pooledConnection = null;
                    }
                    catch (SQLException ep) {
                        ep.printStackTrace();
                        pooledConnection = null;
                    }
                }
                catch (Throwable throwable) {
                    pooledConnection = null;
                    throw throwable;
                }
            }
            if (wrappedConnection != null) {
                try {
                    try {
                        wrappedConnection.close();
                        wrappedConnection = null;
                    }
                    catch (SQLException ew) {
                        ew.printStackTrace();
                        wrappedConnection = null;
                    }
                }
                catch (Throwable throwable) {
                    wrappedConnection = null;
                    throw throwable;
                }
            }
        }
    }

    private void addEmbeddedRpcError(String rpcErrorMessage) {
        int begin = rpcErrorMessage.indexOf(34);
        int end = rpcErrorMessage.lastIndexOf(34);
        rpcErrorMessage = rpcErrorMessage.substring(begin + 1, end);
        Exception rootCause = new Exception("VISTA SITE ERROR");
        this.addException(new Exception(rpcErrorMessage, rootCause), this.applicationName);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKey(byte[] aKey) {
        this.key = aKey;
    }

    public void setVistaGenericResponseStrategy(VistaGenericStoredProcedureSingleResponseStrategyInterface vistaGenericResponseStrategy) {
        this.vistaGenericResponseStrategy = vistaGenericResponseStrategy;
    }

    public void setRpcBuilder(RpcParamStringBuilderInterface rpcBuilder) {
        this.rpcBuilder = rpcBuilder;
    }
}

