/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponse400;
import gov.va.med.cds.persistence.JNDIDataSourceBindingsLocatorInterface;
import gov.va.med.cds.persistence.PersistenceManagerInterface;
import gov.va.med.cds.persistence.QueryStrategyInterface;
import gov.va.med.cds.persistence.hibernate.SiteSpecificHibernateReadPersistenceManager;
import gov.va.med.cds.persistence.hibernate.SpringHibernateLocalSessionFactoryPropertyHolder;
import gov.va.med.cds.persistence.hibernate.common.VistaPreQueryExecutionInterface;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import gov.va.med.cds.transaction.WorkManagerInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;

public class SiteSpecificHibernateReadPersistenceManagerFactory {
    private Log logger = LogFactory.getLog(SiteSpecificHibernateReadPersistenceManagerFactory.class);
    private Map<String, SpringHibernateLocalSessionFactoryPropertyHolder> propertyHolderMap;
    private JNDIDataSourceBindingsLocatorInterface dataSourceBindingsLocator;
    private List<BooleanRuleInterface> rules;
    protected Map<String, QueryStrategyInterface> templateQueryStrategyMap;
    private long readTimeout = Long.MAX_VALUE;
    protected Class<?> pointInTimeUserTypeName;
    private WorkManagerInterface workManager;
    private WorkManagerInterface queryThreadWorkManager;
    private String managerIdentifierFormat;
    private Map<String, String> templateTimeoutMap = null;
    private List<String> vistaExcludedTemplateIdsList;
    private ClinicalDataResponse400 defaultCDSResponse;
    private Map<String, VistaPreQueryExecutionInterface> vistaPreQueryExecutionMap;
    protected JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller;

    public Collection<PersistenceManagerInterface> create() throws Exception {
        ArrayList<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        Collection<Binding> dataSourceBindings = this.dataSourceBindingsLocator.getDataSourceBindings();
        for (Binding binding : dataSourceBindings) {
            SiteSpecificHibernateReadPersistenceManager persistenceManager = this.createNewPersistenceManager(binding.getName());
            Map<String, SessionFactory> newSessionFactoryMap = this.createNewSessionFactoryMap((DataSource)binding.getObject());
            persistenceManager.setSessionFactoryMap(newSessionFactoryMap);
            persistenceManagers.add(persistenceManager);
        }
        return persistenceManagers;
    }

    @Required
    public final void setSessionFactoryPropertyHolderMap(Map<String, SpringHibernateLocalSessionFactoryPropertyHolder> propertyHolderMap) {
        this.propertyHolderMap = propertyHolderMap;
    }

    @Required
    public final void setDataSourceBindingsLocator(JNDIDataSourceBindingsLocatorInterface dataSourcesLocator) {
        this.dataSourceBindingsLocator = dataSourcesLocator;
    }

    @Required
    public void setRules(List<BooleanRuleInterface> rules) {
        this.rules = rules;
    }

    @Required
    public void setTemplateQueryStrategyMap(Map<String, QueryStrategyInterface> templateQueryStrategyMap) {
        this.templateQueryStrategyMap = templateQueryStrategyMap;
    }

    @Required
    public void setWorkManager(WorkManagerInterface workManager) {
        this.workManager = workManager;
    }

    @Required
    public void setQueryThreadWorkManager(WorkManagerInterface queryThreadWorkManager) {
        this.queryThreadWorkManager = queryThreadWorkManager;
    }

    @Required
    public void setTemplateTimeoutMap(Map<String, String> templateTimeoutMap) {
        this.templateTimeoutMap = templateTimeoutMap;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Required
    public void setPointInTimeUserType(Class<?> pointInTimeUserType) throws ClassNotFoundException {
        this.pointInTimeUserTypeName = pointInTimeUserType;
    }

    @Required
    public void setManagerIdentifierFormat(String managerIdentifier) {
        this.managerIdentifierFormat = managerIdentifier;
    }

    private Map<String, SessionFactory> createNewSessionFactoryMap(DataSource dataSource) throws Exception {
        HashMap<String, SessionFactory> newMap = new HashMap<String, SessionFactory>();
        for (Map.Entry<String, SpringHibernateLocalSessionFactoryPropertyHolder> entry : this.propertyHolderMap.entrySet()) {
            SpringHibernateLocalSessionFactoryPropertyHolder curPropertyHolder = entry.getValue();
            LocalSessionFactoryBean newFactory = new LocalSessionFactoryBean();
            newFactory.setMappingResources(curPropertyHolder.getMappingResources());
            newFactory.setHibernateProperties(curPropertyHolder.getHibernateProperties());
            newFactory.setDataSource(dataSource);
            newFactory.afterPropertiesSet();
            SessionFactory sessionFactory = newFactory.getObject();
            newMap.put(entry.getKey(), sessionFactory);
        }
        return newMap;
    }

    private SiteSpecificHibernateReadPersistenceManager createNewPersistenceManager(String name) throws ClassNotFoundException {
        SiteSpecificHibernateReadPersistenceManager persistenceManager = new SiteSpecificHibernateReadPersistenceManager();
        String managerIdentifier = MessageFormat.format(this.managerIdentifierFormat, name);
        persistenceManager.setManagerIdentifier(managerIdentifier);
        persistenceManager.setPointInTimeUserType(this.pointInTimeUserTypeName);
        persistenceManager.setRules(this.rules);
        persistenceManager.setSiteIdentifier(name);
        persistenceManager.setTemplateQueryStrategyMap(this.templateQueryStrategyMap);
        persistenceManager.setQueryThreadWorkManager(this.queryThreadWorkManager);
        persistenceManager.setTemplateTimeoutMap(this.templateTimeoutMap);
        persistenceManager.setVistaExcludedTemplateIdsList(this.vistaExcludedTemplateIdsList);
        persistenceManager.setDefaultCDSResponse(this.defaultCDSResponse);
        persistenceManager.setVistaPreQueryExecutionMap(this.vistaPreQueryExecutionMap);
        persistenceManager.setMarshallerUnmarshaller(this.marshallerUnmarshaller);
        if (this.logger.isInfoEnabled()) {
            String msg = "Created site specific persistence Manager: siteId=" + name + " managerIdentifier=" + managerIdentifier;
            this.logger.info((Object)LogMessageUtil.buildMessage(null, null, null, (String)msg), null);
        }
        return persistenceManager;
    }

    public void setVistaExcludedTemplateIdsList(List<String> vistaExcludedTemplateIdsList) {
        this.vistaExcludedTemplateIdsList = vistaExcludedTemplateIdsList;
    }

    public void setDefaultCDSResponse(ClinicalDataResponse400 defaultCDSResponse) {
        this.defaultCDSResponse = defaultCDSResponse;
    }

    public JaxBMarshallerUnmarshallerInterface getMarshallerUnmarshaller() {
        return this.marshallerUnmarshaller;
    }

    public void setMarshallerUnmarshaller(JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        this.marshallerUnmarshaller = marshallerUnmarshaller;
    }

    @Required
    public void setPreQueryExecutionMap(Map<String, VistaPreQueryExecutionInterface> vistaPreQueryExecutionMap) {
        this.vistaPreQueryExecutionMap = vistaPreQueryExecutionMap;
    }
}

