/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.QueryStrategyInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.hibernate.DefaultHibernateReadPersistenceManager;
import gov.va.med.cds.persistence.hibernate.common.VistaPreQueryExecutionInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Required;

public class SiteSpecificHibernateReadPersistenceManager
extends DefaultHibernateReadPersistenceManager {
    private Map<String, VistaPreQueryExecutionInterface> vistaPreQueryExecutionMap;

    @Override
    public boolean isApplicable(EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers) throws PersistenceException {
        return super.isApplicable(entryFilter, personIdentifiers) && this.containsSiteIdentifier(personIdentifiers, entryFilter);
    }

    @Override
    protected List<QueryWorkInterface> createQueryWork(QueryStrategyInterface queryStrategy, EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers, Class<?> pointInTimeUserType, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) throws PersistenceException {
        List patientIdentifiers = null;
        SessionFactory sessionFactory = this.getSessionFactory(entryFilter.getTemplateId());
        if (entryFilter.isPatientCentricFilter()) {
            List<String> sitePatients = this.findSitePatients(personIdentifiers);
            patientIdentifiers = this.handlePatientIdentifiers(sessionFactory.openSession(), entryFilter, sitePatients);
        }
        return queryStrategy.createQueryWork(sessionFactory, entryFilter, patientIdentifiers, pointInTimeUserType, siteId, marshallerUnmarshaller);
    }

    private List<String> findSitePatients(List<PersonIdentifierInterface> personIdentifiers) {
        ArrayList<String> sitePatients = new ArrayList<String>();
        if (personIdentifiers == null || personIdentifiers.size() == 0) {
            throw new ReadException(ErrorCodeEnum.READ_PERSISTENCE_MGR_NULL_PERSON_IDENTIFIERS_LIST, this.managerIdentifier);
        }
        for (PersonIdentifierInterface personIdentifier : personIdentifiers) {
            if (!this.siteIdentifier.equals(personIdentifier.getAssigningFacility())) continue;
            sitePatients.add(personIdentifier.getIdentity());
        }
        if (sitePatients.size() == 0) {
            throw new ReadException(ErrorCodeEnum.READ_PERSISTENCE_MGR_NO_PERSON_WITH_SITE_ID, this.siteIdentifier);
        }
        return sitePatients;
    }

    private boolean containsSiteIdentifier(List<PersonIdentifierInterface> personIdentifiers, EntryFilterInterface entryFilter) {
        String siteIdentifier;
        if (personIdentifiers != null) {
            for (PersonIdentifierInterface personIdentifier : personIdentifiers) {
                if (!this.siteIdentifier.equals(personIdentifier.getAssigningFacility())) continue;
                return true;
            }
        }
        return entryFilter.isSiteCentricFilter() && (siteIdentifier = this.getSiteIdentifier()) != null && siteIdentifier.equals(entryFilter.getFacilityId());
    }

    @Override
    public String getSiteIdentifier() {
        return this.siteIdentifier;
    }

    protected List handlePatientIdentifiers(Session session, EntryFilterInterface entryFilter, List patientIdentifiers) throws ReadException {
        VistaPreQueryExecutionInterface vistaPreQueryExecutor;
        if (this.vistaPreQueryExecutionMap != null && (vistaPreQueryExecutor = this.vistaPreQueryExecutionMap.get(entryFilter.getTemplateId() + "-" + entryFilter.getDomainEntryPoint())) != null) {
            return vistaPreQueryExecutor.getRowIds(session, entryFilter, patientIdentifiers);
        }
        return patientIdentifiers;
    }

    @Required
    public void setVistaPreQueryExecutionMap(Map<String, VistaPreQueryExecutionInterface> vistaPreQueryExecutionMap) {
        this.vistaPreQueryExecutionMap = vistaPreQueryExecutionMap;
    }
}

