/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import gov.va.med.cds.persistence.hibernate.common.PointInTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class PointInTimeQueryParameterTransformer
implements QueryParameterTransformerInterface {
    protected static final String DATA_FORMAT_PATTERN = "yyyyMMddHHmmss";

    @Override
    public void transformAndSetParameter(String parameterName, Object parameterValue, Map<String, Object> parameterMap) {
        parameterMap.put(parameterName, this.transform(parameterValue));
    }

    @Override
    public Object transform(Object parameterValue) {
        if (!(parameterValue instanceof Calendar)) {
            throw new IllegalArgumentException("PointInTimeQueryParameterSetter only supports parameter values of type Calendar.");
        }
        Calendar date = (Calendar)parameterValue;
        PointInTime pointInTime = new PointInTime();
        pointInTime.setTimestamp(new SimpleDateFormat(DATA_FORMAT_PATTERN).format(date.getTime()));
        return pointInTime;
    }

    @Override
    public Object transform(String parameterValue) {
        return null;
    }
}

