/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.hibernate.DefaultQueryWork;
import gov.va.med.cds.persistence.hibernate.FilterParameterExtractorInterface;
import gov.va.med.cds.persistence.hibernate.QueryNameBuilderInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterBinderInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;

public class PageableQueryWork
extends DefaultQueryWork {
    private static final int INDEX_OFFSET_BY_1 = 1;

    public PageableQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, QueryNameBuilderInterface queryNameBuilder, FilterParameterExtractorInterface filterParameterExtractor, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, QueryParameterBinderInterface queryParameterBinder, List<String> personIdentifiers, Class<?> pointInTimeUserType, String applicationName, String siteId) {
        super(session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, queryParameterBinder, personIdentifiers, pointInTimeUserType, applicationName, siteId);
    }

    public PageableQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, QueryNameBuilderInterface queryNameBuilder, FilterParameterExtractorInterface filterParameterExtractor, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, QueryParameterBinderInterface queryParameterBinder, Map<String, String> templateTimeoutMap, List<String> personIdentifiers, Class<?> pointInTimeUserType, String applicationName, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        super(session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, queryParameterBinder, templateTimeoutMap, personIdentifiers, pointInTimeUserType, applicationName, siteId, marshallerUnmarshaller);
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            Query query = this.prepareQuery(this.session, this.queryAssociation.getAssociationName(), this.entryFilter, this.personIdentifiers);
            if (query != null) {
                startTime = System.currentTimeMillis();
                query.setReadOnly(true);
                ScrollableResults scrollableResults = query.scroll();
                if (scrollableResults.last()) {
                    int indexOfLast = scrollableResults.getRowNumber();
                    int pagingOffset = 0;
                    if (!this.entryFilter.isCountOnly()) {
                        int firstRowNumber;
                        if (this.entryFilter.isPagingFilter() && this.isEntryPointQuery()) {
                            pagingOffset = (this.entryFilter.getPageNumber() - 1) * this.entryFilter.getPageSize();
                            query.setFirstResult(pagingOffset);
                            if (this.entryFilter.getPageSize() > 0) {
                                query.setMaxResults(this.entryFilter.getPageSize());
                            }
                            scrollableResults = query.scroll();
                        }
                        scrollableResults.first();
                        int lastRowNumber = firstRowNumber = scrollableResults.getRowNumber() + pagingOffset;
                        do {
                            this.results.add((Element)scrollableResults.get()[0]);
                        } while (scrollableResults.next());
                        scrollableResults.last();
                        lastRowNumber = scrollableResults.getRowNumber() + pagingOffset;
                        this.addPagingInfoToResults(firstRowNumber, lastRowNumber, indexOfLast);
                    } else {
                        this.addPagingInfoToResults(0, 0, indexOfLast);
                    }
                }
                long finishTime = System.currentTimeMillis();
                if (performanceLog.isInfoEnabled()) {
                    performanceLog.logFinishTime(startTime, finishTime, "DefaultQueryWork.run()", this.entryFilter.getDomainEntryPoint(), this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), this.siteId, true, "jdbc");
                }
            }
        }
        catch (Exception ex) {
            long finishTime = System.currentTimeMillis();
            if (performanceLog.isInfoEnabled()) {
                performanceLog.logFinishTime(startTime, finishTime, "DefaultQueryWork.run()", this.entryFilter.getDomainEntryPoint(), this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), this.siteId, false, "jdbc");
            }
            this.addException(ex, this.applicationName);
        }
    }

    private boolean isEntryPointQuery() {
        return this.queryAssociation.getFilterModelName() != null && this.queryAssociation.getFilterModelName().equalsIgnoreCase(this.entryFilter.getDomainEntryPoint());
    }

    private void addPagingInfoToResults(int indexPageFirstResult, int indexPageLastResult, int indexLastResult) {
        if (this.isEntryPointQuery()) {
            if (this.entryFilter.isPagingFilter()) {
                Element pageInfoElement = DocumentHelper.createElement((String)"pageInformation");
                Element pageFirstRecordElement = DocumentHelper.createElement((String)"pageFirstRecord");
                Element pageLastRecordElement = DocumentHelper.createElement((String)"pageLastRecord");
                pageInfoElement.add(pageFirstRecordElement);
                pageInfoElement.add(pageLastRecordElement);
                pageFirstRecordElement.setText(String.valueOf(indexPageFirstResult + 1));
                pageLastRecordElement.setText(String.valueOf(indexPageLastResult + 1));
                this.results.add(pageInfoElement);
            }
            Element totalResultsElement = DocumentHelper.createElement((String)"totalResultCount");
            totalResultsElement.setText(String.valueOf(indexLastResult + 1));
            this.results.add(totalResultsElement);
        }
    }
}

