/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.hibernate.FilterParameterExtractorInterface;
import gov.va.med.cds.persistence.hibernate.HibernateQueryCriteriaDelegate;
import gov.va.med.cds.persistence.hibernate.PageableQueryWork;
import gov.va.med.cds.persistence.hibernate.QueryNameBuilderInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterBinderInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PageableCriteriaQueryWork
extends PageableQueryWork {
    public PageableCriteriaQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, QueryNameBuilderInterface queryNameBuilder, FilterParameterExtractorInterface filterParameterExtractor, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, QueryParameterBinderInterface queryParameterBinder, Map<String, String> templateTimeoutMap, List<String> personIdentifiers, Class<?> pointInTimeUserType, String applicationName, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        super(session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, queryParameterBinder, templateTimeoutMap, personIdentifiers, pointInTimeUserType, applicationName, siteId, marshallerUnmarshaller);
    }

    @Override
    protected Query prepareQuery(Session aSession, String associationName, EntryFilterInterface aEntryFilter, List<String> personIdentifiers) {
        Map dateRanges;
        String entityName = this.queryAssociation.getFilterModelName();
        ClassMetadata entityMetaData = this.session.getSessionFactory().getClassMetadata(entityName);
        Criteria criteria = this.session.createCriteria(entityName);
        Map<String, Object> queryParameterMap = this.getFilterParameters(aEntryFilter);
        if (aEntryFilter.isPatientCentricFilter()) {
            if (personIdentifiers == null || personIdentifiers.size() == 0) {
                return null;
            }
            this.addPatientIdentifiers(aEntryFilter, personIdentifiers, queryParameterMap);
            Object[] pids = ((List)queryParameterMap.remove("pids")).toArray();
            String patientIdentityColumn = this.propertyToColumn(entityName, "patient.identifier.identity");
            String patientAssigningAuthColumn = this.propertyToColumn(entityName, "patient.identifier.assigningFacility");
            String sqlRestriction = String.format("{alias}.%s || '/' || {alias}.%s  in (%s) ", patientAssigningAuthColumn, patientIdentityColumn, this.arrayToParameterizationString(pids));
            Object[] types = new Type[pids.length];
            Arrays.fill(types, StandardBasicTypes.STRING);
            criteria.add(Restrictions.sqlRestriction((String)sqlRestriction, (Object[])pids, (Type[])types));
        }
        if ((dateRanges = (Map)queryParameterMap.remove("dateRanges")) != null && dateRanges.size() > 0) {
            for (String key : dateRanges.keySet()) {
                String columnName = this.propertyToColumn(entityName, key, 1);
                String sqlRestrictionLeft = String.format("{alias}.%s between SYS_EXTRACT_UTC(?) and SYS_EXTRACT_UTC(?)", columnName);
                String sqlRestrictionRight = String.format("{alias}.%s is null", columnName);
                Map dateRange = (Map)dateRanges.get(key);
                Object[] types = new Type[dateRange.values().size()];
                Arrays.fill(types, StandardBasicTypes.TIMESTAMP);
                Object[] params = new Object[]{dateRange.get("begin"), dateRange.get("end")};
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.sqlRestriction((String)sqlRestrictionLeft, (Object[])params, (Type[])types), (Criterion)Restrictions.sqlRestriction((String)sqlRestrictionRight)));
            }
        }
        if (queryParameterMap != null && !queryParameterMap.isEmpty()) {
            for (String key : queryParameterMap.keySet()) {
                Object param = queryParameterMap.get(key);
                String columnName = this.propertyToColumn(entityName, key);
                if (param instanceof List) {
                    Object[] inParams = ((List)param).toArray(new String[0]);
                    inParams = this.stringArrayToAllUppers((String[])inParams);
                    Object[] types = new Type[inParams.length];
                    Arrays.fill(types, StandardBasicTypes.STRING);
                    String sqlRestriction = String.format("upper({alias}.%s) in (%s)", columnName, this.arrayToParameterizationString(inParams));
                    criteria.add(Restrictions.sqlRestriction((String)sqlRestriction, (Object[])inParams, (Type[])types));
                    continue;
                }
                String sqlRestriction = String.format("upper({alias}.%s) = upper(?)", columnName);
                criteria.add(Restrictions.sqlRestriction((String)sqlRestriction, (Object)queryParameterMap.get(key), (Type)StandardBasicTypes.STRING));
            }
        }
        return new HibernateQueryCriteriaDelegate(criteria);
    }

    private String arrayToParameterizationString(Object[] arr) {
        StringBuilder sbParamString = new StringBuilder();
        for (int i = 0; i < arr.length - 1; ++i) {
            sbParamString.append("?, ");
        }
        sbParamString.append("?");
        return sbParamString.toString();
    }

    private String propertyToColumn(String entityName, String propertyName) {
        return this.propertyToColumn(entityName, propertyName, 0);
    }

    private String propertyToColumn(String entityName, String propertyName, int columnIdx) {
        AbstractEntityPersister persister;
        String[] columns;
        ClassMetadata meta = this.session.getSessionFactory().getClassMetadata(entityName);
        if (meta instanceof AbstractEntityPersister && (columns = (persister = (AbstractEntityPersister)meta).toColumns(propertyName)).length >= columnIdx) {
            return columns[columnIdx];
        }
        throw new IllegalArgumentException("Can't get column name for entity.");
    }

    private String[] stringArrayToAllUppers(String[] strArr) {
        String[] retVal = new String[strArr.length];
        for (int i = 0; i < strArr.length; ++i) {
            retVal[i] = strArr[i].toUpperCase();
        }
        return retVal;
    }
}

