/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.persistence.hibernate.QueryNameBuilderInterface;

public class LegacyQueryNameBuilder
implements QueryNameBuilderInterface {
    @Override
    public String buildQueryName(EntryFilterInterface entryFilter, String associationName) {
        String queryName = String.format("%s.%s.%s", entryFilter.getTemplateId(), entryFilter.getDomainEntryPoint(), associationName);
        if (entryFilter.hasRecordIdentifiers()) {
            queryName = String.format("%s.identifiers", queryName);
        } else if (entryFilter.useDates()) {
            queryName = String.format("%s.date", queryName);
        }
        ParameterMapInterface parameterMap = entryFilter.getAdditionalParametersMap();
        if (parameterMap != null) {
            for (String filterParameterName : parameterMap.getFilterParameterNames()) {
                queryName = String.format("%s.%s", queryName, filterParameterName);
            }
        }
        if (entryFilter.containsXpathFilterExpression()) {
            queryName = String.format("%s.xpath", queryName);
        }
        return queryName;
    }
}

