/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.filter.QueryParameter;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.hibernate.FilterParameterExtractorInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import java.util.LinkedHashMap;
import java.util.Map;

public class LegacyFilterParameterExtractor
implements FilterParameterExtractorInterface {
    @Override
    public Map<String, Object> extractNamedParameters(Map<String, QueryParameterTransformerInterface> parameterTransformerMap, EntryFilterInterface entryFilter) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (entryFilter.hasRecordIdentifiers()) {
            QueryParameterTransformerInterface parameterTransformer = parameterTransformerMap.get("recordIdentifiers");
            if (parameterTransformer != null) {
                parameterTransformer.transformAndSetParameter("recordIdentifiers", entryFilter.getRecordIdentifiers(), params);
            } else {
                params.put("recordIdentifiers", entryFilter.getRecordIdentifiers());
            }
        } else if (entryFilter.useDates()) {
            QueryParameterTransformerInterface startParamTransformer = parameterTransformerMap.get("startDate");
            if (startParamTransformer == null) {
                throw new PersistenceException(ErrorCodeEnum.PARAMETER_TRANSFORMER_EXPECTED_ERROR, "startDate");
            }
            startParamTransformer.transformAndSetParameter("startDate", entryFilter.getStartDate(), params);
            QueryParameterTransformerInterface endParamTransformer = parameterTransformerMap.get("endDate");
            if (endParamTransformer != null) {
                endParamTransformer.transformAndSetParameter("endDate", entryFilter.getEndDate(), params);
            } else {
                throw new PersistenceException(ErrorCodeEnum.PARAMETER_TRANSFORMER_EXPECTED_ERROR, "endDate");
            }
        }
        ParameterMapInterface parameterMap = entryFilter.getAdditionalParametersMap();
        if (parameterMap != null) {
            for (String filterParameterName : parameterMap.getFilterParameterNames()) {
                QueryParameter<?> queryParameter = parameterMap.getParameterValue(filterParameterName);
                if (queryParameter == null) {
                    throw new PersistenceException(ErrorCodeEnum.INVALID_OR_UNEXPECTED_QUERY_PARAM, filterParameterName);
                }
                Object parameterValue = queryParameter.getValue();
                if (parameterValue instanceof Map) {
                    Map map = (Map)parameterValue;
                    for (String key : map.keySet()) {
                        params.put(key, map.get(key));
                    }
                    continue;
                }
                params.put(filterParameterName, parameterValue);
            }
        }
        if (entryFilter.containsXpathFilterExpression()) {
            params.put("xpathFilterExpression", entryFilter.getXpathFilterExpression());
            params.put("xpathFilterExpressionNamespace", entryFilter.getXpathFilterExpressionNamespace());
        }
        return params;
    }
}

