/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.hibernate.HibernateDomModelAssembler;
import gov.va.med.cds.persistence.hibernate.ModelAssemblerException;
import gov.va.med.cds.persistence.hibernate.ModelAssemblerInterface;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class LabHibernateDomModelAssembler
extends HibernateDomModelAssembler
implements ModelAssemblerInterface {
    protected List<String> emptyLeafElementList;
    private Map<String, String> emptyElementsToBeRemovedMap;

    public void setEmptyLeafElementList(List<String> emptyLeafElementList) {
        this.emptyLeafElementList = emptyLeafElementList;
    }

    public void setEmptyElementsToBeRemovedMap(Map<String, String> emptyElementsToBeRemovedMap) {
        this.emptyElementsToBeRemovedMap = emptyElementsToBeRemovedMap;
    }

    @Override
    public Document assembleModel(EntryFilterInterface entryFilter, List<QueryWorkInterface> queryWork) {
        Document clinicalDataDocument = this.clinicalDataResponse.buildEmptyClinicalDocumentWithPatient(entryFilter.getTemplateId(), entryFilter.getRequestId());
        Element clinicalRootElement = this.clinicalDataResponse.getClinicalRoot(clinicalDataDocument);
        block0: for (QueryWorkInterface work : queryWork) {
            QueryAssociationInterface queryAssociation = work.getQueryAssociation();
            String parentKey = queryAssociation.getParentKey();
            Element results = (Element)work.getResults();
            if (results == null || !results.hasContent()) continue;
            for (Element childElement : results.elements()) {
                String parentKeyValue = parentKey == null ? null : childElement.elementText(parentKey);
                String xpath = null;
                xpath = parentKeyValue != null ? String.format("%s/%s[%s='%s']", clinicalRootElement.getUniquePath(), queryAssociation.getAssociationParent(), queryAssociation.getKey(), parentKeyValue) : clinicalRootElement.getUniquePath();
                List nodeList = clinicalRootElement.selectNodes(xpath);
                if (nodeList != null && nodeList.size() == 0) continue block0;
                if (nodeList != null && nodeList.size() > 1) {
                    for (Node node : nodeList) {
                        if (node != null && node instanceof Element) {
                            Element parent = (Element)node;
                            if (queryAssociation.isCollapsable()) {
                                Element collapseToElement = parent.element(childElement.getName());
                                if (collapseToElement != null) {
                                    for (Node n : childElement.elements()) {
                                        collapseToElement.add((Element)n.clone());
                                    }
                                    childElement = collapseToElement;
                                    continue;
                                }
                                parent.add((Element)childElement.clone());
                                continue;
                            }
                            parent.add((Element)childElement.clone());
                            continue;
                        }
                        throw new ModelAssemblerException(ErrorCodeEnum.MODEL_ASSEMBLER_EXCEPTION_NOT_ALL_RESULTS_ASSEMBLED, entryFilter.getDomainEntryPoint(), work.getQueryAssociation().getAssociationParent());
                    }
                    continue;
                }
                Node node = null;
                if (null != nodeList) {
                    node = (Node)nodeList.get(0);
                }
                if (node != null && node instanceof Element) {
                    Element parent = (Element)node;
                    if (queryAssociation.isCollapsable()) {
                        Element collapseToElement = parent.element(childElement.getName());
                        if (collapseToElement != null) {
                            for (Node n : childElement.elements()) {
                                collapseToElement.add(n.detach());
                            }
                            childElement = collapseToElement;
                            continue;
                        }
                        parent.add(childElement.detach());
                        continue;
                    }
                    parent.add((Element)childElement.detach());
                    continue;
                }
                throw new ModelAssemblerException(ErrorCodeEnum.MODEL_ASSEMBLER_EXCEPTION_NOT_ALL_RESULTS_ASSEMBLED, entryFilter.getDomainEntryPoint(), work.getQueryAssociation().getAssociationParent());
            }
        }
        this.removeElements(clinicalRootElement);
        if (this.emptyElementList != null) {
            this.removeEmptyElements(clinicalRootElement);
        }
        if (this.emptyLeafElementList != null) {
            this.removeEmptyLeafElements(clinicalRootElement);
        }
        if (this.emptyElementsToBeRemovedMap != null) {
            this.removeParentElement(clinicalRootElement);
        }
        return clinicalDataDocument;
    }

    private void removeEmptyLeafElements(Element parent) {
        for (String xpath : this.emptyLeafElementList) {
            List elements = parent.selectNodes(xpath);
            if (elements == null || elements.size() <= 0) continue;
            for (Element element : elements) {
                if (element.getText() != null && !element.getText().equals("") || element.elements().size() != 0) continue;
                element.detach();
            }
        }
    }

    private void removeParentElement(Element root) {
        for (String key : this.emptyElementsToBeRemovedMap.keySet()) {
            int levelOfDepth = Integer.valueOf(this.emptyElementsToBeRemovedMap.get(key));
            List elements = root.selectNodes(key);
            if (elements == null || elements.size() <= 0) continue;
            for (Element element : elements) {
                if (element.getText() != null && !element.getText().equals("") || element.elements().size() != 0) continue;
                for (int i = 0; i < levelOfDepth; ++i) {
                    element.getParent().detach();
                }
            }
        }
    }
}

