/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.hibernate.ModelAssemblerException;
import gov.va.med.cds.persistence.hibernate.ModelAssemblerInterface;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class HibernateDomModelAssembler
implements ModelAssemblerInterface {
    protected ClinicalDataResponseInterface clinicalDataResponse;
    protected List<String> removes;
    protected List<String> emptyElementList;

    @Override
    public Document assembleModel(EntryFilterInterface entryFilter, List<QueryWorkInterface> queryWork) {
        Document clinicalDataDocument = this.clinicalDataResponse.buildEmptyClinicalDocumentWithPatient(entryFilter.getTemplateId(), entryFilter.getRequestId());
        Element clinicalRootElement = this.clinicalDataResponse.getClinicalRoot(clinicalDataDocument);
        for (QueryWorkInterface work : queryWork) {
            QueryAssociationInterface queryAssociation = work.getQueryAssociation();
            String parentKey = queryAssociation.getParentKey();
            Element results = (Element)work.getResults();
            if (results == null || !results.hasContent()) continue;
            for (Element childElement : results.elements()) {
                String parentKeyValue = parentKey == null ? null : childElement.elementText(parentKey);
                String xpath = null;
                xpath = parentKeyValue != null ? String.format("%s/%s[%s='%s']", clinicalRootElement.getUniquePath(), queryAssociation.getAssociationParent(), queryAssociation.getKey(), parentKeyValue) : clinicalRootElement.getUniquePath();
                List nodeList = clinicalRootElement.selectNodes(xpath);
                Node node = null;
                if (null != nodeList) {
                    node = (Node)nodeList.get(0);
                }
                if (node != null && node instanceof Element) {
                    Element parent = (Element)node;
                    if (queryAssociation.isCollapsable()) {
                        Element collapseToElement = parent.element(childElement.getName());
                        if (collapseToElement != null) {
                            for (Node n : childElement.elements()) {
                                collapseToElement.add(n.detach());
                            }
                            childElement = collapseToElement;
                            continue;
                        }
                        parent.add(childElement.detach());
                        continue;
                    }
                    parent.add((Element)childElement.detach());
                    continue;
                }
                throw new ModelAssemblerException(ErrorCodeEnum.MODEL_ASSEMBLER_EXCEPTION_NOT_ALL_RESULTS_ASSEMBLED, entryFilter.getDomainEntryPoint(), work.getQueryAssociation().getAssociationParent());
            }
        }
        this.removeElements(clinicalRootElement);
        if (this.emptyElementList != null) {
            this.removeEmptyElements(clinicalRootElement);
        }
        return clinicalDataDocument;
    }

    protected void removeElements(Element parent) {
        for (String xpath : this.removes) {
            List elements = parent.selectNodes(xpath);
            if (elements == null || elements.size() <= 0) continue;
            for (Element element : elements) {
                element.detach();
            }
        }
    }

    protected void removeEmptyElements(Element parent) {
        for (String xpath : this.emptyElementList) {
            List elements = parent.selectNodes(xpath);
            if (elements == null || elements.size() <= 0) continue;
            for (Element element : elements) {
                if (element.getText() != null && !element.getText().equals("")) continue;
                element.getParent().getParent().detach();
            }
        }
    }

    public void setClinicalDataResponse(ClinicalDataResponseInterface clinicalDataResponse) {
        this.clinicalDataResponse = clinicalDataResponse;
    }

    public void setRemoves(List<String> removes) {
        this.removes = removes;
    }

    public void setEmptyElementList(List<String> emptyElementList) {
        this.emptyElementList = emptyElementList;
    }
}

