/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.hibernate.FilterParameterExtractorInterface;
import gov.va.med.cds.persistence.hibernate.QueryNameBuilderInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterBinderInterface;
import gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import gov.va.med.cds.util.PerformanceLog;
import gov.va.med.cds.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class DefaultQueryWork
implements QueryWorkInterface {
    protected static final Log LOGGER = LogFactory.getLog(DefaultQueryWork.class);
    protected Session session;
    protected Element results = DocumentHelper.createElement((String)"results");
    protected EntryFilterInterface entryFilter;
    protected List<String> personIdentifiers;
    protected QueryAssociationInterface queryAssociation;
    private List<Exception> exceptions = new ArrayList<Exception>();
    protected Class<?> pointInTimeUserType;
    protected String applicationName;
    protected String siteId;
    private Map<String, String> templateTimeoutMap = null;
    private QueryNameBuilderInterface queryNameBuilder = null;
    private FilterParameterExtractorInterface filterParameterExtractor = null;
    private Map<String, QueryParameterTransformerInterface> parameterTransformerMap = null;
    protected QueryParameterBinderInterface queryParameterBinder = null;
    protected static PerformanceLog performanceLog = PerformanceLog.getInstance();
    protected JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller;

    public DefaultQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, QueryNameBuilderInterface queryNameBuilder, FilterParameterExtractorInterface filterParameterExtractor, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, QueryParameterBinderInterface queryParameterBinder, List<String> personIdentifiers, Class<?> pointInTimeUserType, String applicationName, String siteId) {
        this(session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, queryParameterBinder, null, personIdentifiers, pointInTimeUserType, applicationName, siteId, null);
    }

    public DefaultQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, QueryNameBuilderInterface queryNameBuilder, FilterParameterExtractorInterface filterParameterExtractor, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, QueryParameterBinderInterface queryParameterBinder, List<String> personIdentifiers, Class<?> pointInTimeUserType, String applicationName, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        this(session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor, parameterTransformerMap, queryParameterBinder, null, personIdentifiers, pointInTimeUserType, applicationName, siteId, marshallerUnmarshaller);
    }

    public DefaultQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, QueryNameBuilderInterface queryNameBuilder, FilterParameterExtractorInterface filterParameterExtractor, Map<String, QueryParameterTransformerInterface> parameterTransformerMap, QueryParameterBinderInterface queryParameterBinder, Map<String, String> templateTimeoutMap, List<String> personIdentifiers, Class<?> pointInTimeUserType, String applicationName, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        this.session = session;
        this.entryFilter = entryFilter;
        this.queryAssociation = queryAssociation;
        this.personIdentifiers = personIdentifiers;
        this.pointInTimeUserType = pointInTimeUserType;
        this.queryNameBuilder = queryNameBuilder;
        this.filterParameterExtractor = filterParameterExtractor;
        this.parameterTransformerMap = parameterTransformerMap;
        this.queryParameterBinder = queryParameterBinder;
        this.templateTimeoutMap = templateTimeoutMap;
        this.applicationName = applicationName;
        this.siteId = siteId;
        this.marshallerUnmarshaller = marshallerUnmarshaller;
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            Query query = this.prepareQuery(this.session, this.queryAssociation.getAssociationName(), this.entryFilter, this.personIdentifiers);
            if (query != null) {
                if (this.getTemplateTimeoutMap() != null) {
                    long queryTimeout = TimeoutUtil.processTimeout(this.getTemplateTimeoutMap(), this.entryFilter, this.applicationName);
                    query.setTimeout((int)queryTimeout);
                }
                startTime = System.currentTimeMillis();
                for (Object element : query.list()) {
                    Element marshalledElement = this.marshalObjectToElement(element);
                    this.results.add(marshalledElement);
                }
                long finishTime = System.currentTimeMillis();
                if (performanceLog.isInfoEnabled()) {
                    performanceLog.logFinishTime(startTime, finishTime, "DefaultQueryWork.run()", this.entryFilter.getDomainEntryPoint(), this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), this.siteId, true, "jdbc");
                }
            }
        }
        catch (Exception ex) {
            long finishTime = System.currentTimeMillis();
            if (performanceLog.isInfoEnabled()) {
                performanceLog.logFinishTime(startTime, finishTime, "DefaultQueryWork.run()", this.entryFilter.getDomainEntryPoint(), this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), this.siteId, false, "jdbc");
            }
            this.addException(ex, this.applicationName);
        }
    }

    protected Query prepareQuery(Session aSession, String associationName, EntryFilterInterface aEntryFilter, List<String> personIdentifiers) {
        Map<String, Object> queryParameterMap = this.getFilterParameters(aEntryFilter);
        if (aEntryFilter.isPatientCentricFilter()) {
            if (personIdentifiers == null || personIdentifiers.size() == 0) {
                return null;
            }
            this.addPatientIdentifiers(aEntryFilter, personIdentifiers, queryParameterMap);
        }
        String queryName = this.queryNameBuilder.buildQueryName(aEntryFilter, associationName);
        Query query = null;
        try {
            query = this.session.getNamedQuery(queryName);
        }
        catch (HibernateException he) {
            query = this.session.getNamedQuery(aEntryFilter.getTemplateId() + ".default");
        }
        this.queryParameterBinder.bindQueryParameters(query, queryParameterMap, this.pointInTimeUserType);
        return query;
    }

    protected Element marshalObjectToElement(Object data) throws Exception {
        Class<?> clazz = data.getClass();
        return this.marshallerUnmarshaller.marshalToXmlElement(data, clazz);
    }

    public boolean isDaemon() {
        return false;
    }

    public void release() {
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
        }
        catch (HibernateException e) {
            this.addException((Exception)((Object)e), this.applicationName);
        }
    }

    public Element getResults() {
        return this.results;
    }

    @Override
    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void addException(Exception ex, String applicationName) {
        ExceptionHandler.logRootException(ex, this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), applicationName);
        this.exceptions.add(ex);
    }

    public void setTemplateTimeoutMap(Map<String, String> templateTimeoutMap) {
        this.templateTimeoutMap = templateTimeoutMap;
    }

    public Map<String, String> getTemplateTimeoutMap() {
        return this.templateTimeoutMap;
    }

    public void setQueryNameBuilder(QueryNameBuilderInterface queryNameBuilder) {
        this.queryNameBuilder = queryNameBuilder;
    }

    @Override
    public QueryAssociationInterface getQueryAssociation() {
        return this.queryAssociation;
    }

    protected final void addPatientIdentifiers(EntryFilterInterface entryFilter, List<String> personIdentifiersArg, Map<String, Object> queryParameterMap) {
        QueryParameterTransformerInterface personIdentifierParameterTransformer = this.parameterTransformerMap.get("pids");
        if (personIdentifierParameterTransformer != null) {
            personIdentifierParameterTransformer.transformAndSetParameter("pids", this.personIdentifiers, queryParameterMap);
        } else {
            queryParameterMap.put("pids", this.personIdentifiers);
        }
    }

    protected final Map<String, Object> getFilterParameters(EntryFilterInterface aEntryFilter) {
        return this.filterParameterExtractor.extractNamedParameters(this.parameterTransformerMap, aEntryFilter);
    }

    public JaxBMarshallerUnmarshallerInterface getMarshallerUnmarshaller() {
        return this.marshallerUnmarshaller;
    }

    public void setMarshallerUnmarshaller(JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        this.marshallerUnmarshaller = marshallerUnmarshaller;
    }
}

