/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.QueryStrategyInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.hibernate.AbstractReadHibernatePersistenceManager;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import java.util.ArrayList;
import java.util.List;

public class DefaultHibernateReadPersistenceManager
extends AbstractReadHibernatePersistenceManager {
    @Override
    public boolean isApplicable(EntryFilterInterface aEntryFilter, List<PersonIdentifierInterface> personIdentifiers) throws PersistenceException {
        return super.isApplicable(aEntryFilter, personIdentifiers) && (!aEntryFilter.isPatientCentricFilter() || personIdentifiers.size() > 0);
    }

    @Override
    protected List<QueryWorkInterface> createQueryWork(QueryStrategyInterface queryStrategy, EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers, Class<?> pointInTimeUserType, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        return queryStrategy.createQueryWork(this.getSessionFactory(entryFilter.getTemplateId()), entryFilter, this.concatenatePersonIdentifiers(personIdentifiers), pointInTimeUserType, siteId, marshallerUnmarshaller);
    }

    private List<String> concatenatePersonIdentifiers(List<PersonIdentifierInterface> personIdentifiers) {
        ArrayList<String> concatenatedPersonIdentifiers = new ArrayList<String>();
        if (personIdentifiers != null) {
            for (PersonIdentifierInterface pid : personIdentifiers) {
                concatenatedPersonIdentifiers.add(String.format("%s/%s", pid.getAssigningFacility(), pid.getIdentity()));
            }
        }
        return concatenatedPersonIdentifiers;
    }

    @Override
    public String getSiteIdentifier() {
        return super.getSiteIdentifier();
    }
}

