/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.persistence.hibernate.HibernateEntityLocatorInterface;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ConfigurableNamedQueryEntityLocator
implements HibernateEntityLocatorInterface<Element> {
    private String queryName = null;
    private Map<String, String> queryParameterMap = null;

    @Override
    public Element find(Session session, Element unmanaged) {
        Query query = session.getNamedQuery(this.queryName);
        for (String paramName : this.queryParameterMap.keySet()) {
            String paramValue = this.getParameterValueFromElement(unmanaged, this.queryParameterMap.get(paramName));
            query.setParameter(paramName, (Object)paramValue, (Type)StandardBasicTypes.STRING);
        }
        return (Element)query.uniqueResult();
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setQueryParameterMap(Map<String, String> queryParameterMap) {
        this.queryParameterMap = queryParameterMap;
    }

    private String getParameterValueFromElement(Element element, String path) {
        String[] pathElements = path.split("\\.", 2);
        if (pathElements.length == 2) {
            return this.getParameterValueFromElement(element.element(pathElements[0]), pathElements[1]);
        }
        return element.elementTextTrim(pathElements[0]);
    }
}

