/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import commonj.work.WorkItem;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponse400;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.QueryStrategyInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.persistence.ReadPersistenceManagerInterface;
import gov.va.med.cds.persistence.hibernate.AbstractHibernatePersistenceManager;
import gov.va.med.cds.persistence.hibernate.ModelAssemblerInterface;
import gov.va.med.cds.rules.BooleanRuleInterface;
import gov.va.med.cds.template.TemplateHelperInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import gov.va.med.cds.transaction.WorkManagerInterface;
import gov.va.med.cds.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;

public abstract class AbstractReadHibernatePersistenceManager
extends AbstractHibernatePersistenceManager
implements ReadPersistenceManagerInterface {
    protected static final Log LOGGER = LogFactory.getLog(AbstractReadHibernatePersistenceManager.class);
    private static final String HDR = "HDRII-R";
    TemplateHelperInterface templateHelper;
    private List<BooleanRuleInterface> rules;
    protected Map<String, QueryStrategyInterface> templateQueryStrategyMap;
    protected WorkManagerInterface queryThreadWorkManager;
    protected Map<String, String> templateTimeoutMap = null;
    protected Class<?> pointInTimeUserType;
    protected String siteIdentifier = null;
    protected List<String> vistaExcludedTemplateIdsList;
    protected List<String> hdrExcludedTemplateIdsList;
    protected ClinicalDataResponse400 defaultCDSResponse;

    @Override
    public boolean isApplicable(EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers) throws PersistenceException {
        BooleanRuleInterface r;
        boolean isApplicable = false;
        DomainEntryPoint domainEntryPoint = DomainEntryPoint.valueOf((String)entryFilter.getDomainEntryPoint());
        Iterator<BooleanRuleInterface> iterator = this.rules.iterator();
        while (iterator.hasNext() && !(isApplicable = (r = iterator.next()).evaluate(domainEntryPoint))) {
        }
        return isApplicable;
    }

    protected QueryStrategyInterface getQueryStrategyFromMap(EntryFilterInterface entryFilter) {
        QueryStrategyInterface qs = this.templateQueryStrategyMap.get(String.format("%s-%s-%s", entryFilter.getTemplateId(), entryFilter.getQueryName(), entryFilter.getDomainEntryPoint()));
        if (qs == null) {
            qs = this.templateQueryStrategyMap.get(String.format("%s-%s", entryFilter.getTemplateId(), entryFilter.getDomainEntryPoint()));
        }
        return qs;
    }

    @Override
    public Document performReadOnClinicalData(EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers, String applicationName) throws PersistenceException {
        Document result = null;
        String personIdentity = null;
        if (personIdentifiers != null && this.siteIdentifier != null) {
            for (PersonIdentifierInterface personIdentifier : personIdentifiers) {
                if (!personIdentifier.getAssigningFacility().equals(this.siteIdentifier)) continue;
                personIdentity = personIdentifier.getIdentity();
                break;
            }
        }
        try {
            QueryStrategyInterface queryStrategy = this.getQueryStrategyFromMap(entryFilter);
            if (queryStrategy != null) {
                List<QueryWorkInterface> queryWork = this.createQueryWork(queryStrategy, entryFilter, personIdentifiers, this.pointInTimeUserType, this.siteIdentifier, this.marshallerUnmarshaller);
                this.executeQueryWork(queryWork, entryFilter, personIdentity, applicationName);
                ModelAssemblerInterface modelAssembler = queryStrategy.getModelAssembler();
                result = modelAssembler.assembleModel(entryFilter, queryWork);
            } else {
                result = this.managerIdentifier.contains(HDR) ? this.chkExcludedTemplateIdsList(this.hdrExcludedTemplateIdsList, entryFilter, result) : this.chkExcludedTemplateIdsList(this.vistaExcludedTemplateIdsList, entryFilter, result);
            }
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e.getCause() != null) {
                msg = String.format("%s%s%s", e.getMessage(), ": ", e.getCause().getMessage());
            }
            throw new PersistenceException(ErrorCodeEnum.READ_REQUEST_DATA_SOURCE_FAILURE, this.siteIdentifier, personIdentity, entryFilter.getDomainEntryPoint(), this.managerIdentifier, msg);
        }
        return result;
    }

    protected Document chkExcludedTemplateIdsList(List<String> excludedTemplateIdsList, EntryFilterInterface entryFilter, Document result) {
        if (!excludedTemplateIdsList.contains(String.format("%s-%s", entryFilter.getTemplateId(), entryFilter.getDomainEntryPoint()))) {
            throw new PersistenceException(ErrorCodeEnum.READ_QUERY_STRATEGY_NULL_FAILURE, entryFilter.getTemplateId(), entryFilter.getDomainEntryPoint());
        }
        result = this.defaultCDSResponse.buildEmptyClinicalDocument(entryFilter.getTemplateId(), entryFilter.getRequestId());
        return result;
    }

    protected abstract List<QueryWorkInterface> createQueryWork(QueryStrategyInterface var1, EntryFilterInterface var2, List<PersonIdentifierInterface> var3, Class<?> var4, String var5, JaxBMarshallerUnmarshallerInterface var6) throws PersistenceException;

    protected void executeQueryWork(List<QueryWorkInterface> queryWork, EntryFilterInterface entryFilter, String personIdentity, String applicationName) throws Exception {
        ArrayList<WorkItem> work = new ArrayList<WorkItem>();
        if (queryWork != null && queryWork.size() > 0) {
            for (QueryWorkInterface w : queryWork) {
                try {
                    work.add(this.queryThreadWorkManager.schedule(w));
                }
                catch (Exception e) {
                    w.addException(e, applicationName);
                }
            }
            try {
                long timeout = TimeoutUtil.processTimeout(this.templateTimeoutMap, entryFilter, applicationName) * 1000L;
                boolean timedOut = this.queryThreadWorkManager.waitForAll(work, timeout);
                if (!timedOut) {
                    throw new PersistenceException(ErrorCodeEnum.READ_REQUEST_DATA_SOURCE_TIMEOUT, this.siteIdentifier, personIdentity, entryFilter.getDomainEntryPoint(), this.managerIdentifier, ": The query timed out with timeout value of: " + timeout + " milliseconds");
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Timeout Exception while querying for: " + entryFilter.getDomainEntryPoint()));
                throw e;
            }
            finally {
                for (QueryWorkInterface qw : queryWork) {
                    qw.release();
                }
            }
            for (QueryWorkInterface w : queryWork) {
                if (w.getExceptions().size() <= 0) continue;
                Exception ex = w.getExceptions().get(0);
                String rootCauseMessage = ExceptionUtils.getRootCause((Throwable)ex) == null ? ex.getMessage() : ExceptionUtils.getRootCause((Throwable)ex).getMessage();
                throw new PersistenceException(ErrorCodeEnum.READ_REQUEST_DATA_SOURCE_FAILURE, ex, this.siteIdentifier, personIdentity, entryFilter.getDomainEntryPoint(), this.managerIdentifier, String.format("%s%s%s", ErrorCodeEnum.READ_REQUEST_DATA_SOURCE_FAILURE.name(), ": ", rootCauseMessage));
            }
        }
    }

    public void setRules(List<BooleanRuleInterface> rules) {
        this.rules = rules;
    }

    public void setTemplateQueryStrategyMap(Map<String, QueryStrategyInterface> templateQueryStrategyMap) {
        this.templateQueryStrategyMap = templateQueryStrategyMap;
    }

    public void setQueryThreadWorkManager(WorkManagerInterface queryThreadWorkManager) {
        this.queryThreadWorkManager = queryThreadWorkManager;
    }

    public void setPointInTimeUserType(Class<?> pointInTimeUserType) throws ClassNotFoundException {
        this.pointInTimeUserType = pointInTimeUserType;
    }

    public void setSiteIdentifier(String siteIdentifier) {
        this.siteIdentifier = siteIdentifier;
    }

    @Override
    public String getSiteIdentifier() {
        return this.siteIdentifier;
    }

    public void setTemplateTimeoutMap(Map<String, String> templateTimeoutMap) {
        this.templateTimeoutMap = templateTimeoutMap;
    }

    public void setVistaExcludedTemplateIdsList(List<String> vistaExcludedTemplateIdsList) {
        this.vistaExcludedTemplateIdsList = vistaExcludedTemplateIdsList;
    }

    public void setHdrExcludedTemplateIdsList(List<String> hdrExcludedTemplateIdsList) {
        this.hdrExcludedTemplateIdsList = hdrExcludedTemplateIdsList;
    }

    public void setDefaultCDSResponse(ClinicalDataResponse400 defaultCDSResponse) {
        this.defaultCDSResponse = defaultCDSResponse;
    }
}

