/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.PersistenceLocatorInterface;
import gov.va.med.cds.persistence.PersistenceManagerInterface;
import gov.va.med.cds.persistence.ReadPersistenceManagerInterface;
import gov.va.med.cds.persistence.WritePersistenceManagerInterface;
import java.util.ArrayList;
import java.util.List;

public class PersistenceLocator
implements PersistenceLocatorInterface {
    private List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();

    @Override
    public WritePersistenceManagerInterface getWritePersistenceManager(DomainEntryPoint domainEntryPoint) throws PersistenceException {
        for (PersistenceManagerInterface pm : this.persistenceManagers) {
            WritePersistenceManagerInterface wpm;
            if (!(pm instanceof WritePersistenceManagerInterface) || !(wpm = (WritePersistenceManagerInterface)pm).isApplicable(domainEntryPoint)) continue;
            return wpm;
        }
        throw new PersistenceException(ErrorCodeEnum.UNABLE_TO_RESOLVE_WRITEABLE_PERSISTENCE_MANAGER_FAILURE);
    }

    @Override
    public List<ReadPersistenceManagerInterface> getReadPersistenceManagers(EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers) {
        ArrayList<ReadPersistenceManagerInterface> readablePersistenceManagers = new ArrayList<ReadPersistenceManagerInterface>();
        for (PersistenceManagerInterface pm : this.persistenceManagers) {
            ReadPersistenceManagerInterface rpm;
            if (!(pm instanceof ReadPersistenceManagerInterface) || !(rpm = (ReadPersistenceManagerInterface)pm).isApplicable(entryFilter, personIdentifiers)) continue;
            readablePersistenceManagers.add((ReadPersistenceManagerInterface)pm);
        }
        return readablePersistenceManagers;
    }

    public void setStaticPersistenceManagers(List<PersistenceManagerInterface> persistenceManagers) {
        this.persistenceManagers.addAll(persistenceManagers);
    }

    public void setDynamicPersistenceManagers(List<PersistenceManagerInterface> persistenceManagers) {
        this.persistenceManagers.addAll(persistenceManagers);
    }
}

