/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence;

import gov.va.med.cds.persistence.JNDIDataSourceBindingsLocatorInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class JNDIDataSourceBindingsLocator
implements JNDIDataSourceBindingsLocatorInterface {
    private Log logger = LogFactory.getLog(JNDIDataSourceBindingsLocator.class);
    private Context initialContext;
    private String namedContext = "";

    @Override
    public Collection<Binding> getDataSourceBindings() {
        ArrayList<Binding> result;
        block9: {
            result = new ArrayList<Binding>();
            try (NamingEnumeration<Binding> enumeration = this.initialContext.listBindings(this.namedContext);){
                while (enumeration.hasMore()) {
                    Binding binding = enumeration.next();
                    Object obj = binding.getObject();
                    if (!(obj instanceof DataSource)) continue;
                    result.add(binding);
                }
            }
            catch (NamingException nnfe) {
                if (!this.logger.isDebugEnabled()) break block9;
                this.logger.debug((Object)LogMessageUtil.buildMessage(null, null, null, (String)String.format("%s: No data source bindings matching '%s'.", this.getClass().getName(), this.namedContext)));
            }
        }
        if (this.logger.isInfoEnabled()) {
            String msg = "Located " + result.size() + " site specific data source bindings in context " + this.namedContext;
            this.logger.info((Object)LogMessageUtil.buildMessage(null, null, null, (String)msg), null);
        }
        return result;
    }

    public void setNamedContext(String namedContext) {
        this.namedContext = namedContext;
    }

    @Required
    public void setInitialContext(Context initialContext) {
        this.initialContext = initialContext;
    }
}

