/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.DefaultAssociationBasedQueryStrategy;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;

public class HibernateFilterAwareQueryStrategy
extends DefaultAssociationBasedQueryStrategy {
    public Map<String, List<String>> domainFilterMappedToHibernateFilter;

    public void setDomainFilterMappedToHibernateFilter(Map<String, List<String>> domainFilterMappedToHibernateFilter) {
        this.domainFilterMappedToHibernateFilter = domainFilterMappedToHibernateFilter;
    }

    @Override
    protected QueryWorkInterface createQueryWork(Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter, List<String> personIdentifiers, Class<?> pointInTimeUserType, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {
        QueryWorkInterface timestampQueryWork = super.createQueryWork(session, queryAssociation, entryFilter, personIdentifiers, pointInTimeUserType, siteId, null);
        for (String domainName : this.domainFilterMappedToHibernateFilter.keySet()) {
            if (!domainName.equals(entryFilter.getTemplateId())) continue;
            for (String hibernateFilterName : this.domainFilterMappedToHibernateFilter.get(domainName)) {
                String tempHibernateFilterParam;
                String tempFilterParamName = hibernateFilterName + "Param";
                if (entryFilter.getAdditionalParametersMap() == null || (tempHibernateFilterParam = (String)entryFilter.getAdditionalParametersMap().getParameterValue(tempFilterParamName.replace("FilterParam", "")).getValue()) == null) continue;
                session.enableFilter(hibernateFilterName).setParameter(tempFilterParamName, (Object)tempHibernateFilterParam);
            }
        }
        return timestampQueryWork;
    }
}

