/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.internal;

import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.CdsFilterFactoryInterface;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.FilterPatientResolverInterface;
import gov.va.med.cds.internal.ClinicalDataServiceSynchronousInternalInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import gov.va.med.cds.template.TemplateHelperInterface;
import gov.va.med.cds.template.TemplateManager;
import gov.va.med.cds.template.TemplateWriteRequest;
import gov.va.med.cds.tfs.util.TemplateMetaDataHelper;
import gov.va.med.cds.transaction.TransactionManagerInterface;
import gov.va.med.cds.util.NestedElementWrapperUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ClinicalDataServiceSynchronousInternal
implements ClinicalDataServiceSynchronousInternalInterface {
    private Log logger = LogFactory.getLog(ClinicalDataServiceSynchronousInternal.class);
    private static final String START_TAG = "<";
    private static final String END_TAG = "</";
    private TransactionManagerInterface transactionManager;
    private CdsFilterFactoryInterface filterFactory;
    private FilterPatientResolverInterface filterPatientResolver;
    private TemplateManager templateManager;
    private TemplateHelperInterface templateHelper;
    private boolean addPatientIdentifiers = true;
    private String cdsAppName;
    private String pathwaysAppName;
    private Map<String, String> namespacesMap;
    private NestedElementWrapperUtil nestedElementWrapperUtil;
    private Map<String, List<String>> emptyElementListMap;

    @Override
    public List<Document> readClinicalData(String filterRequest, String filterId, String templateId, String requestId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing read request - filterid: " + filterId + ", templateId: " + templateId + ", requestId: " + requestId));
        }
        if (filterRequest == null || filterRequest.length() == 0) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_FILTER_XML_NULL);
        }
        Document filterRequestDocument = this.getDocument(filterRequest);
        if (this.isPatientCentricRequest(filterRequestDocument)) {
            filterRequestDocument = this.filterPatientResolver.resolveIdentifiersInFilter(filterId, filterRequestDocument);
        }
        CdsFilterInterface cdsFilter = this.filterFactory.create(filterId, filterRequestDocument, templateId, requestId);
        this.validateReadRequest(templateId, requestId, cdsFilter);
        List<Document> results = this.transactionManager.performReadOnClinicalData(templateId, requestId, cdsFilter);
        if (this.addPatientIdentifiers && !cdsFilter.getEntryPointFilters().get(0).isSiteCentricFilter()) {
            Document patientIdentifierDocument = this.templateHelper.getPatientIdentifierDocumentBuilder(templateId).createPatientWithIdentifiersDocument(cdsFilter, templateId, requestId);
            results.add(0, patientIdentifierDocument);
        }
        return results;
    }

    private void validateReadRequest(String templateId, String requestId, CdsFilterInterface cdsFilter) {
        TemplateMetaDataInterface templateMetaData = this.templateManager.validateReadTemplateId(templateId);
        String vhimVersion = cdsFilter != null ? cdsFilter.getVhimVersion() : null;
        Collection<String> templateEntryPoints = TemplateMetaDataHelper.getEntryPoints(templateMetaData.getDomainEntryPoints());
        Set<String> domainEntryPoints = cdsFilter.getDomainEntryPoints();
        for (String domainEntryPoint : domainEntryPoints) {
            if (templateEntryPoints.contains(domainEntryPoint.trim())) continue;
            throw new ValidationException(ErrorCodeEnum.REQUEST_TYPE_MISMATCH_TEMPLATE_ENTRYPOINT_FILTER_ENTRYPOINT, templateEntryPoints.toString(), domainEntryPoints.toString());
        }
    }

    @Override
    public Document createClinicalData(String createRequest, String templateId, String requestId) {
        return this.doCUAD(Operation.Create, createRequest, templateId, requestId);
    }

    @Override
    public Document updateClinicalData(String updateRequest, String templateId, String requestId) {
        return this.doCUAD(Operation.Update, updateRequest, templateId, requestId);
    }

    @Override
    public Document deleteClinicalData(String deleteRequest, String templateId, String requestId) {
        return this.doCUAD(Operation.Delete, deleteRequest, templateId, requestId);
    }

    @Override
    public Document appendClinicalData(String appendRequest, String templateId, String requestId) {
        return this.doCUAD(Operation.Append, appendRequest, templateId, requestId);
    }

    @Override
    public List<Document> writeClinicalData(String createRequest, String templateId, String requestId) {
        return this.doVistaCreate(Operation.Create, createRequest, templateId, requestId);
    }

    public Document doCUAD(Operation operation, String clinicalData, String templateId, String requestId) {
        Document writeResultDocument = null;
        Document clinicalDataDocument = null;
        WriteResponseGeneratorInterface writeResponseGenerator = this.templateHelper.getWriteResponseGenerator(templateId);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing request " + operation + " for - templateId: " + templateId + ", requestId: " + requestId + ", request: " + clinicalData));
            }
            this.validateCUADRequest(clinicalData, templateId, requestId, operation);
            clinicalData = this.removeUnwantedNameSpaces(clinicalData, templateId);
            clinicalDataDocument = DocumentHelper.parseText((String)clinicalData);
            clinicalDataDocument = this.nestedElementWrapperUtil.addNestedElements(clinicalDataDocument, templateId);
            clinicalDataDocument = this.removeEmptyElements(clinicalDataDocument, templateId);
        }
        catch (Exception e) {
            writeResultDocument = writeResponseGenerator.generateWriteErrorResponse(templateId, requestId, e, clinicalDataDocument, this.cdsAppName);
            return writeResultDocument;
        }
        try {
            List<Element> createdRecordIdentifiers = this.transactionManager.performCUADOnClinicalData(operation, clinicalDataDocument, templateId, requestId);
            writeResultDocument = writeResponseGenerator.generateSuccessfulWriteResponse(templateId, requestId, createdRecordIdentifiers);
        }
        catch (Exception e) {
            writeResultDocument = writeResponseGenerator.generateWriteErrorResponse(templateId, requestId, e, clinicalDataDocument, this.cdsAppName);
        }
        return writeResultDocument;
    }

    private List<Document> doVistaCreate(Operation operation, String clinicalData, String templateId, String requestId) {
        Document writeResultDocument = null;
        Document clinicalDataDocument = null;
        List<Document> results = null;
        WriteResponseGeneratorInterface writeResponseGenerator = this.templateHelper.getWriteResponseGenerator(templateId);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing request " + operation + " for - templateId: " + templateId + ", requestId: " + requestId + ", request: " + clinicalData));
            }
            this.validateCUADRequest(clinicalData, templateId, requestId, operation);
            clinicalData = this.removeUnwantedNameSpaces(clinicalData, templateId);
            clinicalDataDocument = DocumentHelper.parseText((String)clinicalData);
            clinicalDataDocument = this.nestedElementWrapperUtil.addNestedElements(clinicalDataDocument, templateId);
            clinicalDataDocument = this.removeEmptyElements(clinicalDataDocument, templateId);
        }
        catch (Exception e) {
            writeResultDocument = writeResponseGenerator.generateWriteErrorResponse(templateId, requestId, e, clinicalDataDocument, this.pathwaysAppName);
            results = new ArrayList<Document>();
            results.add(writeResultDocument);
            return results;
        }
        try {
            results = this.transactionManager.performCUADVistAData(operation, clinicalDataDocument, templateId, requestId);
        }
        catch (Exception e) {
            writeResultDocument = writeResponseGenerator.generateWriteErrorResponse(templateId, requestId, e, clinicalDataDocument, this.pathwaysAppName);
            if (results == null) {
                results = new ArrayList();
            }
            results.add(writeResultDocument);
        }
        return results;
    }

    private void validateCUADRequest(String clinicalData, String templateId, String requestId, Operation operation) {
        if (operation == null) {
            throw new ValidationException(ErrorCodeEnum.OPERATION_NOT_SUPPORTED, "null");
        }
        TemplateWriteRequest cuadRequest = new TemplateWriteRequest(clinicalData, operation);
        cuadRequest.setRequestId(requestId);
        cuadRequest.setTemplateId(templateId);
        this.templateManager.validateWriteRequest(cuadRequest);
    }

    private Document getDocument(String filterRequest) {
        try {
            return DocumentHelper.parseText((String)filterRequest);
        }
        catch (DocumentException e) {
            throw new ValidationException(ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION, e, filterRequest, e.getMessage());
        }
    }

    private boolean isPatientCentricRequest(Document filterRequestDocument) {
        Element rootElement = filterRequestDocument.getRootElement();
        Element entryPointFilterElement = rootElement.element("entryPointFilter");
        String isPatientCentricStr = entryPointFilterElement.attributeValue("isPatientCentric");
        if (isPatientCentricStr == null) {
            return true;
        }
        return isPatientCentricStr != null && isPatientCentricStr.length() > 0 && Boolean.parseBoolean(isPatientCentricStr) == Boolean.TRUE;
    }

    private String removeUnwantedNameSpaces(String clinicalData, String templateId) {
        String namespaceValue = null;
        if (this.namespacesMap.containsKey(templateId)) {
            namespaceValue = this.namespacesMap.get(templateId);
            clinicalData = clinicalData.replace(START_TAG + namespaceValue, START_TAG);
            clinicalData = clinicalData.replace(END_TAG + namespaceValue, END_TAG);
        }
        return clinicalData;
    }

    private Document removeEmptyElements(Document clinicalDataDocument, String templateId) throws DocumentException {
        List<String> emptyElementList = this.emptyElementListMap.get(templateId);
        if (emptyElementList != null) {
            for (String xpath : emptyElementList) {
                List elements = clinicalDataDocument.selectNodes(xpath);
                if (elements == null || elements.size() <= 0) continue;
                for (Element element : elements) {
                    if (element.getText() != null && !element.getText().equals("")) continue;
                    element.detach();
                }
            }
        }
        return clinicalDataDocument;
    }

    public void setTransactionManager(TransactionManagerInterface transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setFilterFactory(CdsFilterFactoryInterface filterFactory) {
        this.filterFactory = filterFactory;
    }

    public void setFilterPatientResolver(FilterPatientResolverInterface filterPatientResolver) {
        this.filterPatientResolver = filterPatientResolver;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setTemplateHelper(TemplateHelperInterface templateHelper) {
        this.templateHelper = templateHelper;
    }

    public void setAddPatientIdentifiers(boolean addPatientIdentifiers) {
        this.addPatientIdentifiers = addPatientIdentifiers;
    }

    public void setCdsAppName(String cdsAppName) {
        this.cdsAppName = cdsAppName;
    }

    public void setNamespacesMap(Map<String, String> namespacesMap) {
        this.namespacesMap = namespacesMap;
    }

    public void setNestedElementWrapperUtil(NestedElementWrapperUtil nestedElementWrapperUtil) {
        this.nestedElementWrapperUtil = nestedElementWrapperUtil;
    }

    public void setEmptyElementListMap(Map<String, List<String>> emptyElementListMap) {
        this.emptyElementListMap = emptyElementListMap;
    }

    public void setPathwaysAppName(String pathwaysAppName) {
        this.pathwaysAppName = pathwaysAppName;
    }
}

