/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter.vhim400;

import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierCorrelationServiceInterface;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.CdsFilter;
import gov.va.med.cds.filter.FilterPatientResolverException;
import gov.va.med.cds.filter.FilterPatientResolverInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;

public class SinglePatientResolver
implements FilterPatientResolverInterface {
    private static Log logger = LogFactory.getLog(SinglePatientResolver.class);
    private static String NATIONAL_IDENTIFIER_ASSIGNING_FACILITY = "200M";
    private static String NATIONAL_IDENTIFIER_ASSIGNING_AUTHORITY = "USVHA";
    private static String HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER = "HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER";
    private static String PATIENTS_TAG = "patients";
    private static String NATIONAL_ID_TAG = "NationalId";
    private static String RESOLVED_IDENTIFIERS_TAG = "resolvedIdentifiers";
    private static String EXCLUDE_IDENTIFIERS_TAG = "excludeIdentifiers";
    private static String ASSIGNING_AUTHORITY_TAG = "assigningAuthority";
    private static String ASSIGNING_FACILITY_TAG = "assigningFacility";
    private static String IDENTITY_TAG = "identity";
    private PersonIdentifierCorrelationServiceInterface patientIdentifierCorrelationService;

    @Override
    public Document resolveIdentifiersInFilter(String filterId, Document filterRequestDocument) {
        if (filterRequestDocument == null) {
            throw new FilterPatientResolverException(ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION);
        }
        Element rootElement = filterRequestDocument.getRootElement();
        Element patients = rootElement.element(PATIENTS_TAG);
        if (patients == null) {
            throw new FilterPatientResolverException(ErrorCodeEnum.NO_PATIENT_IDS_REQUESTED);
        }
        List identifierList = patients.elements(NATIONAL_ID_TAG);
        int numIds = identifierList.size();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of national ids in filter: " + numIds));
        }
        if (numIds == 1) {
            Collection<PersonIdentifierInterface> correspondingIdentifiers = this.resolveNationaIdentifier((Element)identifierList.get(0));
            this.excludeIdentifiers(patients, correspondingIdentifiers);
            this.addResolvedIdentifiers(patients, correspondingIdentifiers);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Final set of resolved identifiers after exclusions:\n" + correspondingIdentifiers));
            }
        } else if (numIds == 0) {
            identifierList = patients.elements(CdsFilter.EDIPI_ID_TAG);
            if (identifierList == null || identifierList.size() <= 0) {
                identifierList = patients.elements(RESOLVED_IDENTIFIERS_TAG);
                if (identifierList.size() <= 0) {
                    throw new FilterPatientResolverException(ErrorCodeEnum.NO_PATIENT_IDS_REQUESTED);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Filter has resolved identifiers - not national id - returning original filter w/o calling IDM service.");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Filter has EDIPI - not national id - returning original filter w/o calling IDM service.");
            }
        } else {
            throw new FilterPatientResolverException(ErrorCodeEnum.MULTIPLE_NATIONAL_IDS_IN_FILTER, filterRequestDocument.asXML());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resolveIdentifiersInFilter returning modified filter below:\n" + filterRequestDocument.asXML()));
        }
        return filterRequestDocument;
    }

    private Collection<PersonIdentifierInterface> resolveNationaIdentifier(Element nationalIdElement) {
        String nationalId = nationalIdElement.getTextTrim();
        return this.getCorrespondingIdentifiers(nationalId);
    }

    private Collection<PersonIdentifierInterface> getCorrespondingIdentifiers(String nationalId) {
        Collection correspondingIdentifiers = null;
        PersonIdentifier unResolvedPersonIdentifier = new PersonIdentifier();
        unResolvedPersonIdentifier.setIdentity(nationalId);
        unResolvedPersonIdentifier.setAssigningFacility(NATIONAL_IDENTIFIER_ASSIGNING_FACILITY);
        unResolvedPersonIdentifier.setAssigningAuthority(NATIONAL_IDENTIFIER_ASSIGNING_AUTHORITY);
        if (this.patientIdentifierCorrelationService == null) {
            throw new FilterPatientResolverException(ErrorCodeEnum.PATIENT_ID_CORRELATION_SERVICE_NULL);
        }
        correspondingIdentifiers = this.patientIdentifierCorrelationService.obtainPersonIdentifiers((PersonIdentifierInterface)unResolvedPersonIdentifier);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("National id '" + nationalId + "' resolved to following identifiers:\n" + correspondingIdentifiers));
        }
        if (correspondingIdentifiers == null || correspondingIdentifiers.isEmpty()) {
            throw new FilterPatientResolverException(ErrorCodeEnum.NO_PATIENT_IDS_RESOLVED);
        }
        return correspondingIdentifiers;
    }

    private void excludeIdentifiers(Element patients, Collection<PersonIdentifierInterface> correspondingIdentifiers) {
        ArrayList<Object> identifiersToExclude = new ArrayList<Object>();
        List excludeIdentifiers = patients.elements(EXCLUDE_IDENTIFIERS_TAG);
        for (Object excludeIdentifierObject : excludeIdentifiers) {
            Element identityElement;
            Element excludeIdentifierElement = (Element)excludeIdentifierObject;
            String assigningAuthority = excludeIdentifierElement.element(ASSIGNING_AUTHORITY_TAG).getTextTrim();
            Element facilityElement = excludeIdentifierElement.element(ASSIGNING_FACILITY_TAG);
            String assigningFacility = null;
            if (facilityElement != null) {
                assigningFacility = facilityElement.getTextTrim();
            }
            if ((identityElement = excludeIdentifierElement.element(IDENTITY_TAG)) != null) {
                String identity = identityElement.getTextTrim();
                PersonIdentifier excludePersonIdentifier = new PersonIdentifier();
                excludePersonIdentifier.setAssigningAuthority(assigningAuthority);
                excludePersonIdentifier.setAssigningFacility(assigningFacility);
                excludePersonIdentifier.setIdentity(identity);
                identifiersToExclude.add(excludePersonIdentifier);
                continue;
            }
            for (PersonIdentifierInterface pi : correspondingIdentifiers) {
                if (!pi.getAssigningAuthority().equals(assigningAuthority) || assigningFacility != null && !assigningFacility.equals(pi.getAssigningFacility())) continue;
                identifiersToExclude.add(pi);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Following identifiers are being excluded from resolved identifier list:\n" + identifiersToExclude));
        }
        correspondingIdentifiers.removeAll(identifiersToExclude);
        if (correspondingIdentifiers.isEmpty()) {
            throw new FilterPatientResolverException(ErrorCodeEnum.ALL_PATIENT_IDS_EXCLUDED);
        }
    }

    private void addResolvedIdentifiers(Element patients, Collection<PersonIdentifierInterface> resolvedIdentifiers) {
        try {
            for (PersonIdentifierInterface pi : resolvedIdentifiers) {
                Element resolvedId = patients.addElement(RESOLVED_IDENTIFIERS_TAG);
                resolvedId.addElement(ASSIGNING_AUTHORITY_TAG).addText(pi.getAssigningAuthority());
                resolvedId.addElement(ASSIGNING_FACILITY_TAG).addText(pi.getAssigningFacility());
                resolvedId.addElement(IDENTITY_TAG).addText(pi.getIdentity());
            }
        }
        catch (Exception e) {
            throw new FilterPatientResolverException(ErrorCodeEnum.ERROR_ADDING_RESOLVEDIDENTIFIERS_TO_FILTER, e);
        }
    }

    public void setPatientIdentifierCorrelationService(PersonIdentifierCorrelationServiceInterface patientIdentifierCorrelationService) {
        this.patientIdentifierCorrelationService = patientIdentifierCorrelationService;
    }
}

