/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.filter.QueryParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class ParameterMap
implements ParameterMapInterface {
    private Map<String, QueryParameter<?>> queryParameterMap = new LinkedHashMap();

    @Override
    public Set<String> getFilterParameterNames() {
        LinkedHashSet<String> parameterNames = new LinkedHashSet<String>();
        if (this.queryParameterMap != null && this.queryParameterMap.size() > 0) {
            parameterNames.addAll(this.queryParameterMap.keySet());
        }
        return parameterNames;
    }

    @Override
    public QueryParameter<?> getParameterValue(String parameterName) {
        return this.queryParameterMap.get(parameterName);
    }

    protected ParameterMap(Element additionalParametersElement) {
        if (additionalParametersElement != null && "otherQueryParameters".equals(additionalParametersElement.getName())) {
            this.extractAdditionalParameters(additionalParametersElement);
        }
    }

    private void extractAdditionalParameters(Element additionalParametersElement) {
        List additionalParametersList = additionalParametersElement.elements();
        for (Element additionalParameter : additionalParametersList) {
            String paramName = additionalParameter.attributeValue("name") != null ? additionalParameter.attributeValue("name") : additionalParameter.getName();
            String paramType = additionalParameter.attributeValue("type") != null ? additionalParameter.attributeValue("type") : "string";
            QueryParameter<?> queryParameter = this.queryParameterMap.get(paramName);
            if (additionalParameter.elements().size() > 0) {
                queryParameter = this.extractMapTypeParameter(additionalParameter, paramName);
            } else {
                String paramValue = additionalParameter.getTextTrim();
                queryParameter = queryParameter != null ? this.extractListTypeParameter(paramName, paramValue, queryParameter) : this.extractSingleValueParameter(paramName, paramValue);
            }
            queryParameter.setType(paramType);
            this.queryParameterMap.put(paramName, queryParameter);
        }
    }

    private QueryParameter<?> extractMapTypeParameter(Element additionalParameter, String paramName) {
        QueryParameter mapParameter = new QueryParameter();
        mapParameter.setName(paramName);
        HashMap<String, String> complexParam = new HashMap<String, String>();
        for (Element element : additionalParameter.elements()) {
            complexParam.put(paramName + "_" + element.getName(), element.getTextTrim());
        }
        mapParameter.setValue(complexParam);
        QueryParameter queryParameter = mapParameter;
        return queryParameter;
    }

    private QueryParameter<?> extractListTypeParameter(String paramName, String paramValue, QueryParameter<?> queryParameter) {
        if (queryParameter.getValue() instanceof List) {
            ((List)queryParameter.getValue()).add(paramValue);
        } else {
            QueryParameter listParameter = new QueryParameter();
            listParameter.setName(paramName);
            ArrayList<String> values = new ArrayList<String>();
            values.add((String)queryParameter.getValue());
            values.add(paramValue);
            listParameter.setValue(values);
            queryParameter = listParameter;
        }
        return queryParameter;
    }

    private QueryParameter<?> extractSingleValueParameter(String paramName, String paramValue) {
        QueryParameter<String> textParameter = new QueryParameter<String>();
        textParameter.setName(paramName);
        textParameter.setValue(paramValue);
        QueryParameter<String> queryParameter = textParameter;
        return queryParameter;
    }
}

