/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.SingleEntryPointFilterInfo;
import gov.va.med.cds.internal.ClinicalDataServiceSynchronousInternalInterface;
import gov.va.med.cds.request.ValidationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MultipleEntryPointFilterHelper {
    private static final String XPATH_DOMAIN_ENTRY_POINT = "/filter:filter/entryPointFilter//domainEntryPoint";
    private Log logger = LogFactory.getLog(MultipleEntryPointFilterHelper.class);
    private Map<String, List<String>> multipleEntryPointFilterId;
    private Map<String, String> filterDomainEntryPointToTemplateId;
    private Map<String, List<ClinicalDataServiceSynchronousInternalInterface>> filterEntryPointDelegateMap;

    public String getTemplateId(String domainEntryPoint) {
        return this.filterDomainEntryPointToTemplateId.get(domainEntryPoint);
    }

    public List<SingleEntryPointFilterInfo> convertMultipleEntryPointFilterToSingleEntryPointFilter(String afilterRequest, String aFilterId) {
        int loopCounter;
        Document filterDocument = this.getDocument(afilterRequest);
        ArrayList<SingleEntryPointFilterInfo> singleEntryPointFilterInfoList = new ArrayList<SingleEntryPointFilterInfo>();
        List<String> entryPoints = this.multipleEntryPointFilterId.get(aFilterId);
        Element rootElement = filterDocument.getRootElement();
        LinkedList[] array = new LinkedList[entryPoints.size()];
        for (loopCounter = 0; loopCounter < entryPoints.size(); ++loopCounter) {
            array[loopCounter] = new LinkedList();
        }
        block1: for (loopCounter = 0; loopCounter < entryPoints.size(); ++loopCounter) {
            Iterator i = rootElement.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if (!element.getName().equals("entryPointFilter")) continue;
                for (String entryPoint : entryPoints) {
                    if (!element.selectSingleNode(XPATH_DOMAIN_ENTRY_POINT).getText().equals(entryPoint)) continue;
                    array[loopCounter].add(element.detach());
                    continue block1;
                }
            }
        }
        for (loopCounter = 0; loopCounter < entryPoints.size(); ++loopCounter) {
            SingleEntryPointFilterInfo singleEntryPointFilterInfo = new SingleEntryPointFilterInfo();
            if (array[loopCounter].size() == 0) continue;
            filterDocument = this.createSingleEntryPointFilter(array[loopCounter], filterDocument, singleEntryPointFilterInfo);
            singleEntryPointFilterInfo.setSingleEntryPointFilter(this.prettyPrint(filterDocument));
            singleEntryPointFilterInfoList.add(singleEntryPointFilterInfo);
            filterDocument = this.removeNodesFromDocument(array[loopCounter], filterDocument);
        }
        return singleEntryPointFilterInfoList;
    }

    private String prettyPrint(Document aFilterDocument) {
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLWriter xmlWriter = new XMLWriter((OutputStream)byteArrayOutputStream, outputFormat);
            xmlWriter.write(aFilterDocument);
        }
        catch (UnsupportedEncodingException e) {
            throw new ValidationException(ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION);
        }
        catch (IOException e) {
            throw new ValidationException(ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION);
        }
        return byteArrayOutputStream.toString();
    }

    private Document createSingleEntryPointFilter(List<Node> aNodeList, Document aFilterDocument, SingleEntryPointFilterInfo aSingleEntryPointFilterInfo) {
        for (Node node : aNodeList) {
            aFilterDocument.getRootElement().add(node);
        }
        aSingleEntryPointFilterInfo.setDomainEntryPoint(aFilterDocument.selectSingleNode(XPATH_DOMAIN_ENTRY_POINT).getText());
        return aFilterDocument;
    }

    public List<ClinicalDataServiceSynchronousInternalInterface> getClinicalDataSynchronousServiceFromEntryPointFilterMap(String entryPoint) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtaining service delegates for entry point: " + entryPoint));
        }
        if (this.filterEntryPointDelegateMap.get(entryPoint) == null) {
            throw new ValidationException(ErrorCodeEnum.CANT_MATCH_TEMPLATE_TO_DELEGATE, entryPoint);
        }
        return this.filterEntryPointDelegateMap.get(entryPoint);
    }

    private Document removeNodesFromDocument(List<Node> aNodeList, Document aFilterDocument) {
        for (Node node : aNodeList) {
            aFilterDocument.getRootElement().remove(node);
        }
        return aFilterDocument;
    }

    private String getEntryPoint(Document aFilterDocument) {
        return aFilterDocument.selectSingleNode(XPATH_DOMAIN_ENTRY_POINT).getText();
    }

    public String getEntryPoint(String aFilterRequest) {
        return this.getEntryPoint(this.getDocument(aFilterRequest));
    }

    public Document getDocument(String aFilterRequest) throws ValidationException {
        if (aFilterRequest == null || aFilterRequest.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            return DocumentHelper.parseText((String)aFilterRequest);
        }
        catch (DocumentException e) {
            throw new ValidationException(ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION);
        }
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setMultipleEntryPointFilterId(Map<String, List<String>> multipleEntryPointFilterId) {
        this.multipleEntryPointFilterId = multipleEntryPointFilterId;
    }

    public void setFilterDomainEntryPointToTemplateId(Map<String, String> filterDomainEntryPointToTemplateId) {
        this.filterDomainEntryPointToTemplateId = filterDomainEntryPointToTemplateId;
    }

    public void setFilterEntryPointDelegateMap(Map<String, List<ClinicalDataServiceSynchronousInternalInterface>> filterEntryPointDelegateMap) {
        this.filterEntryPointDelegateMap = filterEntryPointDelegateMap;
    }
}

