/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.clinicaldata.EntryFilter;
import gov.va.med.cds.clinicaldata.FilterMetaData;
import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.FilterCacheException;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.FilterCachePersistenceInterface;
import gov.va.med.cds.filter.FilterMemoryCacheInterface;
import gov.va.med.cds.persistence.hibernate.tfs.AbstractTfsHibernatePersistenceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class HibernateOracleFilterCachePersistence
extends AbstractTfsHibernatePersistenceManager
implements FilterCachePersistenceInterface {
    private Query buildFilterStatusQuery(Session aSession) {
        String queryName = "FilterSchemaIdsByStatus";
        Query query = aSession.getNamedQuery(queryName);
        query.setParameter("status", (Object)"ACTIVE");
        return query;
    }

    private Query buildFilterIdQuery(Session aSession, String aFilterId) {
        String queryName = "FilterSchemaId";
        Query query = aSession.getNamedQuery(queryName);
        query.setParameter("filterId", (Object)aFilterId);
        return query;
    }

    @Override
    public List<String> getFilterIdentifiers() {
        Session session = this.sessionFactory.getCurrentSession();
        List filterIdentifiers = null;
        try {
            Query query = this.buildFilterStatusQuery(session);
            filterIdentifiers = query.list();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, null, null, null);
        }
        return filterIdentifiers;
    }

    @Override
    public void replaceFilterPersistence(Collection<FilterMetaDataInterface> filterMetaDatas) {
        Session session = this.sessionFactory.getCurrentSession();
        this.deleteAllFilterSchemaTableEntries(session);
        for (FilterMetaDataInterface filterMetaData : filterMetaDatas) {
            this.persistFilterSchema(filterMetaData, session);
        }
    }

    private void deleteAllFilterSchemaTableEntries(Session aSession) throws FilterCacheException {
        try {
            List filters = aSession.createCriteria(FilterMetaData.class).list();
            for (FilterMetaData filterMetaData : filters) {
                aSession.delete((Object)filterMetaData);
            }
        }
        catch (HibernateException e) {
            throw new FilterCacheException(ErrorCodeEnum.ERROR_DELETING_FILTER_DOMAIN_TABLES, (Throwable)e, new String[]{e.getMessage()});
        }
    }

    private void persistFilterSchema(FilterMetaDataInterface filterMetaData, Session aSession) throws FilterCacheException {
        try {
            this.persistifyVhimVersions(aSession, filterMetaData.getVhimVersionWrappers());
            this.persistifyEntryFilters(aSession, filterMetaData.getEntryFilters());
            this.persistifyFilter(aSession, filterMetaData);
        }
        catch (NullPointerException e) {
            throw new FilterCacheException(ErrorCodeEnum.CANNOT_SAVE_FILTER_SCHEMA, (Throwable)e, new String[]{filterMetaData.getFilterId(), e.getMessage()});
        }
        catch (HibernateException e) {
            throw new FilterCacheException(ErrorCodeEnum.CANNOT_SAVE_FILTER_SCHEMA, (Throwable)e, new String[]{filterMetaData.getFilterId(), e.getMessage()});
        }
    }

    private void persistifyEntryFilters(Session aSession, Set<EntryFilter> entryFilters) {
        EntryFilter[] entryFiltersArray = entryFilters.toArray(new EntryFilter[0]);
        EntryFilter queryResult = null;
        for (EntryFilter entryFilter : entryFiltersArray) {
            entryFilter.setDomainEntryPointWrapper(this.persistifyDomainEntryPoint(aSession, entryFilter.getDomainEntryPointWrapper()));
            Query query = entryFilter.getXpath() != null ? aSession.getNamedQuery("EntryFilterDomainXpath").setParameter("xpath", (Object)entryFilter.getXpath()).setParameter("depw", (Object)entryFilter.getDomainEntryPointWrapper()) : aSession.getNamedQuery("EntryFilterDomainNullXpath").setParameter("depw", (Object)entryFilter.getDomainEntryPointWrapper());
            queryResult = (EntryFilter)query.uniqueResult();
            if (queryResult == null) continue;
            entryFilters.remove(entryFilter);
            entryFilters.add(queryResult);
        }
    }

    private void persistifyFilter(Session aSession, FilterMetaDataInterface aFilterMetaData) {
        FilterMetaData queryResult = null;
        Query query = aSession.getNamedQuery("FilterSchemaId").setParameter("filterId", (Object)aFilterMetaData.getFilterId());
        queryResult = (FilterMetaData)query.uniqueResult();
        if (queryResult != null) {
            aSession.delete((Object)queryResult);
        }
        aSession.flush();
        aSession.save((Object)aFilterMetaData);
    }

    @Override
    public void persistFilterSchema(FilterMetaDataInterface aFilterMetaData) throws FilterCacheException {
        Session session = this.sessionFactory.getCurrentSession();
        this.persistFilterSchema(aFilterMetaData, session);
    }

    private FilterMetaData loadFilterFromPersistence(Session aSession, String aFilterId) {
        FilterMetaData queryResults = null;
        try {
            if (aFilterId == null) {
                throw new FilterCacheException(ErrorCodeEnum.CANNOT_LOAD_FILTER_SCHEMA_FROM_PERSISTENCE, new String[]{aFilterId, "aFilterId cannot be null"});
            }
            Query query = this.buildFilterIdQuery(aSession, aFilterId);
            queryResults = (FilterMetaData)query.uniqueResult();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, null, null, null);
        }
        return queryResults;
    }

    private List<FilterMetaData> loadFiltersFromPersistence(Session aSession) {
        ArrayList<FilterMetaData> filterMetaDatas = null;
        List filterIds = null;
        try {
            Query query = this.buildFilterStatusQuery(aSession);
            filterIds = query.list();
            filterMetaDatas = new ArrayList<FilterMetaData>(filterIds.size());
            for (String filterId : filterIds) {
                FilterMetaData filter = this.loadFilterFromPersistence(aSession, filterId);
                if (filter == null) continue;
                filterMetaDatas.add(filter);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, null, null, null);
        }
        return filterMetaDatas;
    }

    private void loadFilterMemoryCacheFromPersistence(FilterMemoryCacheInterface aFilterMemoryCache, String aFilterId, Session aSession) {
        if (aFilterMemoryCache == null) {
            throw new FilterCacheException(ErrorCodeEnum.FILTER_MEMORY_CACHE_IS_NOT_PROVIDED, new String[]{"The filterMemoryCache passed in is null."});
        }
        try {
            if (aFilterId == null) {
                List<FilterMetaData> hibernateQueryResults = this.loadFiltersFromPersistence(aSession);
                for (FilterMetaData filterMetaData : hibernateQueryResults) {
                    aFilterMemoryCache.loadFilterMetaDataIntoMemoryCache(filterMetaData.getFilterId(), (FilterMetaDataInterface)filterMetaData);
                }
            } else {
                FilterMetaData filterMetaData = this.loadFilterFromPersistence(aSession, aFilterId);
                if (filterMetaData != null) {
                    aFilterMemoryCache.loadFilterMetaDataIntoMemoryCache(aFilterId, (FilterMetaDataInterface)filterMetaData);
                }
            }
        }
        catch (HibernateException e) {
            throw new FilterCacheException(ErrorCodeEnum.CANNOT_LOAD_FILTER_SCHEMA_FROM_PERSISTENCE, (Throwable)e, new String[]{aFilterId, e.getMessage()});
        }
    }

    @Override
    public void loadAllFilterSchemasIntoMemoryCache(FilterMemoryCacheInterface filterMemoryCache) {
        Session session = this.sessionFactory.getCurrentSession();
        this.loadFilterMemoryCacheFromPersistence(filterMemoryCache, null, session);
    }

    @Override
    public void loadFilterIntoMemoryCache(String filterId, FilterMemoryCacheInterface filterMemoryCache) {
        Session session = this.sessionFactory.getCurrentSession();
        this.loadFilterMemoryCacheFromPersistence(filterMemoryCache, filterId, session);
    }

    @Override
    public void removeFilterSchema(String aFilterId) {
        Session session = this.sessionFactory.getCurrentSession();
        FilterMetaData filter = null;
        try {
            filter = (FilterMetaData)this.buildFilterIdQuery(session, aFilterId).uniqueResult();
            if (filter != null) {
                session.delete((Object)filter);
            }
        }
        catch (HibernateException e) {
            throw new FilterCacheException(ErrorCodeEnum.CANNOT_DELETE_FILTER, (Throwable)e, new String[]{aFilterId, e.getMessage()});
        }
    }
}

