/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.clinicaldata.FilterMetaData;
import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.FilterServiceException;
import gov.va.med.cds.filter.FilterServiceInterface;
import gov.va.med.cds.tfs.util.FilterMetaDataHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FilterServiceSimulator
implements FilterServiceInterface {
    private Map<String, Properties> filterMetaDataMap = new HashMap<String, Properties>();

    private File getFilterXsdFile(String aFilterId) {
        String filePath;
        File file = null;
        Properties properties = this.filterMetaDataMap.get(aFilterId);
        if (null != properties && null != (filePath = properties.getProperty("file")) && 0 < filePath.length()) {
            filePath = filePath.replace('\\', File.separatorChar);
            file = new File(filePath);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getXsdFromFile(File file) {
        FileInputStream is = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            return new String(bytes);
        }
        catch (IOException e) {
            throw new FilterServiceException(ErrorCodeEnum.CANNOT_LOAD_FILTER_SCHEMA_FROM_FILESYSTEM, (Throwable)e, new String[]{"Couldn't create a File from the filter file path: " + file.getAbsolutePath(), e.getMessage()});
        }
        finally {
            if (is != null) {
                try {
                    try {
                        ((InputStream)is).close();
                        is = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    public FilterMetaDataInterface getFilterMetaData(String aFilterId) {
        FilterMetaData metaData = null;
        Properties metaProps = this.filterMetaDataMap.get(aFilterId);
        if (null != metaProps) {
            metaData = new FilterMetaData();
            metaData.setFilterId(metaProps.getProperty("id"));
            metaData.setVhimVersions(FilterMetaDataHelper.buildVhimVersions(metaProps.getProperty("vhimVersion")));
            metaData.setEntryFilters(FilterMetaDataHelper.buildEntryFilters(metaProps.getProperty("entryPoint")));
            metaData.setFilterDescription(metaProps.getProperty("description"));
            metaData.setStatus("ACTIVE");
            File xsdFile = this.getFilterXsdFile(aFilterId);
            String xsd = this.getXsdFromFile(xsdFile);
            metaData.setFilterSchema(xsd);
        }
        return metaData;
    }

    public Collection<String> getVhimVersions() {
        ArrayList<String> vhimVersions = new ArrayList<String>();
        for (Map.Entry<String, Properties> entry : this.filterMetaDataMap.entrySet()) {
            Properties props = entry.getValue();
            String vhimVersion = props.getProperty("vhimVersion");
            if (null == vhimVersion || 0 >= vhimVersion.length() || vhimVersions.contains(vhimVersion)) continue;
            vhimVersions.add(vhimVersion);
        }
        return vhimVersions;
    }

    public void initialize() {
    }

    public synchronized void setTestFilters(Properties testProperties) throws IOException {
        try {
            String path = testProperties.getProperty("path", ".");
            boolean loadTestFilters = Boolean.parseBoolean(testProperties.getProperty("loadTestFilters", "false"));
            File dir = new File(path);
            if (!dir.exists()) {
                return;
            }
            if (dir.isFile()) {
                this.loadFilterMetaDataIntoMap(dir, loadTestFilters);
            } else {
                File[] files = dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".meta");
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    this.loadFilterMetaDataIntoMap(files[i], loadTestFilters);
                }
            }
        }
        catch (RuntimeException exception) {
            ExceptionHandler.handleException(exception, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilterMetaDataIntoMap(File filterPropFile, boolean loadTestFilters) throws IOException {
        FileInputStream propInputStream = null;
        try {
            propInputStream = new FileInputStream(filterPropFile);
            Properties filterProps = new Properties();
            filterProps.load(propInputStream);
            propInputStream.close();
            boolean testonly = Boolean.parseBoolean(filterProps.getProperty("testOnly", "false"));
            if (loadTestFilters || !testonly) {
                this.filterMetaDataMap.put(filterProps.getProperty("id"), filterProps);
            }
        }
        finally {
            if (propInputStream != null) {
                try {
                    propInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    propInputStream = null;
                }
            }
        }
    }

    public Collection<String> getActiveFilterIds(String aVhimVersion) throws FilterServiceException {
        ArrayList<String> filterIds = new ArrayList<String>();
        for (Map.Entry<String, Properties> entry : this.filterMetaDataMap.entrySet()) {
            if (!entry.getValue().getProperty("vhimVersion").equals(aVhimVersion)) continue;
            String filterId = entry.getKey();
            filterIds.add(filterId);
        }
        return filterIds;
    }

    public boolean isAlive() {
        return true;
    }
}

