/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMap;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.request.ValidationException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.dom4j.Element;

public class FilterQueryMetadata
implements EntryFilterInterface {
    public static final int DEFAULT_MAX_PAGE_SIZE = 500;
    public static final int DEFAULT_PAGE_NUMBER = 1;
    protected static final String XS_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private static final String DATABASE_DATE_FORMAT_PATTERN = "yyyyMMddHHmmss";
    private String domainEntryPoint = null;
    private String queryName = null;
    private boolean countOnly = false;
    private String xpathQuery = null;
    private String jsonPathQuery = null;
    private Calendar startDate;
    private Calendar endDate;
    private String requestId = null;
    private String templateId = null;
    private Long timeout = null;
    private List<String> recordIdentifiers = null;
    private boolean useDates = false;
    private boolean isPatientCentricFilter = true;
    private String facilityId = null;
    private ParameterMap additionalParametersMap = null;
    private String[] elementNames = new String[]{"queryTimeoutSeconds", "domainEntryPoint", "otherQueryParameters", "recordIdentifiers", "xpathQuery", "jsonPathQuery", "endDate", "startDate", "orderBy", "xpathFilter", "xpathExtractor"};
    private String[] unsupportedKeyWrds = new String[]{"SELECT", "DELETE", "UPDATE", "CREATE", "DROP", "ALTER", "COMMIT", "ROLLBACK", "TRUNCATE"};
    ArrayList<String> entryFilterElementNames = null;
    private String xpathExtractExpression = null;
    private String xpathFilterExpression = null;
    private int pageNumber = 1;
    private int pageSize = 500;
    private String xpathExtractExpressionNamespace;
    private String xpathFilterExpressionNamespace;

    @Override
    public String getXpathFilterExpression() {
        return this.xpathFilterExpression;
    }

    @Override
    public String getXpathFilterExpressionNamespace() {
        return this.xpathFilterExpressionNamespace;
    }

    @Override
    public String getXpathExtractExpression() {
        return this.xpathExtractExpression;
    }

    @Override
    public String getXpathExtractExpressionNamespace() {
        return this.xpathExtractExpressionNamespace;
    }

    @Override
    public String getDomainEntryPoint() {
        return this.domainEntryPoint;
    }

    @Override
    public Calendar getEndDate() {
        return this.endDate;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public boolean isCountOnly() {
        return this.countOnly;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public boolean isPagingFilter() {
        return this.getPageSize() > 0 && this.getPageNumber() >= 0;
    }

    @Override
    public List<String> getRecordIdentifiers() {
        return this.recordIdentifiers;
    }

    @Override
    public Calendar getStartDate() {
        return this.startDate;
    }

    @Override
    public String getXpathQuery() {
        return this.xpathQuery;
    }

    @Override
    public String getJsonPathQuery() {
        return this.jsonPathQuery;
    }

    @Override
    public boolean useDates() {
        return this.useDates;
    }

    @Override
    public ParameterMapInterface getAdditionalParametersMap() {
        return this.additionalParametersMap;
    }

    protected FilterQueryMetadata(Element entryFilter, String templateId, String requestId) {
        this.initElementNames();
        this.extractMetadata(entryFilter);
        this.setRequestId(requestId);
        this.setTemplateId(templateId);
    }

    protected void initElementNames() {
        this.entryFilterElementNames = new ArrayList();
        for (String name : this.elementNames) {
            this.entryFilterElementNames.add(name);
        }
    }

    private void extractMetadata(Element entryFilter) {
        String facilityIdStr;
        SimpleDateFormat databaseDateFormat = new SimpleDateFormat(DATABASE_DATE_FORMAT_PATTERN);
        this.startDate = this.extractDate("18410101000000", databaseDateFormat);
        this.endDate = this.extractDate("30001231235959", databaseDateFormat);
        this.queryName = entryFilter.attributeValue("queryName");
        this.countOnly = Boolean.parseBoolean(entryFilter.attributeValue("countOnly"));
        this.pageNumber = entryFilter.attributeValue("pageNumber") != null ? Integer.parseInt(entryFilter.attributeValue("pageNumber")) : 1;
        this.pageSize = entryFilter.attributeValue("pageSize") != null && Integer.parseInt(entryFilter.attributeValue("pageSize")) < 500 ? Integer.parseInt(entryFilter.attributeValue("pageSize")) : 500;
        String patientCentricFilterStr = entryFilter.attributeValue("isPatientCentric");
        if (patientCentricFilterStr != null) {
            this.isPatientCentricFilter = Boolean.parseBoolean(entryFilter.attributeValue("isPatientCentric"));
        }
        if ((facilityIdStr = entryFilter.attributeValue("facilityId")) != null) {
            this.facilityId = facilityIdStr;
        }
        Element specializedEntryFilter = this.extractSpecializedEntryPointFilter(entryFilter);
        this.domainEntryPoint = specializedEntryFilter.element("domainEntryPoint").getTextTrim();
        this.extractTimeout(entryFilter);
        this.extractStartAndEndDates(entryFilter);
        this.extractRecordIdentifiers(entryFilter);
        this.extractXpathQuery(entryFilter);
        this.extractJsonPathQuery(entryFilter);
        this.extractAdditionalParameters(specializedEntryFilter);
        this.extractXpathExpressions(entryFilter);
    }

    private void extractXpathExpressions(Element entryFilter) {
        Element xpathFilterElement;
        Element xpathQueryElement = entryFilter.element("xpathExtractor");
        if (xpathQueryElement != null) {
            Element xpathElement = xpathQueryElement.element("expression");
            if (xpathElement == null) {
                throw new ValidationException(ErrorCodeEnum.INVALID_XPATH_QUERY);
            }
            this.xpathExtractExpression = xpathElement.getTextTrim();
            this.xpathExtractExpressionNamespace = xpathQueryElement.attributeValue("extractorNamespace");
        }
        if ((xpathFilterElement = entryFilter.element("xpathFilter")) != null) {
            Element xpathElement = xpathFilterElement.element("expression");
            if (xpathElement == null) {
                throw new ValidationException(ErrorCodeEnum.INVALID_XPATH_QUERY);
            }
            this.xpathFilterExpression = xpathElement.getTextTrim();
            this.xpathFilterExpressionNamespace = xpathFilterElement.attributeValue("filterNamespace");
        }
    }

    private Element extractSpecializedEntryPointFilter(Element entryFilter) {
        List elements = entryFilter.elements();
        for (Element element : elements) {
            if (this.entryFilterElementNames.contains(element.getName())) continue;
            return element;
        }
        return entryFilter;
    }

    private void extractStartAndEndDates(Element entryFilter) {
        Element startDateElement = entryFilter.element("startDate");
        if (startDateElement == null) {
            this.extractStartAndEndDateCalendars(entryFilter);
        } else if (startDateElement.getTextTrim().length() == 10) {
            this.extractStartAndEndDateCalendars(entryFilter);
        } else {
            this.extractStartAndEndDateTimestampCalendars(entryFilter);
        }
    }

    private void extractStartAndEndDateTimestampCalendars(Element entryFilter) {
        this.useDates = true;
        if (entryFilter.element("startDate") != null) {
            String startDateString = entryFilter.element("startDate").getTextTrim();
            this.startDate = this.extractXsDate(startDateString);
        }
        if (entryFilter.element("endDate") != null) {
            String endDateString = entryFilter.element("endDate").getTextTrim();
            this.endDate = this.extractXsDate(endDateString);
            this.endDate.add(5, 1);
            this.endDate.add(14, -1);
        }
    }

    private Calendar extractXsDate(String dateString) {
        try {
            return DatatypeConverter.parseDateTime((String)dateString);
        }
        catch (Exception e) {
            throw new ValidationException(ErrorCodeEnum.CANNOT_PARSE_DATE, dateString);
        }
    }

    private void extractStartAndEndDateCalendars(Element entryFilter) {
        Element endDateElement;
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat(XS_DATE_FORMAT_PATTERN);
        Element startDateElement = entryFilter.element("startDate");
        if (startDateElement != null) {
            this.useDates = true;
            String startDateString = startDateElement.getTextTrim();
            this.startDate = this.extractDate(startDateString, xmlDateFormat);
            this.startDate.set(11, 0);
            this.startDate.set(12, 0);
            this.startDate.set(13, 0);
            this.startDate.add(5, -1);
        }
        if (startDateElement == null && this.domainEntryPoint.equals("Appointment")) {
            this.useDates = true;
            SimpleDateFormat sdf = new SimpleDateFormat(XS_DATE_FORMAT_PATTERN);
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -90);
            String todayMinus90 = sdf.format(cal.getTime());
            this.startDate = this.extractDate(todayMinus90, xmlDateFormat);
            this.startDate.set(11, 0);
            this.startDate.set(12, 0);
            this.startDate.set(13, 0);
            this.startDate.add(5, -1);
        }
        if ((endDateElement = entryFilter.element("endDate")) != null) {
            this.useDates = true;
            String endDateString = endDateElement.getTextTrim();
            this.endDate = this.extractDate(endDateString, xmlDateFormat);
            this.endDate.set(11, 23);
            this.endDate.set(12, 59);
            this.endDate.set(13, 59);
            this.endDate.add(5, 1);
        }
        if (endDateElement == null && this.domainEntryPoint.equals("Appointment")) {
            this.useDates = true;
            SimpleDateFormat sdf = new SimpleDateFormat(XS_DATE_FORMAT_PATTERN);
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(6, 120);
            String todayPlus120 = sdf.format(cal.getTime());
            this.endDate = this.extractDate(todayPlus120, xmlDateFormat);
            this.endDate.set(11, 23);
            this.endDate.set(12, 59);
            this.endDate.set(13, 59);
            this.endDate.add(5, 1);
        }
    }

    private void extractTimeout(Element entryFilter) {
        Element timeoutElement = entryFilter.element("queryTimeoutSeconds");
        if (timeoutElement != null) {
            try {
                this.timeout = new Long(timeoutElement.getTextTrim());
            }
            catch (NumberFormatException nfe) {
                throw new ValidationException(ErrorCodeEnum.CANNOT_PARSE_TIMEOUT);
            }
        }
    }

    protected void extractAdditionalParameters(Element entryFilter) {
        Element additionalParametersElement = entryFilter.element("otherQueryParameters");
        if (additionalParametersElement != null) {
            for (String unsupportedValue : this.unsupportedKeyWrds) {
                String param = additionalParametersElement.getStringValue();
                if (!param.toUpperCase().contains(unsupportedValue)) continue;
                throw new ValidationException(ErrorCodeEnum.INVALID_OTHER_QUERY_PARAMS, param);
            }
            this.additionalParametersMap = new ParameterMap(additionalParametersElement);
        }
    }

    private void extractXpathQuery(Element entryFilter) {
        Element xpathQueryElement = entryFilter.element("xpathQuery");
        if (xpathQueryElement != null) {
            Element xpathElement = xpathQueryElement.element("xpath");
            if (xpathElement == null) {
                throw new ValidationException(ErrorCodeEnum.INVALID_XPATH_QUERY);
            }
            this.xpathQuery = xpathElement.getTextTrim();
        }
    }

    private void extractJsonPathQuery(Element entryFilter) {
        Element jsonPathQueryElement = entryFilter.element("jsonPathQuery");
        if (jsonPathQueryElement != null) {
            Element jsonPathElement = jsonPathQueryElement.element("jsonPath");
            if (jsonPathElement == null) {
                throw new ValidationException(ErrorCodeEnum.INVALID_JSONPATH_QUERY);
            }
            this.jsonPathQuery = jsonPathElement.getTextTrim();
        }
    }

    private void extractRecordIdentifiers(Element entryFilter) {
        List recordIdentifierElements = entryFilter.elements("recordIdentifiers");
        if (recordIdentifierElements != null) {
            this.recordIdentifiers = this.extractRecordIdentifiers(recordIdentifierElements);
        }
    }

    protected Calendar extractDate(String dateString, DateFormat dateFormatter) {
        try {
            Date dateFromString = dateFormatter.parse(dateString);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateFromString);
            return cal;
        }
        catch (ParseException e) {
            throw new ValidationException(ErrorCodeEnum.CANNOT_PARSE_DATE, dateString);
        }
    }

    private List<String> extractRecordIdentifiers(List<Element> recordIdentifierElements) {
        ArrayList<String> extractedRecordIdentifiers = new ArrayList<String>();
        for (Element recordIdentifierElement : recordIdentifierElements) {
            String concatenateRecordIdentifier = this.getRecordIdentifierField(recordIdentifierElement, "identity") + "/" + this.getRecordIdentifierField(recordIdentifierElement, "namespaceId") + "/" + this.getRecordIdentifierField(recordIdentifierElement, "universalId") + "/" + this.getRecordIdentifierField(recordIdentifierElement, "universalIdType");
            extractedRecordIdentifiers.add(concatenateRecordIdentifier);
        }
        return extractedRecordIdentifiers;
    }

    private String getRecordIdentifierField(Element recordIdentifierElement, String fieldName) {
        String fieldValue = "";
        Element recordIdentifierFieldElement = recordIdentifierElement.element(fieldName);
        if (recordIdentifierFieldElement != null) {
            fieldValue = recordIdentifierFieldElement.getTextTrim();
        }
        return fieldValue;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @Override
    public Long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isPatientCentricFilter() {
        return this.isPatientCentricFilter;
    }

    @Override
    public boolean isSiteCentricFilter() {
        boolean siteCentric = false;
        if (!this.isPatientCentricFilter()) {
            siteCentric = this.facilityId != null;
        }
        return siteCentric;
    }

    @Override
    public String getFacilityId() {
        return this.facilityId;
    }

    @Override
    public boolean hasRecordIdentifiers() {
        return this.recordIdentifiers != null && this.recordIdentifiers.size() != 0;
    }

    @Override
    public boolean containsXpathFilterExpression() {
        return this.getXpathFilterExpression() != null && this.getXpathFilterExpression().length() > 0;
    }

    public void setAdditionalParametersMap(ParameterMap additionalParametersMap) {
        this.additionalParametersMap = additionalParametersMap;
    }

    @Override
    public Map<String, Object> getDataMap() {
        return null;
    }

    @Override
    public List<PersonIdentifierInterface> getPersonIdentifiers() {
        return null;
    }
}

