/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;
import gov.va.med.cds.filter.FilterMemoryCacheInterface;
import gov.va.med.cds.util.LRUHashMap;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.validation.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterMemoryCache
implements FilterMemoryCacheInterface {
    private static final Log LOGGER = LogFactory.getLog(FilterMemoryCache.class);
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.reentrantReadWriteLock.readLock();
    private final Lock writeLock = this.reentrantReadWriteLock.writeLock();
    private LRUHashMap<String, FilterMetaDataInterface> filterMemoryCacheMap = null;

    public FilterMemoryCache(LRUHashMap<String, FilterMetaDataInterface> aMap) {
        this.filterMemoryCacheMap = aMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadFilterMetaDataIntoMemoryCache(String filterId, FilterMetaDataInterface filterMetaData) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("loading filterId " + filterId));
        }
        if (!this.filterMemoryCacheMap.containsKey(filterId)) {
            this.writeLock.lock();
            try {
                if (this.filterMemoryCacheMap.containsKey(filterId)) return;
                this.filterMemoryCacheMap.put(filterId, filterMetaData);
                return;
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            if (!LOGGER.isWarnEnabled()) return;
            LOGGER.warn((Object)("The filterId='" + filterId + "' already exists. The filter registry will not add another one."));
        }
    }

    @Override
    public String getFilterString(String filterId) {
        FilterMetaDataInterface filerMetaData = (FilterMetaDataInterface)this.filterMemoryCacheMap.get(filterId);
        if (null != filerMetaData) {
            return filerMetaData.getFilterSchemaXml();
        }
        return null;
    }

    @Override
    public Schema getFilterSchema(String filterId) {
        FilterMetaDataInterface filerMetaData = (FilterMetaDataInterface)this.filterMemoryCacheMap.get(filterId);
        if (null != filerMetaData) {
            return filerMetaData.getFilterSchema();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = true;
        try {
            this.readLock.lock();
            isEmpty = this.filterMemoryCacheMap.isEmpty();
        }
        finally {
            this.readLock.unlock();
        }
        return isEmpty;
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            this.filterMemoryCacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getNumberOfFilterSchemasLoadedIntoFilterCache() {
        return this.filterMemoryCacheMap.size();
    }

    @Override
    public int getFilterCacheThreshold() {
        return this.filterMemoryCacheMap.getMapThreshold();
    }

    @Override
    public void reSize(int newSize) {
        try {
            this.writeLock.lock();
            this.filterMemoryCacheMap.reSize(newSize);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<String> getFilterCacheFilterIds() {
        return this.filterMemoryCacheMap.keySet();
    }
}

