/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.clinicaldata.FilterMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.FilterCacheException;
import gov.va.med.cds.filter.FilterCachePersistenceInterface;
import gov.va.med.cds.filter.FilterManagerMBeanInterface;
import gov.va.med.cds.filter.FilterMemoryCacheInterface;
import gov.va.med.cds.filter.FilterServiceException;
import gov.va.med.cds.filter.FilterServiceInterface;
import gov.va.med.cds.filter.FilterValidatorInterface;
import gov.va.med.cds.request.ValidationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class FilterManager
implements FilterManagerMBeanInterface,
FilterValidatorInterface {
    private FilterCachePersistenceInterface filterCachePersistence;
    private FilterMemoryCacheInterface filterMemoryCache;
    private FilterServiceInterface filterService = null;
    private static final Log LOGGER = LogFactory.getLog(FilterManager.class);

    public FilterManager(FilterServiceInterface aFilterService, FilterCachePersistenceInterface aFilterCachePersistence, FilterMemoryCacheInterface aFilterMemoryCache) {
        LOGGER.debug((Object)"FilterManager started...");
        this.filterService = aFilterService;
        this.filterCachePersistence = aFilterCachePersistence;
        this.filterMemoryCache = aFilterMemoryCache;
        this.initialize();
    }

    private void initialize() {
        try {
            this.filterService.initialize();
            this.persistFiltersFromService();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Filter Service Initialization failed", (Throwable)e);
        }
        this.filterCachePersistence.loadAllFilterSchemasIntoMemoryCache(this.filterMemoryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateFilterXml(String filterId, String filterXml) {
        Schema filterSchema = this.filterMemoryCache.getFilterSchema(filterId);
        if (filterSchema == null) {
            FilterMemoryCacheInterface filterMemoryCacheInterface = this.filterMemoryCache;
            synchronized (filterMemoryCacheInterface) {
                this.filterCachePersistence.loadFilterIntoMemoryCache(filterId, this.filterMemoryCache);
                filterSchema = this.filterMemoryCache.getFilterSchema(filterId);
                if (filterSchema == null) {
                    this.retrieveAndPersistFilterFromService(filterId);
                    this.filterCachePersistence.loadFilterIntoMemoryCache(filterId, this.filterMemoryCache);
                    filterSchema = this.filterMemoryCache.getFilterSchema(filterId);
                    if (filterSchema == null) {
                        throw new FilterCacheException(ErrorCodeEnum.UNABLE_TO_READ_FILTER_SCHEMA, new String[]{filterId});
                    }
                }
            }
        }
        try {
            Validator filterSchemaValidator = filterSchema.newValidator();
            filterSchemaValidator.validate(new StreamSource(new StringReader(filterXml)));
        }
        catch (SAXException e) {
            throw new ValidationException(ErrorCodeEnum.INVALID_FILTER_SCHEMA, e, filterId, ExceptionUtils.getRootCause((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage());
        }
        catch (IOException e) {
            throw new FilterCacheException(ErrorCodeEnum.UNABLE_TO_READ_FILTER_SCHEMA, (Throwable)e, new String[]{filterId, e.getMessage()});
        }
    }

    @Override
    public synchronized void reinitializeFilterMemoryCache() {
        FilterMemoryCacheInterface tempCache = this.filterMemoryCache;
        try {
            this.clearFilterMemoryCache();
            this.initialize();
        }
        catch (Exception e) {
            this.filterMemoryCache = tempCache;
        }
    }

    @Override
    public synchronized void clearFilterMemoryCache() {
        if (null != this.filterMemoryCache && !this.filterMemoryCache.isEmpty()) {
            this.filterMemoryCache.clear();
        }
    }

    @Override
    public synchronized void resizeFilterMemoryCache(int newSize) {
        if (this.getFilterCacheThreshold() > newSize) {
            this.filterMemoryCache.reSize(newSize);
            this.reinitializeFilterMemoryCache();
        } else {
            this.filterMemoryCache.reSize(newSize);
        }
    }

    @Override
    public int getNumberOfFilterSchemasLoadedIntoFilterCache() {
        return this.filterMemoryCache.getNumberOfFilterSchemasLoadedIntoFilterCache();
    }

    @Override
    public int getFilterCacheThreshold() {
        return this.filterMemoryCache.getFilterCacheThreshold();
    }

    @Override
    public List<String> getFilterCacheFilterIds() {
        ArrayList<String> list = new ArrayList<String>(this.filterMemoryCache.getFilterCacheFilterIds());
        return list;
    }

    private void persistFiltersFromService() {
        Collection filterIds = null;
        Collection vhimVersions = this.filterService.getVhimVersions();
        for (String vhimVersionName : vhimVersions) {
            filterIds = this.filterService.getActiveFilterIds(vhimVersionName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("looping on vhim version: " + vhimVersionName));
            }
            for (String filterId : filterIds) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("\tRetrieving and Persisting filter from service, filter ID: " + filterId));
                }
                this.retrieveAndPersistFilterFromService(filterId);
            }
        }
    }

    private void retrieveAndPersistFilterFromService(String aFilterId) {
        try {
            FilterMetaDataInterface filterMetaData = this.filterService.getFilterMetaData(aFilterId);
            if (filterMetaData != null) {
                filterMetaData.setDateUpdated(new Date());
                this.filterCachePersistence.persistFilterSchema(filterMetaData);
            }
        }
        catch (FilterServiceException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("FilterServiceException in retrieveAndPersistFilterFromService, filter ID: " + aFilterId + " Exception Message: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception in retrieveAndPersistFilterFromService, filter ID: " + aFilterId + " Exception Message: " + e.getMessage()));
        }
    }
}

