/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.filter.FilterQueryMetadata;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.filter.QueryParameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class Filter100QueryMetadata
extends FilterQueryMetadata
implements ParameterMapInterface {
    private Map<String, QueryParameter<?>> queryParameterMap;

    protected Filter100QueryMetadata(Element entryFilter, String templateId, String requestId) {
        super(entryFilter, templateId, requestId);
    }

    @Override
    public ParameterMapInterface getAdditionalParametersMap() {
        return this;
    }

    @Override
    protected void extractAdditionalParameters(Element entryFilter) {
        Element additionalParametersElement = entryFilter.element("otherQueryParameters");
        if (additionalParametersElement != null) {
            this.queryParameterMap = new HashMap();
            QueryParameter<Object> queryParameter = null;
            List additionalParametersList = additionalParametersElement.elements();
            for (Element additionalParameter : additionalParametersList) {
                String paramType;
                String paramName = additionalParameter.attributeValue("name") != null ? additionalParameter.attributeValue("name") : additionalParameter.getName();
                String string = paramType = additionalParameter.attributeValue("type") != null ? additionalParameter.attributeValue("type") : "string";
                if ("dateRange".equals(paramType)) {
                    queryParameter = this.extractDateRangeParameter(additionalParameter);
                } else if ("list".equals(paramType)) {
                    queryParameter = this.extractListTypeParameter(additionalParameter.elements());
                    queryParameter.setName(paramName);
                    queryParameter.setType(paramType);
                } else {
                    queryParameter = new QueryParameter();
                    queryParameter.setName(paramName);
                    String paramValue = additionalParameter.elementTextTrim("value");
                    queryParameter.setValue(paramValue);
                }
                queryParameter.setType(paramType);
                this.queryParameterMap.put(paramName, queryParameter);
            }
        }
    }

    private QueryParameter<Map<String, Calendar>> extractDateRangeParameter(Element additionalParameter) {
        QueryParameter<HashMap<String, Calendar>> queryParameter = null;
        List elements = additionalParameter.elements();
        if (elements != null && elements.size() > 0 && elements.size() < 3) {
            Element beginDateElement = (Element)elements.get(0);
            Element endDateElement = (Element)elements.get(1);
            HashMap<String, Calendar> valueMap = new HashMap<String, Calendar>();
            queryParameter = new QueryParameter<HashMap<String, Calendar>>();
            queryParameter.setName(additionalParameter.attributeValue("name"));
            queryParameter.setValue(valueMap);
            Calendar c = null;
            if (beginDateElement != null) {
                c = this.extractCalendar(beginDateElement, -1);
                valueMap.put("begin", c);
            }
            if (endDateElement != null) {
                c = this.extractCalendar(endDateElement, 1);
                valueMap.put("end", c);
            }
        }
        return queryParameter;
    }

    private Calendar extractCalendar(Element dateElement, int dayOffset) {
        SimpleDateFormat xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = null;
        if (dateElement != null) {
            String dateString = dateElement.getTextTrim();
            c = this.extractDate(dateString, xmlDateFormat);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.add(5, dayOffset);
        }
        return c;
    }

    private QueryParameter<List<String>> extractListTypeParameter(List<Element> valueElements) {
        ArrayList<String> values = new ArrayList<String>();
        QueryParameter<List<String>> queryParameter = new QueryParameter<List<String>>();
        queryParameter.setValue(values);
        for (Element valueElement : valueElements) {
            values.add(valueElement.getTextTrim());
        }
        return queryParameter;
    }

    @Override
    public Set<String> getFilterParameterNames() {
        HashSet<String> parameterNames = new HashSet<String>();
        if (this.queryParameterMap != null && this.queryParameterMap.size() > 0) {
            parameterNames.addAll(this.queryParameterMap.keySet());
        }
        return parameterNames;
    }

    @Override
    public QueryParameter<?> getParameterValue(String parameterName) {
        return this.queryParameterMap.get(parameterName);
    }
}

