/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.EntryFilterFactory;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CdsFilter
implements CdsFilterInterface {
    protected static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    protected static final String CDS_FILTER_PATH = "classpath:gov/va/med/cds/filter/schema/Filter100.xsd";
    private String filterId = null;
    private String filterXml = null;
    private String uniqueIdentifier = null;
    private Element rootFilterElement = null;
    private Map<String, EntryFilterInterface> entryPointFilterMap = null;
    private List<PersonIdentifierInterface> queryablePersonIdentifiers = null;
    private List<Element> excludeIdentifiers = new ArrayList<Element>();
    private List<Element> resolvedIdentifiers = new ArrayList<Element>();
    private Element nationalId = null;
    private Element edipi = null;
    private static String HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER = "HEALTH_ADAPTER_SINGLE_PATIENT_ALL_DATA_FILTER";
    public static String EDIPI_ID_TAG = "EdiPi";
    private EntryFilterFactory entryFilterFactory = null;

    CdsFilter(Document filterDocument, String templateId, String requestId) {
        this.initFilter(filterDocument, templateId, requestId);
    }

    @Override
    public Element getEdipi() {
        return this.edipi;
    }

    CdsFilter(String filterId, Document filterDocument, String templateId, String requestId, EntryFilterFactory entryFilterFactory) {
        this.setEntryFilterFactory(entryFilterFactory);
        this.initFilter(filterDocument, templateId, requestId);
    }

    void initFilter(Document filterDocument, String templateId, String requestId) {
        this.setUniqueIdentifier();
        this.filterXml = filterDocument.asXML();
        this.setEntryPointFilterMap(filterDocument, templateId, requestId);
        this.setIdentifierElements();
    }

    private void setUniqueIdentifier() {
        this.uniqueIdentifier = new UniqueIdentifier().getValue();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    private void setEntryPointFilterMap(Document filterRequestDocument, String templateId, String requestId) {
        this.rootFilterElement = filterRequestDocument.getRootElement();
        this.filterId = this.rootFilterElement.element("filterId").getTextTrim();
        List entryPointFilterElements = this.rootFilterElement.elements("entryPointFilter");
        if (entryPointFilterElements.size() <= 0) {
            throw new ValidationException(ErrorCodeEnum.NO_ENTRYPOINTS_IN_FILTER, this.filterXml);
        }
        this.entryPointFilterMap = new HashMap<String, EntryFilterInterface>();
        for (Element entryFilter : entryPointFilterElements) {
            EntryFilterInterface entryFilterInterface = this.entryFilterFactory.createEntryFilter(this.filterId, templateId, entryFilter, requestId);
            String queryName = entryFilterInterface.getQueryName();
            if (this.entryPointFilterMap.containsKey(queryName)) {
                throw new ValidationException(ErrorCodeEnum.ERROR_MARSHALLING_FILTER_XML, this.filterXml, "Entry filter " + queryName + " already exists.");
            }
            this.entryPointFilterMap.put(queryName, entryFilterInterface);
        }
    }

    @Override
    public EntryFilterInterface getEntryFilter(String queryName) {
        return this.entryPointFilterMap.get(queryName);
    }

    @Override
    public List<EntryFilterInterface> getEntryPointFilters() {
        ArrayList<EntryFilterInterface> entryFilters = new ArrayList<EntryFilterInterface>();
        entryFilters.addAll(this.entryPointFilterMap.values());
        return entryFilters;
    }

    @Override
    public String getFilterXml() {
        return this.filterXml;
    }

    @Override
    public String getFilterId() {
        return this.filterId;
    }

    @Override
    public List<PersonIdentifierInterface> getPersonIdentifiers() {
        if (this.queryablePersonIdentifiers == null) {
            Element patientsElement = this.rootFilterElement.element("patients");
            if (patientsElement == null) {
                throw new ValidationException(ErrorCodeEnum.NO_PATIENT_IDS_REQUESTED);
            }
            Element ediPiElement = patientsElement.element(EDIPI_ID_TAG);
            if (ediPiElement != null && ediPiElement.elements().size() > 0) {
                this.getEdipiIdentifier(patientsElement);
            } else {
                this.getResolvedPatientIdentifiers(patientsElement);
            }
        }
        return this.queryablePersonIdentifiers;
    }

    private void getResolvedPatientIdentifiers(Element patientsElement) {
        List identifierList = patientsElement.elements("resolvedIdentifiers");
        if (identifierList == null || identifierList.size() == 0) {
            throw new ValidationException(ErrorCodeEnum.NO_PATIENT_IDS_REQUESTED);
        }
        this.queryablePersonIdentifiers = new ArrayList<PersonIdentifierInterface>();
        for (Element patientId : identifierList) {
            PersonIdentifier patientIdentifier = new PersonIdentifier();
            patientIdentifier.setAssigningAuthority(patientId.element("assigningAuthority").getTextTrim());
            if (patientIdentifier.getAssigningAuthority() == null || patientIdentifier.getAssigningAuthority().isEmpty()) {
                throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_ASSIGNING_AUTHORITY);
            }
            patientIdentifier.setAssigningFacility(patientId.element("assigningFacility").getTextTrim());
            if (patientIdentifier.getAssigningFacility() == null || patientIdentifier.getAssigningFacility().isEmpty()) {
                throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_ASSIGNING_FACILITY);
            }
            patientIdentifier.setIdentity(patientId.element("identity").getTextTrim());
            if (patientIdentifier.getIdentity() == null || patientIdentifier.getIdentity().isEmpty()) {
                throw new ValidationException(ErrorCodeEnum.PATIENT_ID_MISSING_IDENTITY);
            }
            this.queryablePersonIdentifiers.add((PersonIdentifierInterface)patientIdentifier);
        }
    }

    private void getEdipiIdentifier(Element patientsElement) {
        Element patientId = patientsElement.element(EDIPI_ID_TAG);
        if (patientId == null) {
            throw new ValidationException(ErrorCodeEnum.NO_EDIPI_REQUESTED);
        }
        this.queryablePersonIdentifiers = new ArrayList<PersonIdentifierInterface>();
        PersonIdentifier patientIdentifier = new PersonIdentifier();
        patientIdentifier.setAssigningAuthority(patientId.element("assigningAuthority").getTextTrim());
        if (patientIdentifier.getAssigningAuthority() == null || patientIdentifier.getAssigningAuthority().isEmpty()) {
            throw new ValidationException(ErrorCodeEnum.EDIPI_PATIENT_ID_MISSING_ASSIGNING_AUTHORITY);
        }
        patientIdentifier.setAssigningFacility(patientId.element("assigningFacility").getTextTrim());
        if (patientIdentifier.getAssigningFacility() == null || patientIdentifier.getAssigningFacility().isEmpty()) {
            throw new ValidationException(ErrorCodeEnum.EDIPI_PATIENT_ID_MISSING_ASSIGNING_FACILITY);
        }
        patientIdentifier.setIdentity(patientId.element("identity").getTextTrim());
        if (patientIdentifier.getIdentity() == null || patientIdentifier.getIdentity().isEmpty()) {
            throw new ValidationException(ErrorCodeEnum.EDIPI_PATIENT_ID_MISSING_IDENTITY);
        }
        this.queryablePersonIdentifiers.add((PersonIdentifierInterface)patientIdentifier);
    }

    @Override
    public String getVhimVersion() {
        return this.rootFilterElement.attributeValue("vhimVersion");
    }

    @Override
    public Set<String> getDomainEntryPoints() {
        HashSet<String> entryPoints = new HashSet<String>();
        for (EntryFilterInterface filter : this.getEntryPointFilters()) {
            entryPoints.add(filter.getDomainEntryPoint());
        }
        return entryPoints;
    }

    @Override
    public Element getNationalId() {
        return this.nationalId;
    }

    @Override
    public List<Element> getResolvedIdentifiers() {
        return this.resolvedIdentifiers;
    }

    @Override
    public List<Element> getExcludedIdentifiers() {
        return this.excludeIdentifiers;
    }

    private void setIdentifierElements() {
        Element patient = this.rootFilterElement.element("patients");
        if (patient != null) {
            this.nationalId = patient.element("NationalId");
            this.edipi = patient.element("EdiPi");
            List resolvedIdentifiers = patient.elements("resolvedIdentifiers");
            for (Element patientIdentifier : resolvedIdentifiers) {
                Element resolvedIdentifier = DocumentHelper.createElement((String)"resultantIdentifiers");
                resolvedIdentifier.addElement("identity").setText(patientIdentifier.elementText("identity"));
                resolvedIdentifier.addElement("assigningAuthority").setText(patientIdentifier.elementText("assigningAuthority"));
                resolvedIdentifier.addElement("assigningFacility").setText(patientIdentifier.elementText("assigningFacility"));
                this.resolvedIdentifiers.add(resolvedIdentifier);
            }
            List excludedIdentifiers = patient.elements("excludeIdentifiers");
            for (Element excludeIdent : excludedIdentifiers) {
                Element excludedIdentifier = DocumentHelper.createElement((String)"requestedExcludedIdentifiers");
                String identtity = excludeIdent.elementText("identity");
                if (identtity != null) {
                    excludedIdentifier.addElement("identity").setText(identtity);
                }
                excludedIdentifier.addElement("assigningAuthority").setText(excludeIdent.elementText("assigningAuthority"));
                String assigFacility = excludeIdent.elementText("assigningFacility");
                if (assigFacility != null) {
                    excludedIdentifier.addElement("assigningFacility").setText(assigFacility);
                } else {
                    excludedIdentifier.addElement("assigningFacility").setText("");
                }
                this.excludeIdentifiers.add(excludedIdentifier);
            }
        }
    }

    @Override
    public boolean isPatientCentricFilter() {
        String isPatientCentricStr = this.rootFilterElement.element("entryPointFilter").attributeValue("isPatientCentric");
        if (isPatientCentricStr == null) {
            return true;
        }
        return isPatientCentricStr != null && isPatientCentricStr.length() > 0 && Boolean.parseBoolean(isPatientCentricStr) == Boolean.TRUE;
    }

    public void setEntryFilterFactory(EntryFilterFactory entryFilterFactory) {
        this.entryFilterFactory = entryFilterFactory;
    }
}

