/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.exceptionframework;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.clinicaldata.vhim400.PathwaysDataResponseInterface;
import gov.va.med.cds.exception.AbstractCdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.exception.SystemException;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import gov.va.med.cds.exceptionframework.ExceptionUtil;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.template.TemplateHelperInterface;
import gov.va.med.cds.util.LogMessageUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class ExceptionHandler
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(ExceptionHandler.class);
    private static final String REQUEST_ID_NOT_SET = "request_id_not_set";
    private static final String CDS_RESPONSE_TEMPLATE_ID = "CdsResponse400";
    private static final String PATHWAYS_RESPONSE_TEMPLATE_ID = "PathwaysResponse400";
    private static String cdsAppName = null;
    private static String pathwaysAppName = null;
    private static ExceptionLoggerInterface guaranteedLogger = null;
    private static TemplateHelperInterface templateHelper = null;
    private static ClinicalDataResponseInterface clinicalDataResponse = null;
    private static PathwaysDataResponseInterface pathwaysDataResponse = null;
    private static Map<String, PathwaysDataResponseInterface> pathwaysConfigurableResponseMap = null;
    private static Map<String, String> pathwaysFilterTemplateMap = null;

    public static Document handleException(Exception exception, String templateId, String requestId, String applicationName) {
        return ExceptionHandler.handleExceptionInternal(null, exception, templateId, requestId, applicationName);
    }

    public static Document handleException(Exception exception, String templateId, String filterRequest, String filterId, String requestId, String applicationName) {
        return ExceptionHandler.handleExceptionInternal(null, exception, templateId, filterRequest, filterId, requestId, applicationName);
    }

    public static Document handleException(Document clinicalDataDocument, Exception exception, String templateId, String requestId, String applicationName) {
        return ExceptionHandler.handleExceptionInternal(clinicalDataDocument, exception, templateId, requestId, applicationName);
    }

    private static Document handleExceptionInternal(Document clinicalDataDocument, Exception exception, String templateId, String requestId, String applicationName) {
        if (!StringUtils.hasText((String)templateId)) {
            if (applicationName.equals(cdsAppName)) {
                templateId = CDS_RESPONSE_TEMPLATE_ID;
            } else if (applicationName.equals(pathwaysAppName)) {
                templateId = PATHWAYS_RESPONSE_TEMPLATE_ID;
            }
        }
        if (!StringUtils.hasText((String)requestId)) {
            requestId = REQUEST_ID_NOT_SET;
        }
        if (!StringUtils.hasText((String)applicationName)) {
            applicationName = templateHelper.getApplicationName(templateId);
        }
        if (clinicalDataDocument == null) {
            clinicalDataDocument = ExceptionHandler.createClinicalDataDocument(templateId, requestId, applicationName);
        }
        if (exception instanceof AbstractCdsBaseException) {
            clinicalDataDocument = ExceptionHandler.handleCdsException((AbstractCdsBaseException)exception, clinicalDataDocument, templateId, requestId, applicationName);
        } else {
            ErrorCodeEnum errorCodeEnum = ErrorCodeEnum.ROOT_CAUSE_MSG;
            String[] msg = new String[]{"Non CDS exception occured in CDS Application: " + exception.getClass().getName() + " The message is: " + exception.getMessage()};
            String clientMessage = ExceptionUtil.formatMessage((String)errorCodeEnum.getClientMessage(), (String[])msg);
            SystemException se = new SystemException(errorCodeEnum, exception, clientMessage);
            clinicalDataDocument = ExceptionHandler.handleCdsException(se, clinicalDataDocument, templateId, requestId, applicationName);
        }
        return clinicalDataDocument;
    }

    private static Document handleExceptionInternal(Document clinicalDataDocument, Exception exception, String templateId, String requestXml, String filterId, String requestId, String applicationName) {
        ErrorCodeEnum errorCodeEnum;
        if (!StringUtils.hasText((String)templateId)) {
            if (applicationName.equals(cdsAppName)) {
                templateId = CDS_RESPONSE_TEMPLATE_ID;
            } else if (applicationName.equals(pathwaysAppName)) {
                templateId = ExceptionHandler.getPathwaysTemplateId(templateId, requestXml, filterId, requestId, applicationName);
            }
        }
        if (!StringUtils.hasText((String)requestId)) {
            requestId = REQUEST_ID_NOT_SET;
        }
        if (!StringUtils.hasText((String)applicationName)) {
            applicationName = cdsAppName;
        }
        if (clinicalDataDocument == null) {
            errorCodeEnum = ((AbstractCdsBaseException)exception).getErrorCode();
            clinicalDataDocument = errorCodeEnum.equals((Object)ErrorCodeEnum.READ_REQUEST_INPUT_PARAMETERS_NULL) ? ExceptionHandler.createClinicalDataDocument(templateId, requestXml, filterId, requestId, applicationName) : ExceptionHandler.createClinicalDataDocument(templateId, requestId, applicationName);
        }
        if (exception instanceof AbstractCdsBaseException) {
            clinicalDataDocument = ExceptionHandler.handleCdsException((AbstractCdsBaseException)exception, clinicalDataDocument, templateId, requestId, applicationName);
        } else {
            errorCodeEnum = ErrorCodeEnum.ROOT_CAUSE_MSG;
            String[] msg = new String[]{"Non CDS exception occured in CDS Application: " + exception.getClass().getName() + " The message is: " + exception.getMessage()};
            String clientMessage = ExceptionUtil.formatMessage((String)errorCodeEnum.getClientMessage(), (String[])msg);
            SystemException se = new SystemException(errorCodeEnum, exception, clientMessage);
            clinicalDataDocument = ExceptionHandler.handleCdsException(se, clinicalDataDocument, templateId, requestId, applicationName);
        }
        return clinicalDataDocument;
    }

    private static String getPathwaysTemplateId(String templateId, String requestXml, String filterId, String requestId, String applicationName) {
        if (!StringUtils.hasText((String)filterId)) {
            if (StringUtils.hasText((String)requestXml)) {
                filterId = ExceptionHandler.getFilterIdFromXml(templateId, requestXml, requestId, applicationName);
            }
            templateId = !StringUtils.hasText((String)filterId) ? PATHWAYS_RESPONSE_TEMPLATE_ID : pathwaysFilterTemplateMap.get(filterId);
        } else {
            templateId = pathwaysFilterTemplateMap.get(filterId);
        }
        if (!StringUtils.hasText((String)templateId)) {
            templateId = PATHWAYS_RESPONSE_TEMPLATE_ID;
        }
        return templateId;
    }

    public static void logRootException(Exception exception, String templateId, String requestId, String applicationName) {
        ErrorCodeEnum errorCodeEnum = ErrorCodeEnum.ROOT_CAUSE_MSG;
        String[] msg = new String[]{"Non CDS exception occured in CDS Application: " + exception.getClass().getName() + " The message is: " + exception.getMessage()};
        String clientMessage = ExceptionUtil.formatMessage((String)errorCodeEnum.getClientMessage(), (String[])msg);
        SystemException se = new SystemException(errorCodeEnum, exception, clientMessage);
        ExceptionInfo exceptionInfo = ExceptionHandler.getExceptionInfo((Throwable)((Object)se), clientMessage, errorCodeEnum, errorCodeEnum.getLoggingSeverity());
        ExceptionHandler.getGuaranteedLogger().log(exceptionInfo, clientMessage, templateId, requestId, applicationName);
    }

    private static Document createClinicalDataDocument(String templateId, String requestId, String applicationName) {
        Document clinicalDataDocument = null;
        PathwaysDataResponseInterface pathwaysResponse = null;
        if (applicationName.equals(pathwaysAppName)) {
            pathwaysResponse = ExceptionHandler.getPathwaysConfigurableDataResponse(templateId);
            if (pathwaysResponse == null) {
                pathwaysResponse = pathwaysDataResponse;
            }
            clinicalDataDocument = pathwaysResponse.buildEmptyPathwaysDocumentWithoutPatient(templateId, requestId);
        } else if (applicationName.equals(cdsAppName)) {
            clinicalDataDocument = clinicalDataResponse.buildEmptyClinicalDocumentWithoutPatient(templateId, requestId);
        }
        return clinicalDataDocument;
    }

    private static Document createClinicalDataDocument(String templateId, String requestXml, String filterId, String requestId, String applicationName) {
        Document clinicalDataDocument = null;
        PathwaysDataResponseInterface pathwaysResponse = null;
        if (applicationName.equals(pathwaysAppName)) {
            pathwaysResponse = ExceptionHandler.getConfiguredPathwaysDataResponse(templateId, requestXml, filterId, requestId, applicationName);
            clinicalDataDocument = templateId.equals(PATHWAYS_RESPONSE_TEMPLATE_ID) ? pathwaysResponse.buildEmptyPathwaysDocumentWithoutPatient(templateId, requestId) : pathwaysResponse.buildEmptyPathwaysDocumentWithPatient(templateId, requestId);
        } else if (applicationName.equals(cdsAppName)) {
            clinicalDataDocument = templateId.equals(CDS_RESPONSE_TEMPLATE_ID) ? clinicalDataResponse.buildEmptyClinicalDocumentWithoutPatient(templateId, requestId) : clinicalDataResponse.buildEmptyClinicalDocument(templateId, requestId);
        }
        return clinicalDataDocument;
    }

    private static PathwaysDataResponseInterface getConfiguredPathwaysDataResponse(String templateId, String requestXml, String filterId, String requestId, String applicationName) {
        PathwaysDataResponseInterface pathwaysResponse;
        if (templateId.equals(PATHWAYS_RESPONSE_TEMPLATE_ID)) {
            if (!StringUtils.hasText((String)filterId)) {
                if (!StringUtils.hasText((String)requestXml)) {
                    pathwaysResponse = pathwaysDataResponse;
                } else {
                    filterId = ExceptionHandler.getFilterIdFromXml(templateId, requestXml, requestId, applicationName);
                    pathwaysResponse = ExceptionHandler.getPathwaysConfigurableDataResponse(filterId);
                }
            } else {
                pathwaysResponse = ExceptionHandler.getPathwaysConfigurableDataResponse(filterId);
            }
        } else {
            pathwaysResponse = ExceptionHandler.getPathwaysConfigurableDataResponse(templateId);
        }
        if (pathwaysResponse == null) {
            pathwaysResponse = pathwaysDataResponse;
        }
        return pathwaysResponse;
    }

    private static String getFilterIdFromXml(String templateId, String requestXml, String requestId, String applicationName) {
        String filterId = null;
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read((InputStream)new ByteArrayInputStream(requestXml.getBytes()));
        }
        catch (DocumentException e) {
            logger.fatal((Object)LogMessageUtil.buildMessage((String)templateId, (String)requestId, (String)applicationName, (String)"Error parsing filter XML during the read request processing. "), (Throwable)e);
        }
        if (document != null) {
            Node filterIdNode = document.selectSingleNode("/filter:filter/filterId");
            filterId = ((Element)filterIdNode).getText();
        }
        return filterId;
    }

    private static Document handleCdsException(AbstractCdsBaseException cdsException, Document clinicalDocument, String templateId, String requestId, String applicationName) {
        ErrorCodeEnum errorCodeEnum = cdsException.getErrorCode();
        String clientMessage = ExceptionUtil.formatMessage((String)errorCodeEnum.getClientMessage(), (String[])cdsException.getCustomMsgValues());
        if (cdsException.getCause() != null) {
            clientMessage = String.format("%s%s%s", clientMessage, ": ", cdsException.getCause().getMessage());
        }
        ExceptionInfo exceptionInfo = ExceptionHandler.getExceptionInfo((Throwable)cdsException, clientMessage, errorCodeEnum, errorCodeEnum.getLoggingSeverity());
        ExceptionHandler.getGuaranteedLogger().log(exceptionInfo, clientMessage, templateId, requestId, applicationName);
        ErrorSectionHelperInterface errorSectionHelper = ExceptionHandler.getErrorSectionHelper(templateId);
        if (errorSectionHelper == null) {
            if (applicationName.equals(cdsAppName)) {
                templateId = CDS_RESPONSE_TEMPLATE_ID;
            } else if (applicationName.equals(pathwaysAppName)) {
                templateId = PATHWAYS_RESPONSE_TEMPLATE_ID;
            }
            clinicalDocument = ExceptionHandler.createClinicalDataDocument(templateId, requestId, applicationName);
            errorSectionHelper = ExceptionHandler.getErrorSectionHelper(templateId);
        }
        return errorSectionHelper.buildErrorSection(clinicalDocument, exceptionInfo, requestId);
    }

    private static ErrorSectionHelperInterface getErrorSectionHelper(String templateId) {
        ErrorSectionHelperInterface errorSectionHelper = null;
        if (!StringUtils.hasText((String)templateId)) {
            throw new InitializationException(ErrorCodeEnum.TEMPLATE_ID_NULL);
        }
        errorSectionHelper = templateHelper.getErrorSectionHelper(templateId);
        return errorSectionHelper;
    }

    public static void setGuaranteedLogger(ExceptionLoggerInterface guaranteedLogger) {
        ExceptionHandler.guaranteedLogger = guaranteedLogger;
    }

    public static void setTemplateHelper(TemplateHelperInterface templateHelper) {
        ExceptionHandler.templateHelper = templateHelper;
    }

    public static void setClinicalDataResponse(ClinicalDataResponseInterface clinicalDataResponse) {
        ExceptionHandler.clinicalDataResponse = clinicalDataResponse;
    }

    private static ExceptionInfo getExceptionInfo(Throwable businessException, String clientMessage, ErrorCodeEnum errorCode, LoggingSeverity loggingSeverity) {
        ExceptionInfo exceptionInfo = new ExceptionInfo();
        exceptionInfo.setClientMessage(clientMessage);
        exceptionInfo.setErrorCode(errorCode);
        exceptionInfo.setException(businessException);
        exceptionInfo.setExceptionMessage(businessException.getMessage());
        exceptionInfo.setLoggingSeverity(loggingSeverity);
        return exceptionInfo;
    }

    public static ExceptionLoggerInterface getGuaranteedLogger() {
        return guaranteedLogger;
    }

    public void afterPropertiesSet() throws Exception {
        if (guaranteedLogger == null) {
            throw new InitializationException(ErrorCodeEnum.GUARANTEED_LOGGER_NOT_CONFIGURED_AND_NULL);
        }
        if (templateHelper == null) {
            throw new InitializationException(ErrorCodeEnum.TEMPLATE_HELPER_CONFIGURATION_EXCEPTION, this.getClass().getName());
        }
        if (clinicalDataResponse == null) {
            throw new InitializationException(ErrorCodeEnum.MISSING_CLINICAL_DATA_RESPONSE_EXCEPTION, this.getClass().getName());
        }
        if (pathwaysConfigurableResponseMap == null) {
            throw new InitializationException(ErrorCodeEnum.MISSING_CONFIGURABLE_PATHWAYS_DATA_RESPONSE_MAP_EXCEPTION, this.getClass().getName());
        }
    }

    public static boolean hasErrors(Document clinicalDataDocument, String templateId) {
        return templateHelper.getErrorSectionHelper(templateId).getErrorCount(ErrorSectionHelperInterface.ErrorType.ALL, clinicalDataDocument) > 0;
    }

    public static TemplateHelperInterface getTemplateHelper() {
        return templateHelper;
    }

    public static ClinicalDataResponseInterface getClinicalDataResponse() {
        return clinicalDataResponse;
    }

    public static void setPathwaysConfigurableResponseMap(Map<String, PathwaysDataResponseInterface> pathwaysConfigurableResponseMap) {
        ExceptionHandler.pathwaysConfigurableResponseMap = pathwaysConfigurableResponseMap;
    }

    public static void setCdsAppName(String cdsAppName) {
        ExceptionHandler.cdsAppName = cdsAppName;
    }

    public static void setPathwaysAppName(String pathwaysAppName) {
        ExceptionHandler.pathwaysAppName = pathwaysAppName;
    }

    private static PathwaysDataResponseInterface getPathwaysConfigurableDataResponse(String id) {
        PathwaysDataResponseInterface configurablePathwaysDataResponse = null;
        configurablePathwaysDataResponse = pathwaysConfigurableResponseMap.get(id);
        return configurablePathwaysDataResponse;
    }

    public static void setPathwaysDataResponse(PathwaysDataResponseInterface pathwaysDataResponse) {
        ExceptionHandler.pathwaysDataResponse = pathwaysDataResponse;
    }

    public static void setPathwaysFilterTemplateMap(Map<String, String> pathwaysFilterTemplateMap) {
        ExceptionHandler.pathwaysFilterTemplateMap = pathwaysFilterTemplateMap;
    }
}

