/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.idm.client;

import gov.va.med.cds.checksum.util.IcnChecksum;
import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierCorrelationServiceInterface;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.IdmPersonServiceException;
import gov.va.med.cds.idm.client.IdmPersonServiceInterface;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdmPersonIdentifierManagement
implements PersonIdentifierCorrelationServiceInterface {
    private static Log logger = LogFactory.getLog(IdmPersonIdentifierManagement.class);
    private static final int LENGTH_ICN_WITHOUT_CHECKSUM = 10;
    private String correspondingIdsRequestXml;
    private IdmPersonServiceInterface idmPersonService;

    public Collection<PersonIdentifierInterface> obtainPersonIdentifiers(PersonIdentifierInterface personIdentifier) {
        this.addChecksumIfNeeded(personIdentifier);
        String idmrequestXml = this.correspondingIdsRequestXml.replace("%%REPLACE_ICN_VALUE%%", personIdentifier.getIdentity());
        idmrequestXml = idmrequestXml.replace("%%REPLACE_ASSIGINING_FACILITY%%", personIdentifier.getAssigningFacility());
        idmrequestXml = idmrequestXml.replace("%%REPLACE_ASSIGINING_AUTHORITY%%", personIdentifier.getAssigningAuthority());
        String idmResponseXml = "";
        long sentTime = new Date().getTime();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("IDM request '" + idmrequestXml + "'"));
        }
        try {
            idmResponseXml = this.idmPersonService.getCorrespondingIds(idmrequestXml);
        }
        catch (Exception e) {
            throw new IdmPersonServiceException(ErrorCodeEnum.IDM_SERVICE_EXCEPTION, e, e.getMessage());
        }
        long elapsedTime = new Date().getTime() - sentTime;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Recieved IDM response '" + idmResponseXml + "' in " + elapsedTime + " milliseconds"));
        }
        return this.toPersonIdentifiers(idmResponseXml, personIdentifier);
    }

    private void addChecksumIfNeeded(PersonIdentifierInterface personIdentifier) {
        if (personIdentifier == null) {
            throw new IdmPersonServiceException(ErrorCodeEnum.IDM_NULL_PERSON_IDENTIFIER_EXCEPTION);
        }
        String identity = personIdentifier.getIdentity();
        if (identity == null) {
            throw new IdmPersonServiceException(ErrorCodeEnum.IDM_NULL_PERSON_IDENTITY_EXCEPTION);
        }
        if (identity.length() == 10) {
            logger.info((Object)"ICN has no checksum - calculating and adding checksum to ICN now.");
            personIdentifier.setIdentity(IcnChecksum.addChecksumToIcn((String)identity));
        }
    }

    private Collection<PersonIdentifierInterface> toPersonIdentifiers(String idmResponseXml, PersonIdentifierInterface sourceIdentifier) {
        ArrayList<PersonIdentifierInterface> personIdentifiers = new ArrayList<PersonIdentifierInterface>();
        ArrayList<PersonIdentifier> historicalPersonIdentifiers = new ArrayList<PersonIdentifier>();
        if (idmResponseXml.contains("IDM_RESPONSE type='GET_CORRESPONDING_IDS'")) {
            ByteArrayInputStream is = new ByteArrayInputStream(idmResponseXml.getBytes());
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setExpandEntityReferences(false);
                DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
                Document idmResponseDoc = db.parse(is);
                NodeList identifierList = idmResponseDoc.getElementsByTagName("IDENTIFIER");
                for (int i = 0; i < identifierList.getLength(); ++i) {
                    Node identifierNode = identifierList.item(i);
                    if (identifierNode.getNodeType() != 1) continue;
                    PersonIdentifier personIdentifier = new PersonIdentifier();
                    PersonIdentifier historicalPersonIdentifier = new PersonIdentifier();
                    Element identifierElement = (Element)identifierNode;
                    Element statusElement = (Element)identifierElement.getElementsByTagName("STATUS").item(0);
                    String statusValue = statusElement.getChildNodes().item(0).getNodeValue().trim();
                    Element idValueElement = (Element)identifierElement.getElementsByTagName("ID").item(0);
                    String idValue = idValueElement.getChildNodes().item(0).getNodeValue().trim();
                    if (!statusValue.equals("H")) {
                        personIdentifier.setIdentity(idValue);
                    } else {
                        historicalPersonIdentifier.setIdentity(idValue);
                    }
                    if (!identifierElement.hasAttribute("subtype") || !"IDM".equals(identifierElement.getAttribute("subtype"))) {
                        Element sourceValueElement = (Element)identifierElement.getElementsByTagName("SOURCE").item(0);
                        String sourceValue = sourceValueElement.getChildNodes().item(0).getNodeValue().trim();
                        String string = sourceValue = null == sourceValue ? "" : sourceValue;
                        if (!statusValue.equals("H")) {
                            personIdentifier.setAssigningFacility(sourceValue);
                        } else {
                            historicalPersonIdentifier.setAssigningFacility(sourceValue);
                        }
                        Element issuerValueElement = (Element)identifierElement.getElementsByTagName("ISSUER").item(0);
                        String issuerValue = issuerValueElement.getChildNodes().item(0).getNodeValue().trim();
                        String string2 = issuerValue = null == issuerValue ? "" : issuerValue;
                        if (!statusValue.equals("H")) {
                            personIdentifier.setAssigningAuthority(issuerValue);
                        } else {
                            historicalPersonIdentifier.setAssigningAuthority(issuerValue);
                        }
                    } else if (sourceIdentifier.getIdentity().equals(idValue)) {
                        if (!statusValue.equals("H")) {
                            personIdentifier.setAssigningFacility(sourceIdentifier.getAssigningFacility());
                        } else {
                            historicalPersonIdentifier.setAssigningFacility(sourceIdentifier.getAssigningFacility());
                        }
                        if (!statusValue.equals("H")) {
                            personIdentifier.setAssigningAuthority(sourceIdentifier.getAssigningAuthority());
                        } else {
                            historicalPersonIdentifier.setAssigningAuthority(sourceIdentifier.getAssigningAuthority());
                        }
                    } else if (identifierElement.hasAttribute("type") && "NI".equals(identifierElement.getAttribute("type"))) {
                        if (!statusValue.equals("H")) {
                            personIdentifier.setAssigningFacility("200M");
                            personIdentifier.setAssigningAuthority("USVHA");
                        } else {
                            historicalPersonIdentifier.setAssigningFacility("200M");
                            historicalPersonIdentifier.setAssigningAuthority("USVHA");
                        }
                    } else if (!statusValue.equals("H")) {
                        personIdentifier.setAssigningFacility("");
                        personIdentifier.setAssigningAuthority("");
                    } else {
                        historicalPersonIdentifier.setAssigningFacility("");
                        historicalPersonIdentifier.setAssigningAuthority("");
                    }
                    if (personIdentifier.getIdentity() != null) {
                        personIdentifiers.add((PersonIdentifierInterface)personIdentifier);
                    }
                    if (historicalPersonIdentifier.getIdentity() == null) continue;
                    historicalPersonIdentifiers.add(historicalPersonIdentifier);
                }
            }
            catch (Exception exception) {
                throw new IdmPersonServiceException(ErrorCodeEnum.IDM_RESPONSE_PROCESSING_EXCEPTION, exception);
            }
        } else if (idmResponseXml.contains("IDM_RESPONSE type='ERROR'")) {
            throw new IdmPersonServiceException(ErrorCodeEnum.IDM_ERROR_RESPONSE, sourceIdentifier.getIdentity(), idmResponseXml);
        }
        for (PersonIdentifierInterface personIdentifierInterface : historicalPersonIdentifiers) {
            personIdentifiers.add(personIdentifierInterface);
        }
        return personIdentifiers;
    }

    public void setIdmPersonService(IdmPersonServiceInterface idmPersonService) {
        this.idmPersonService = idmPersonService;
    }

    public void setCorrespondingIdsRequestXml(String correspondingIdsRequestXml) {
        this.correspondingIdsRequestXml = correspondingIdsRequestXml;
    }
}

