/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.template;

import gov.va.med.hds.hdr.transformer.template.InstanceData;
import gov.va.med.hds.hdr.transformer.template.TemplateBuilderDelegate;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XMLTemplateBuilderDelegate
implements TemplateBuilderDelegate {
    private static final String XP_INSTANCE = "instance[@type='TYPE' and @role='ROLE']";
    private static final String XP_ATTRIBUTE = "attribute[@name='NAME' and @type='TYPE']";
    private static final String XP_FIELD = "field[@name='NAME']";

    public Object createAttribute(String name, String type) {
        Element domainValue = DocumentHelper.createElement((String)"attribute");
        domainValue.addAttribute("name", name);
        domainValue.addAttribute("type", type);
        return domainValue;
    }

    public Object createInstance(InstanceData instanceData) {
        Element instance = DocumentHelper.createElement((String)"instance");
        instance.addAttribute("type", instanceData.getType());
        instance.addAttribute("role", instanceData.getRole());
        return instance;
    }

    public Object createField(String name, String type) {
        Element field = DocumentHelper.createElement((String)"field");
        field.addAttribute("name", name);
        return field;
    }

    public void addContent(Object parent, String name, Object content) {
        Element parentElement = (Element)parent;
        Element contentElement = (Element)content;
        parentElement.add(contentElement);
    }

    public void appendFieldValue(Object parent, Object f, String text, char separator) {
        Element field = (Element)f;
        String value = field.getText();
        if (value.length() > 0 && separator > '\u0000') {
            value = value + separator;
        }
        value = value + text;
        field.setText(value);
    }

    public void setFieldValue(Object parent, Object field, String value) {
        ((Element)field).setText(value);
    }

    public Object getInstanceHavingTypeAndRole(Object parent, final InstanceData instanceData) {
        Object obj = null;
        List l = this.filterChildren((Element)parent, new Filter(){

            public boolean matches(Object o) {
                Element e = (Element)o;
                return e.getName().equals("instance") && e.attribute("type").getText().equals(instanceData.getType()) && e.attribute("role").getText().equals(instanceData.getRole());
            }
        });
        if (l != null && l.size() > 0) {
            obj = l.get(l.size() - 1);
        }
        return obj;
    }

    public Object getAttributeHavingNameAndType(Object parent, final String name, final String type) {
        Object obj = null;
        List l = this.filterChildren((Element)parent, new Filter(){

            public boolean matches(Object o) {
                Element e = (Element)o;
                return e.getName().equals("attribute") && e.attribute("name").getText().equals(name) && e.attribute("type").getText().equals(type);
            }
        });
        if (l != null && l.size() > 0) {
            obj = l.get(l.size() - 1);
        }
        return obj;
    }

    public Object getFieldHavingName(Object parent, final String name) {
        Object obj = null;
        List l = this.filterChildren((Element)parent, new Filter(){

            public boolean matches(Object o) {
                Element e = (Element)o;
                return e.getName().equals("field") && e.attribute("name").getText().equals(name);
            }
        });
        if (l != null && l.size() > 0) {
            obj = l.get(l.size() - 1);
        }
        return obj;
    }

    private List filterChildren(Element parent, Filter filter) {
        ArrayList matches = new ArrayList();
        List children = parent.elements();
        for (Object o : children) {
            if (!filter.matches(o)) continue;
            matches.add(o);
        }
        return matches;
    }

    private static interface Filter {
        public boolean matches(Object var1);
    }
}

